<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

wp_enqueue_script('jquery-ui-datepicker');
wp_enqueue_media();
wp_enqueue_script( 'findgo-upload', get_template_directory_uri() . '/js/upload.js', array( 'jquery' ), '20150330', true );

wp_enqueue_script( 'wp-job-manager-ajax-file-upload' );
?>
<div class="widget widget-edit-profile <?php echo esc_attr($el_class); ?>">
<?php
if ( ! is_user_logged_in() ) {
	?>
	<div class="text-warning"><?php  esc_html_e( 'Please sign in before accessing this page.', 'findgo' ); ?></div>
	<?php
} else {
	$user = wp_get_current_user();
	$data = get_userdata( $user->ID );
	$avatar = get_the_author_meta( 'apus_user_avatar', $user->ID );
	$avatar_url = wp_get_attachment_image_src($avatar, 'full');
	$address = get_the_author_meta( 'apus_address', $user->ID );
	$birthday = get_the_author_meta( 'apus_birthday', $user->ID );
	$marital_status = get_the_author_meta( 'apus_marital_status', $user->ID );
	$sex = get_the_author_meta( 'apus_sex', $user->ID );
?>
	<h3 class="title"><?php esc_html_e('Profile Detail', 'findgo'); ?></h3>
	<div class="content-inner">
		<form method="post" action="" class="change-profile-form form-horizontal">
			<div class="space-10">
				<label class="control-label" for="change-profile-form-avatar"><?php echo esc_html__( 'Change Avatar', 'findgo' ); ?></label>
				<div class="clearfix">

					<div class="job-manager-uploaded-files">
						<?php if (  $avatar ) { ?>
							<div class="job-manager-uploaded-file">
								<?php
								$image_src = wp_get_attachment_image_src( absint( $avatar ) );
								$image_src = $image_src ? $image_src[0] : '';

								$extension = ! empty( $extension ) ? $extension : substr( strrchr( $image_src, '.' ), 1 );

								if ( 3 !== strlen( $extension ) || in_array( $extension, array( 'jpg', 'gif', 'png', 'jpeg', 'jpe' ) ) ) : ?>
									<span class="job-manager-uploaded-file-preview"><img src="<?php echo esc_url( $image_src ); ?>" /> <a class="job-manager-remove-uploaded-file" href="#"><i class="ap-close" aria-hidden="true"></i></a></span>
								<?php else : ?>
									<span class="job-manager-uploaded-file-name"><code><?php echo esc_html( basename( $image_src ) ); ?></code> <a class="job-manager-remove-uploaded-file" href="#"><i class="ap-close" aria-hidden="true"></i></a></span>
								<?php endif; ?>

								<input type="hidden" class="input-text" name="user_avatar" value="<?php echo esc_attr( $avatar ); ?>" />
							</div>
						<?php } ?>
					</div>
					<input id="upload-image-avarta" class="widefat wp-job-manager-file-upload input-text hidden" name="user_avatar" type="file" value="<?php echo esc_attr($avatar); ?>" data-file_types="jpg|jpeg|jpe|gif|png"/>
					<label for="upload-image-avarta" class="label-can-drag">
						<div class="form-group group-upload">
					        <span class="title-upload"><?php esc_html_e('Drop file to upload', 'findgo'); ?></span>
					        <span class="break"><?php esc_html_e('or', 'findgo'); ?></span>
					        <div class="upload-file-btn">
					            <i class="ap-camera"></i>
					            <span><?php esc_html_e('Avatar Image', 'findgo'); ?></span>
					        </div>
					    </div>
					</label>
		        </div>
			</div><!-- /.form-group -->
			<div class="row">
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-first-name"><?php echo esc_html__( 'First name', 'findgo' ); ?></label>
					<div class="clearfix">
						<input id="change-profile-form-first-name" type="text" name="first_name" class="form-control" value="<?php echo ! empty( $data->first_name ) ? esc_attr( $data->first_name ) : ''; ?>">
					</div>
				</div><!-- /.form-group -->
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-last-name"><?php echo esc_html__( 'Last name', 'findgo' ); ?></label>
					<div class="clearfix">
						<input id="change-profile-form-last-name" type="text" name="last_name" class="form-control" value="<?php echo ! empty( $data->last_name ) ? esc_attr( $data->last_name ) : ''; ?>">
					</div>
				</div><!-- /.form-group -->
			</div>
			<div class="row">
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-nickname"><?php echo esc_html__( 'Nickname', 'findgo' ); ?> <sup>(*)<sup></label>
					<div class="clearfix">
						<input id="change-profile-form-nickname" type="text" name="nickname" class="form-control" value="<?php echo ! empty( $data->nickname ) ? esc_attr( $data->nickname ) : ''; ?>" required="required">
					</div>
				</div><!-- /.form-group -->
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-email"><?php echo esc_html__( 'E-mail', 'findgo' ); ?> <sup>(*)<sup></label>
					<div class="clearfix">
						<input id="change-profile-form-email" type="email" name="email" class="form-control" value="<?php echo ! empty( $data->user_email ) ? esc_attr( $data->user_email ) : ''; ?>"  required="required">
					</div>
				</div><!-- /.form-group -->
			</div>
			<div class="row">
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-phone"><?php echo esc_html__( 'Phone', 'findgo' ); ?></label>
					<div class="clearfix">
						<input id="change-profile-form-phone" type="text" name="phone" class="form-control" value="<?php echo ! empty( $data->phone ) ? esc_attr( $data->phone ) : ''; ?>">
					</div>
				</div><!-- /.form-group -->
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-address"><?php echo esc_html__( 'Address', 'findgo' ); ?></label>
					<div class="clearfix">
						<input id="change-profile-form-address" type="text" name="address" class="form-control" value="<?php echo ! empty( $address ) ? esc_attr( $address ) : ''; ?>">
					</div>
				</div><!-- /.form-group -->
			</div>
			<div class="row">
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-url"><?php echo esc_html__( 'Website', 'findgo' ); ?></label>
					<div class="clearfix">
						<input id="change-profile-form-url" type="text" name="url" class="form-control" value="<?php echo ! empty( $data->url ) ? esc_attr( $data->url ) : ''; ?>">
					</div>
				</div><!-- /.form-group -->
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-birthday"><?php echo esc_html__( 'Birthday', 'findgo' ); ?></label>
					<div class="clearfix">
						<input id="change-profile-form-birthday" type="text" name="birthday" class="form-control" value="<?php echo ! empty( $birthday ) ? esc_attr( $birthday ) : ''; ?>">
					</div>
				</div><!-- /.form-group -->
			</div>
			<div class="row">
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-marital_status"><?php echo esc_html__( 'Marital status', 'findgo' ); ?></label>
					<div class="clearfix">
						<select name="marital_status" class="form-control">
							<?php $options = findgo_marital_status_defaults(); foreach ($options as $key => $label) { ?>
								<option value="<?php echo esc_attr($key); ?>" <?php echo trim($key == $marital_status ? 'selected="selected"' : ''); ?>><?php echo esc_attr($label); ?></option>
							<?php } ?>
						</select>
					</div>
				</div><!-- /.form-group -->
				<div class="form-group col-sm-6 col-xs-12">
					<label class="control-label" for="change-profile-form-sex"><?php echo esc_html__( 'Sex', 'findgo' ); ?></label>
					<div class="clearfix">
						<div class="visible-inline-block">
						<?php $options = findgo_sex_defaults(); foreach ($options as $key => $label) { ?>
							<div class="sex-options">
								<input type="radio" name="sex" id="<?php echo esc_attr($key); ?>" value="<?php echo esc_attr($key); ?>" <?php echo trim($key == $sex ? 'checked="checked"' : ''); ?>> <label for="<?php echo esc_attr($key); ?>"><?php echo esc_attr($label); ?></label>
							</div>
						<?php } ?>
						</div>
					</div>
				</div><!-- /.form-group -->
			</div>
			<div class="row">
				<?php
					$options = findgo_user_social_defaults();
					$socials = get_user_meta( $user->ID, 'apus_socials', true );
					foreach ($options as $key => $label) {
						$value = isset($socials[$key]) ? $socials[$key] : '';
						?>
						<div class="form-group col-xs-12 col-sm-6">
							<label class="control-label <?php echo esc_attr($key); ?>" for="change-profile-form-<?php echo esc_attr($key); ?>"> <i class="fa fa-<?php echo esc_attr($key); ?>"></i> <?php echo esc_attr($label); ?></label>
							<div class="clearfix">
								<input id="change-profile-form-<?php echo esc_attr($key); ?>" type="text" name="socials[<?php echo esc_attr($key); ?>]" class="form-control" value="<?php echo esc_attr( $value ); ?>">
							</div>
						</div><!-- /.form-group -->
						<?php
					}
				?>
			</div>
			<div class="form-group">
				<label class="control-label" for="change-profile-form-about"><?php echo esc_html__( 'About', 'findgo' ); ?></label>
				<div class="clearfix">
					<textarea id="change-profile-form-about" class="form-control" name="description" cols="70" rows="5"><?php echo ! empty( $data->description ) ? esc_attr( $data->description ) : ''; ?></textarea>
				</div>
			</div><!-- /.form-group -->
			<div class="form-group no-margin">
				<div class="clearfix">
					<button type="submit" name="change_profile_form" class="button btn btn-theme"><?php echo esc_html__( 'Change Profile', 'findgo' ); ?></button>
					<div class="msg clearfix"></div>
				</div>
			</div>
		</form>
	</div>
	<div class="change-password">
		<h3 class="title"><?php esc_html_e('Change password', 'findgo'); ?></h3>
		<form method="post" action="" class="change-password-form form-horizontal">
			<div class="form-group">
				<label class="control-label" for="change-profile-form-old-pass"><?php echo esc_html__( 'Old Password', 'findgo' ); ?></label>
				<div class="clearfix">
					<input id="change-profile-form-old-pass" type="password" name="old_password" class="form-control" value="">
				</div>
			</div><!-- /.form-group -->
			<div class="form-group">
				<label class="control-label" for="change-profile-form-new-pass"><?php echo esc_html__( 'New Password', 'findgo' ); ?></label>
				<div class="clearfix">
					<input id="change-profile-form-new-pass" type="password" name="new_password" class="form-control" value="">
				</div>
			</div><!-- /.form-group -->
			<div class="form-group">
				<label class="control-label" for="change-profile-form-retype-pass"><?php echo esc_html__( 'Retype Password', 'findgo' ); ?></label>
				<div class="clearfix">
					<input id="change-profile-form-retype-pass" type="password" name="retype_password" class="form-control" value="">
				</div>
			</div><!-- /.form-group -->
			<div class="form-group no-margin">
				<div class="clearfix">
					<button type="submit" name="change_password_form" class="button btn btn-theme "><?php echo esc_html__( 'Change Password', 'findgo' ); ?></button>
					<div class="msg clearfix"></div>
				</div>
			</div>
			
		</form>
	</div>
<?php } ?>
</div>