<?php
$atts = vc_map_get_attributes( $this->getShortcode(), $atts );
extract( $atts );

$bcol = 12/$columns;
$args = array(
	'post_type' => 'apus_brand',
	'posts_per_page' => $number
);
$loop = new WP_Query($args);
?>
<div class="widget-brands <?php echo esc_attr($el_class.' '.$effect); ?>">
    <?php if ($title!=''): ?>
        <h2 class="widget-title title-md text-white text-center">
            <span><?php echo esc_attr( $title ); ?></span>
            <?php if ( isset($subtitle) && $subtitle ): ?>
                <span class="subtitle"><?php echo esc_html($subtitle); ?></span>
            <?php endif; ?>
        </h2>
    <?php endif; ?>
    <div class="widget-content">
    	<?php if ( $loop->have_posts() ): ?>
    		<?php if ( $layout_type == 'carousel' ): ?>
    			<div class="slick-carousel" data-carousel="slick" data-items="<?php echo esc_attr($columns); ?>" <?php echo ($columns>=5)?'data-large="5"':''; ?> data-smallmedium="4" data-extrasmall="3" data-smallest="3" data-pagination="false" data-nav="true">
		    		<?php while ( $loop->have_posts() ): $loop->the_post(); ?>
		    			<div class="item">
			                <?php $link = get_post_meta( get_the_ID(), 'apus_brand_link', true); ?>
			                <?php $link = $link ? $link : '#'; ?>
							<a href="<?php echo esc_url($link); ?>" target="_blank">
								<?php the_post_thumbnail( 'full' ); ?>
							</a>
				        </div>
		    		<?php endwhile; ?>
	    		</div>
	    	<?php else: ?>
	    		<div class="row">
		    		<?php while ( $loop->have_posts() ): $loop->the_post(); ?>
		    			<div class="col-md-<?php echo esc_attr($bcol); ?>">
			                <?php $link = get_post_meta( get_the_ID(), 'apus_brand_link', true); ?>
			                <?php $link = $link ? $link : '#'; ?>
							<a href="<?php echo esc_url($link); ?>" target="_blank">
								<?php the_post_thumbnail( 'thumbnail' ); ?>
							</a>
				        </div>
		    		<?php endwhile; ?>
	    		</div>
	    	<?php endif; ?>
    	<?php endif; ?>
    	<?php wp_reset_postdata(); ?>
    </div>
</div>