<?php $thumbsize = !isset($thumbsize) ? findgo_get_blog_thumbsize() : $thumbsize;?>
<?php $categories = get_the_category(); ?>
<article <?php post_class('post list-default'); ?>>
    <div class="row list-inner">
        <?php
            $thumb = findgo_display_post_thumb($thumbsize);
            if ( !empty($thumb) ) {
                ?>
                <div class="col-sm-5 image">
                    <?php echo trim($thumb); ?>
                </div>
                <?php
            }
        ?>
        <div class="col-sm-<?php echo esc_attr(!empty($thumb) ? '7' : '12'); ?> info">
          <div class="info-content">
            <?php
                if (get_the_title()) {
                ?>
                    <h3 class="entry-title">
                        <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                    </h3>
                <?php
            }
            ?>
            <div class="entry-meta">
                <span class="author"><i class="fa fa-user-o" aria-hidden="true"></i> <?php the_author_posts_link(); ?></span>
                <span class="comment"><i class="fa fa-comment-o" aria-hidden="true"></i> <?php comments_number( esc_html__('0 Comments', 'findgo'), esc_html__('1 Comment', 'findgo'), esc_html__('% Comments', 'findgo') ); ?></span>
                <?php if ( ! empty( $categories ) ) { ?>
                        <span class="date"><i class="fa fa-folder-o" aria-hidden="true"></i>
                        <?php echo esc_html( $categories[0]->name ); ?>
                    </span>
                <?php } ?>
            </div>
            <?php if ( has_excerpt() ) { ?>
                <div class="description"><?php echo findgo_substring( get_the_excerpt(), 25, '...' ); ?></div>
            <?php } else { ?>
                <div class="description"><?php echo findgo_substring( get_the_content(), 25, '...' ); ?></div>
            <?php } ?>
          </div>
        </div>
    </div>
</article>