(function ($) {
    "use strict";
	var listingLocation = {
		init: function() {
			var self = this;

			self.initializeMap();
		},
		initializeMap: function() {
			var maps = [];
			if ( $('.findgo-location-field').length > 0 ) {

				var mapInstance = $('.findgo-location-field');
				var searchInput = mapInstance.find( '.input-location-field' );
				var mapCanvas = mapInstance.find( '.findgo-location-field-map' );
				var latitude = mapInstance.find( '.geo_latitude' );
				var longitude = mapInstance.find( '.geo_longitude' );
				var latLng = new google.maps.LatLng( 54.800685, -4.130859 );
				var zoom = 5;

				// If we have saved values, let's set the position and zoom level
				if ( latitude.val().length > 0 && longitude.val().length > 0 ) {
					latLng = new google.maps.LatLng( latitude.val(), longitude.val() );
					zoom = 17;
				}

				// Map
				var mapOptions = {
					center: latLng,
					zoom: zoom
				};
				var map = new google.maps.Map( mapCanvas[0], mapOptions );

				latitude.on('change', function() {
					map.setCenter( new google.maps.LatLng( latitude.val(), longitude.val() ) );
				});

				longitude.on('change', function() {
					map.setCenter( new google.maps.LatLng( latitude.val(), longitude.val() ) );
				});

				// Marker
				var markerOptions = {
					map: map,
					draggable: true,
					title: 'Drag to set the exact location'
				};
				var marker = new google.maps.Marker( markerOptions );

				if ( latitude.val().length > 0 && longitude.val().length > 0 ) {
					marker.setPosition( latLng );
				}

				// Search
				var autocomplete = new google.maps.places.Autocomplete( searchInput[0] );
				autocomplete.bindTo( 'bounds', map );

				google.maps.event.addListener( autocomplete, 'place_changed', function() {
					var place = autocomplete.getPlace();
					if ( ! place.geometry ) {
						return;
					}

					if ( place.geometry.viewport ) {
						map.fitBounds( place.geometry.viewport );
					} else {
						map.setCenter( place.geometry.location );
						map.setZoom( 17 );
					}

					marker.setPosition( place.geometry.location );

					latitude.val( place.geometry.location.lat() );
					longitude.val( place.geometry.location.lng() );
				});

				$( searchInput ).keypress( function( event ) {
					if ( 13 === event.keyCode ) {
						event.preventDefault();
					}
				});

				// Allow marker to be repositioned
				google.maps.event.addListener( marker, 'drag', function() {
					latitude.val( marker.getPosition().lat() );
					longitude.val( marker.getPosition().lng() );
				});

				maps.push( map );
			}
		},
	}
	listingLocation.init();

	function getLocation(position) {
        $('.geo_latitude').val(position.coords.latitude);
        $('.geo_longitude').val(position.coords.longitude);
        $('.input-location-field').val('Location');
        $('.geo_longitude').change();
        
        var geocoder = new google.maps.Geocoder();
        var latLng = new google.maps.LatLng(position.coords.latitude, position.coords.longitude);

        if (geocoder) {
            geocoder.geocode({ 'latLng': latLng}, function (results, status) {
                if (status == google.maps.GeocoderStatus.OK) {
                    $('.input-location-field').val(results[0].formatted_address);
                }
            });
        }
        return $('.find-me-location').removeClass('loading');
    }
    function getErrorLocation(position) {
        return $('.find-me-location').removeClass('loading');
    }
    $('body').on('click', '.find-me-location', function() {
        $(this).addClass('loading');
        navigator.geolocation.getCurrentPosition(getLocation, getErrorLocation);
    });
})(jQuery);


