(function () {
	"use strict";
	jQuery(document).ready(function($) {
		$('body').delegate(".input_datetime", 'mouseenter', function(e){
            e.preventDefault();
            $(this).datepicker({
	               defaultDate: "",
	               dateFormat: "yy-mm-dd",
	               numberOfMonths: 1,
	               showButtonPanel: true,
            });
        });

        $( "body" ).on( "click", ".apus-checkbox", function() {
			jQuery('.'+this.id).toggle();
	    });
	    $('.apus-wpcolorpicker').each(function(){
	    	$(this).wpColorPicker();
	    });

	    if( $('.p_input_search_keyword').is(':checked') ) {
			$('.p_show_search_suggestions').show();
		}
		$('.p_input_search_keyword').change(function(){
			if( $('.p_input_search_keyword').is(':checked') ) {
				$('.p_show_search_suggestions').slideToggle();
			}
		});

		// section
		$('.add-new-section-menu-price').on('click', function(e){
            e.preventDefault();
            var length = $('.menu-prices-field-wrapper .menu-prices-section-item').length;
            var html = $('.menu-prices-field-wrapper .menu-prices-section-item').eq(0).clone(true);
            html.find('.input-section-title').attr('name', "_job_menu_prices["+length+"][section_title]");
            html.find('.input-section-item-title').attr('name', "_job_menu_prices["+length+"][title][]");
            html.find('.input-section-item-price').attr('name', "_job_menu_prices["+length+"][price][]");
            html.find('.input-section-item-description').attr('name', "_job_menu_prices["+length+"][description][]");

            $('.menu-prices-field-wrapper').append(html);
        });

        $('.remove-section-menu-price').on('click', function(e) {
            e.preventDefault();
            var index = $('.menu-prices-field-wrapper .menu-prices-section-item').last().index();
            if ( index > 0 ) {
                $('.menu-prices-field-wrapper .menu-prices-section-item').eq(index).remove();
            }
        });

		// section item
		$('body').on('click', '.add-new-menu-price', function(e){
			e.preventDefault();
			var parent = $(this).parent();
			parent.find('.menu-prices-section-item-wrapper').append( $('.menu-prices-item', parent).eq(0).clone(true) );
		});
		$('body').on('click', '.remove-menu-price', function(e){
			e.preventDefault();
			var parent = $(this).parent();

			var index = $('.menu-prices-item', parent).last().index();
			if ( index > 0 ) {
				$('.menu-prices-item', parent).eq(index).remove();
			}
		});

		
	});

	
} )( jQuery );