<?php
$terms = get_the_terms(get_the_ID(), 'job_listing_tag');

if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ):
?>
	<div id="listing-tags" class="listing-tags widget">
		<h3 class="widget-title"><span><?php esc_html_e( 'Tags', 'findgo' ); ?></span></h3>
		<div class="box-inner">
			<ul class="listing-tag-list">
				<?php foreach ( $terms as $term ) { ?>
					<li>
						<a href="<?php echo esc_url(get_term_link($term->term_id, 'job_listing_tag')); ?>">
							<span class="tag-title"><?php echo trim($term->name); ?></span>
						</a>
					</li>
				<?php } ?>
			</ul>
		</div>
	</div>
<?php endif; ?>