<?php


if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $post;
$rating = intval( get_comment_meta( $comment->comment_ID, '_apus_rating', true ) );
$url = '';
if ( !empty($comment->user_id) ) {
	$data = get_userdata( $comment->user_id );
	$url = findgo_get_user_url($comment->user_id, $data->user_nicename);
}
?>
<li <?php comment_class(); ?> id="li-comment-<?php comment_ID() ?>">

	<div id="comment-<?php comment_ID(); ?>" class="the-comment media">
		<div class="avatar media-left">
			<?php if ( !empty($url) ) { ?>
				<a href="<?php echo esc_url($url); ?>">
			<?php } ?>
				<?php echo get_avatar( $comment->user_id, '80', '' ); ?>
			<?php if ( !empty($url) ) { ?>
				</a>
			<?php } ?>
		</div>
		<div class="comment-box media-body">

			<div class="star-rating clear pull-right" title="<?php echo sprintf( esc_attr__( 'Rated %d out of 5', 'findgo' ), $rating ) ?>">
				<?php findgo_print_review($rating); ?>
				<span class="review-avg"><?php echo number_format((float)$rating, 1, '.', ''); ?></span>
			</div>
			
			<div class="meta">
				<h3 class="title-author" >
					<?php if ( !empty($url) ) { ?>
						<a href="<?php echo esc_url($url); ?>">
					<?php } ?>
						<?php comment_author(); ?>
					<?php if ( !empty($url) ) { ?>
						</a>
					<?php } ?>
				</h3> 
				<div class="info-meta">
					<?php if ( $comment->comment_approved == '0' ) : ?>
						<span class="meta"><em><?php esc_html_e( 'Your comment is awaiting approval', 'findgo' ); ?></em></span>
					<?php else : ?>
						<span class="meta">
							<time><?php echo get_comment_date( get_option('date_format', 'd M, Y') ); ?></time>
						</span>
					<?php endif; ?>
				</div>
			</div>
			<div itemprop="description" class="comment-text">
				<?php comment_text(); ?>
				<?php echo Findgo_Attachments::displayAttachment(); ?>
			</div>

			<div id="comment-actions-<?php comment_ID(); ?>" class="comment-actions">
				<span class="title"><?php esc_html_e('Was This Review...?', 'findgo'); ?></span>
				<?php if ( findgo_get_config('listing_review_enable_like', true) ) {
					$count = intval( get_comment_meta( $comment->comment_ID, '_apus_like', true ) );
					$check = findgo_check_comment_like_user($comment->comment_ID);
					?>
					<a href="#like-commnent-<?php comment_ID(); ?>" class="comment-like <?php echo esc_attr($check ? 'active' : ''); ?>" data-id="<?php comment_ID(); ?>" title="<?php echo sprintf(esc_html__('Like %d', 'findgo'), $count); ?>" data-toggle="tooltip"><i class="fa <?php echo esc_attr($check ? 'fa-thumbs-up' : 'fa-thumbs-o-up'); ?>"></i></a>
				<?php } ?>

				<?php if ( findgo_get_config('listing_review_enable_dislike', true) ) {
					$count = intval( get_comment_meta( $comment->comment_ID, '_apus_dislike', true ) );
					$check = findgo_check_comment_dislike_user($comment->comment_ID);
					?>
					<a href="#dislike-commnent-<?php comment_ID(); ?>" class="comment-dislike <?php echo esc_attr($check ? 'active' : ''); ?>" data-id="<?php comment_ID(); ?>" title="<?php echo sprintf(esc_html__('Dislike %d', 'findgo'), $count); ?>" data-toggle="tooltip"><i class="fa <?php echo esc_attr($check ? 'fa-thumbs-down' : 'fa-thumbs-o-down'); ?>"></i></a>
				<?php } ?>

				<?php if ( findgo_get_config('listing_review_enable_love', true) ) {
					$count = intval( get_comment_meta( $comment->comment_ID, '_apus_love', true ) );
					$check = findgo_check_comment_love_user($comment->comment_ID);
					?>
					<a href="#love-commnent-<?php comment_ID(); ?>" class="comment-love <?php echo esc_attr($check ? 'active' : ''); ?>" data-id="<?php comment_ID(); ?>" data-toggle="tooltip" title="<?php echo sprintf(esc_html__('Love %d', 'findgo'), $count); ?>"><i class="fa <?php echo esc_attr($check ? 'fa-heart' : 'fa-heart-o'); ?>"></i></a>
				<?php } ?>
			</div>
			<div id="comment-reply-wrapper-<?php comment_ID(); ?>">
				<?php if ( findgo_get_config('listing_review_enable_reply', true) ) { ?>
					<?php comment_reply_link(array_merge( $args, array(
						'reply_text' => esc_html__('Reply', 'findgo'),
						'add_below' => 'comment-reply-wrapper',
						'depth' => 1,
						'max_depth' => $args['max_depth']
					))) ?>
				<?php } ?>
			</div>
		</div>
	</div>
</li>