<?php
$price_range = get_post_meta(get_the_ID(), '_company_price_range', true);
$price_from = get_post_meta(get_the_ID(), '_company_price_from', true);
$price_to = get_post_meta(get_the_ID(), '_company_price_to', true);

$price_range_labels = findgo_job_manager_price_range_icons();

if ( ($price_range && isset($price_range_labels[$price_range])) || $price_from || $price_to) {
?>
<div id="listing-price_range" class="listing-price_range widget">
	<h3 class="widget-title"><span><?php esc_html_e( 'Review Cost', 'findgo' ); ?></span></h3>
	<?php
	if ( $price_range && isset($price_range_labels[$price_range])) {
		$labels = $price_range_labels[$price_range];
		?>
		<span class="listing-price-range text-theme" data-placement="top" data-toggle="tooltip" title="<?php echo esc_attr($labels['label']); ?>">
			<?php echo esc_attr($labels['icon']); ?>
		</span>
		<?php
	}
	?>
	<span class="highlight"><?php echo esc_html_e('Price Range', 'findgo'); ?></span>
	<?php
	if ( $price_from || $price_to ) {
		?>
		<span class="price-range">
			<?php echo esc_html($price_from); ?>
			<?php if ( $price_to ) { ?>
				- <?php echo esc_html($price_to); ?>
			<?php } ?>
		</span>
		<?php
	}
	?>
</div>
<?php }