<?php

$photos = findgo_get_listing_gallery( get_the_ID() );
if ( ! empty( $photos ) ) :
	$layout_version = findgo_get_listing_single_version();
	?>
	<div id="listing-photos" class="photos-wrapper widget">
		<h3 class="widget-title"><?php esc_html_e( 'Gallery', 'findgo' ); ?></h3>
		<?php if ( $layout_version != 'v4' ) { ?>
			
			<div class="listing-photos box-inner">
				<div class="slick-carousel carousel-1row" data-carousel="slick" data-items="4" data-smallmedium="4" data-extrasmall="4" data-margin="0" data-verysmall="4" data-pagination="false" data-nav="true">
					<?php $i = 1; foreach ($photos as $thumb_id => $photo): ?>
						<?php
						$image_full = wp_get_attachment_image_src( $thumb_id, 'full' );
						$image_full_url = isset($image_full[0]) ? $image_full[0] : '';
						if ($image_full_url) {
						?>
						<div class="item">
							<a class="photo-item" href="<?php echo esc_url($image_full_url); ?>">
								<?php echo trim(findgo_get_attachment_thumbnail($thumb_id, 'findgo-card-image')); ?>
							</a>
						</div>	
						<?php } ?>
					<?php $i++; endforeach; ?>
				</div>
			</div>
		<?php } else { ?>
			<div class="listing-photos box-inner">
				<div class="slick-carousel slick-carousel-gallery-main" data-carousel="slick" data-items="1" data-smallmedium="1" data-extrasmall="1" data-margin="0" data-verysmall="1" data-pagination="false" data-nav="true" data-asnavfor=".slick-carousel-gallery-thumbnail" data-slickparent="true">
					<?php $i = 1; foreach ($photos as $thumb_id => $photo): ?>
						<?php
						$image_full = wp_get_attachment_image_src( $thumb_id, 'full' );
						$image_full_url = isset($image_full[0]) ? $image_full[0] : '';
						if ($image_full_url) {
						?>	<div class="item">
								<a class="photo-item" href="<?php echo esc_url($image_full_url); ?>">
									<?php echo trim(findgo_get_attachment_thumbnail($thumb_id, 'findgo-image-gallery3')); ?>
								</a>
							</div>
						<?php } ?>
					<?php $i++; endforeach; ?>
				</div>

				<div class="slick-carousel slick-carousel-gallery-thumbnail" data-carousel="slick" data-items="4" data-smallmedium="3" data-extrasmall="3" data-pagination="false" data-nav="false" data-asnavfor=".slick-carousel-gallery-main" data-slidestoscroll="1" data-focusonselect="true">
		            <?php foreach ($photos as $thumb_id => $photo): ?>
						<?php
						if ( !empty($thumb_id) ) {
						?>
							<?php echo trim(findgo_get_attachment_thumbnail($thumb_id, 'findgo-attachment')); ?>
						<?php } ?>
					<?php endforeach; ?>
		        </div>
			</div>
		<?php } ?>
	</div>
<?php endif; ?>
