<?php
	global $post;
	$terms = get_the_terms( get_the_ID(), 'job_listing_category' );
    $termids = array();
    if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
    	foreach ($terms as $term) {
    		$termids[] = $term->term_id;
    	}
    }
    $args = array (
        'taxonomy' => 'job_listing_category',
        'orderby' => 'name',
        'order' => 'ASC',
        'hide_empty' => true,
        'exclude' => $termids,
        'number' => 0
    );
    $terms = get_terms($args);
	if ( ! empty( $terms ) && ! is_wp_error( $terms ) ){
		?>
		<div class="widget browse-nearby">
			<h3 class="widget-title"><?php echo esc_html__('Browse nearby', 'findgo'); ?></h3>
			<div class="box-inner">
				<ul class="listing-cat">
					<?php

					$lat = get_post_meta(get_the_ID(), 'geolocation_lat', true);
					$lng = get_post_meta(get_the_ID(), 'geolocation_long', true);
					$location = get_the_job_location( $post );
					$link = findgo_get_listings_page_url();
					

					$link = add_query_arg( 'search_lat', $lat, remove_query_arg( 'search_lat', $link ) );
					$link = add_query_arg( 'search_lng', $lng, remove_query_arg( 'search_lng', $link ) );
					$link = add_query_arg( 'search_distance', 50, remove_query_arg( 'search_distance', $link ) );
					$link = add_query_arg( 'use_search_distance', 'on', remove_query_arg( 'use_search_distance', $link ) );
					$link = add_query_arg( 'search_location', strip_tags($location), remove_query_arg( 'search_location', $link ) );

					foreach ($terms as $term) {
						$term_link = add_query_arg( 'search_categories[]', $term->term_id, remove_query_arg( 'search_categories[]', $link ) );
					?>
						<li>
							<a href="<?php echo esc_url($term_link); ?>">
								<span class="category-icon">
									<?php echo trim(findgo_display_category_icon($term)); ?>
								</span>
								<?php echo esc_attr($term->name); ?>
							</a>
						</li>
					<?php } ?>
					<li>
						<a href="<?php echo esc_url($link); ?>">
							<?php echo esc_html__('Show all', 'findgo'); ?>
						</a>
					</li>

				</ul>
			</div>
		</div>
	<?php
	}
?>