<?php
global $post;
// get our custom meta
$phone = get_post_meta( get_the_ID(), '_company_phone', true);
$email = get_post_meta( get_the_ID(), '_company_email', true);
?>
<div id="listing-map-contact" class="listing-map widget">
	<h3 class="widget-title">
		<span><?php esc_html_e( 'Location', 'findgo' ); ?></span>
		<?php
			$location = get_the_job_location( $post );
			if ( $location ) {
				?>
				<a class="map-direction" href="<?php echo esc_url( 'http://maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ) ; ?>" target="_blank">
					<i class="fa fa-hand-o-right text-theme"></i>
					<?php esc_html_e('Get Directions', 'findgo'); ?>
				</a>
				<?php
			}
		?>
	</h3>
	<div class="listing-map-contact box-inner">
		<div class="wrapper-map-contact">
			<div id="apus-listing-map" class="apus-single-listing-map"></div>
		</div>
		<div class="wrapper-contact">
			<ul class="contact-info-listing">
				<?php
				if ( $location ) { ?>
					<li>
						<div class="contact-info-address">
							<?php 
								if ( $location ) {
									echo apply_filters( 'the_job_location_map_link', '<a class="google_map_link" href="' . esc_url( 'http://maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ) . '" target="_blank">' . esc_html( strip_tags( $location ) ) . '</a>', $location, $post );
								} else {
									echo wp_kses_post( apply_filters( 'the_job_location_anywhere_text', esc_html__( 'Anywhere', 'findgo' ) ) );
								}
							?>
						</div>
					</li>
					<?php
				} ?>
				<?php
				if ( ! empty( $phone ) ) : ?>
					<li>
						<div class="contact-info-address">
							<a class="listing-contact listing--phone" href="tel:<?php echo trim($phone); ?>" itemprop="telephone"><?php echo trim($phone); ?></a>
						</div>
					</li>
				<?php endif;

				if ( ! empty( $email ) ) : ?>
					<li>
						<div class="contact-info-address">
							<a class="listing-contact listing--email" href="mailto:<?php echo trim($email); ?>" itemprop="telephone"><?php echo trim($email); ?></a>
						</div>
						
					</li>
				<?php endif;
				
				if ( $website = get_the_company_website() ) {
					$website_pure = preg_replace('#^https?://#', '', rtrim(esc_url($website),'/'));
					?>
						<li>
							<div class="contact-info-address">
								<a class="listing-contact  listing--website" href="<?php echo esc_url( $website ); ?>" itemprop="url" target="_blank" rel="nofollow"><?php echo trim($website_pure); ?></a>
							</div>
						</li>
				<?php } ?>
			</ul>
			<!-- social icons -->
			<?php
				$twitter = get_post_meta( get_the_ID(), '_company_twitter', true);
				$facebook = get_post_meta( get_the_ID(), '_company_facebook', true);
				$linkedin = get_post_meta( get_the_ID(), '_company_linkedin', true);
				$pinterest = get_post_meta( get_the_ID(), '_company_pinterest', true);
				$instagram = get_post_meta( get_the_ID(), '_company_instagram', true);
			?>
			<ul class="social-icons">
				<?php if ( !empty($facebook) ) { ?>
					<li><a href="<?php echo esc_url($facebook); ?>" class="facebook" target="_blank"><i class="fa fa-facebook"></i></a></li>
				<?php } ?>
				<?php 
				if ( strlen( $twitter ) != 0 ) {
				?>
					<li><a href="<?php echo esc_url($twitter); ?>" class="twitter" target="_blank"><i class="fa fa-twitter"></i></a></li>
					
				<?php } ?>
				<?php if ( !empty($linkedin) ) { ?>
					<li><a href="<?php echo esc_url($linkedin); ?>" class="linkedin"><i class="fa fa-linkedin"></i></a></li>
				<?php } ?>
				<?php if ( !empty($pinterest) ) { ?>
					<li><a href="<?php echo esc_url($pinterest); ?>" class="pinterest"><i class="fa fa-pinterest"></i></a></li>
				<?php } ?>
				<?php if ( !empty($instagram) ) { ?>
					<li><a href="<?php echo esc_url($instagram); ?>" class="instagram"><i class="fa fa-instagram"></i></a></li>
				<?php } ?>
			</ul>
		</div>
	</div>
</div>