<?php
global $post;
$listing_is_claimed = get_post_meta( get_the_ID(), '_claimed', true );

$total_rating = findgo_get_total_rating( get_the_ID() );
$totals = findgo_get_total_reviews(get_the_ID());

$terms = get_the_terms( get_the_ID(), 'job_listing_category' );
$termString  = '';
if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ) {
	$count = 1;
	foreach ( $terms as $term ) {
		$termString .= '<a href="'.get_term_link($term).'">'.findgo_display_category_icon($term).$term->name.'</a>';
		if ( $count != count( $terms ) ) {
			$termString .= ', ';
		}
		$count ++;
	}
}
$phone = get_post_meta(get_the_ID(), '_company_phone', true);
?>
<header class="entry-header">
	<div class="container">
		
		<div class="entry-header-wrapper clearfix">
			<div class="entry-header-left pull-left">
				<h1 class="entry-title" itemprop="name"><?php
					echo get_the_title();
					if ( $listing_is_claimed ) :
						echo '<span class="listing-claimed-icon" data-toggle="tooltip" title="'.esc_attr__('Claimed', 'findgo').'"><i class="text-theme fa fa-check-circle"></i></span>';
					endif;
				?>
					<?php findgo_display_time_status(); ?>
				</h1>
				<div class="job_listing">	
					<?php the_company_tagline( '<div class="listing-tagline">', '</div>' ); ?>
					<div class="listing-tags">
						<div class="review-star">
							<span class="review-avg"><?php echo number_format((float)$total_rating, 1, '.', ''); ?></span>
							<?php echo sprintf(_n('<span class="highlight">%s Rating</span>', '<span class="highlight">%s Ratings</span>', $totals, 'findgo'), $totals); ?>
						</div>
						<?php if ( !empty($termString) ) { ?>
							<div class="listing-category"><?php echo trim($termString); ?></div>
						<?php } ?>
						<div class="p-relative">
							<?php findgo_job_manager_display_price_range(get_the_ID()); ?>
						</div>
					</div>
				</div> 
				<?php
				/**
				 * single_job_listing_start hook
				 *
				 * @hooked job_listing_meta_display - 20
				 * @hooked job_listing_company_display - 30
				 */
				do_action( 'single_job_listing_start' );
				?>
			</div>
			<div class="entry-header-right pull-right">
				<div class="entry-header-right-top clearfix">
					<div class="pull-right">
						<div class="listing-location pull-left">
							<i class="flaticon-placeholder"></i>
							<?php
								$location = get_the_job_location( $post );
								if ( $location ) {
									echo apply_filters( 'the_job_location_map_link', '<a class="google_map_link" href="' . esc_url( 'http://maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ) . '" target="_blank">' . esc_html( strip_tags( $location ) ) . '</a>', $location, $post );
								} else {
									echo wp_kses_post( apply_filters( 'the_job_location_anywhere_text', esc_html__( 'Anywhere', 'findgo' ) ) );
								}
							?>
						</div>
						<?php if ( !empty($phone) ) { ?>
							<div class="listing-phone pull-left">
								<i class="flaticon-phone-call"></i>
								<?php echo trim($phone); ?>
							</div>
						<?php } ?>
					</div>
				</div>
				<!-- action -->
				<?php get_template_part( 'job_manager/single/parts/actions' ); ?>
			</div>
		</div>
	</div>
</header><!-- .entry-header -->