<?php
global $post;
// get our custom meta
$phone = get_post_meta( get_the_ID(), '_company_phone', true);
$email = get_post_meta( get_the_ID(), '_company_email', true);
?>

<div id="listing-contact" class="listing-contact">
	<h3 class="widget-title"><span><?php esc_html_e( 'Contact', 'findgo' ); ?></span></h3>
	<div class="box-inner">
		<ul class="contact">
			<?php
			$location = get_the_job_location( $post );
			if ( $location ) { ?>
				<li>
					<span class="text-label"><i class="fa fa-location-arrow"></i> <?php esc_html_e('Address', 'findgo'); ?></span>
					<?php 
						if ( $location ) {
							echo apply_filters( 'the_job_location_map_link', '<a class="google_map_link" href="' . esc_url( 'http://maps.google.com/maps?q=' . urlencode( strip_tags( $location ) ) . '&zoom=14&size=512x512&maptype=roadmap&sensor=false' ) . '" target="_blank">' . esc_html( strip_tags( $location ) ) . '</a>', $location, $post );
						} else {
							echo wp_kses_post( apply_filters( 'the_job_location_anywhere_text', esc_html__( 'Anywhere', 'findgo' ) ) );
						}
					?>
				</li>
				<?php
			} ?>
			<?php
			if ( ! empty( $phone ) ) : ?>
				<li>
					<span class="text-label"><i class="fa fa-phone"></i> <?php esc_html_e('Phone', 'findgo'); ?></span>
					<a class="listing--phone" href="tel:<?php echo trim($phone); ?>" itemprop="telephone"><?php echo trim($phone); ?></a>
				</li>
			<?php endif;

			if ( ! empty( $email ) ) : ?>
				<li>
					<span class="text-label"><i class="fa fa-envelope-o"></i> <?php esc_html_e('E-mail', 'findgo'); ?></span>
					<a class="listing--email" href="mailto:<?php echo trim($email); ?>" itemprop="telephone"><?php echo trim($email); ?></a>
				</li>
			<?php endif;
			
			if ( $website = get_the_company_website() ) {
				$website_pure = preg_replace('#^https?://#', '', rtrim(esc_url($website),'/'));
				?>
					<li>
						<span class="text-label"><i class="fa fa-link"></i> <?php esc_html_e('Website', 'findgo'); ?></span>
						<a class="listing--website" href="<?php echo esc_url( $website ); ?>" itemprop="url" target="_blank" rel="nofollow"><?php echo trim($website_pure); ?></a>
					</li>
			<?php } ?>
		</ul>
		
	</div>
	<!-- form contact -->
</div>