<?php
global $post;
// get our custom meta
$phone = get_post_meta( get_the_ID(), '_company_phone', true);
$author_email = get_post_meta( get_the_ID(), '_company_email', true);
?>

<div id="listing-contact" class="listing-contact widget">
	<h3 class="widget-title"><span><?php esc_html_e( 'Contact Business', 'findgo' ); ?></span></h3>
	<div class="box-inner">
		
		<div class="contact-form">
			<?php
			$author_id = $post->post_author;
			$data = get_userdata( $author_id );

			if ( empty($author_email) ) {
				$author_email = !empty($data->user_email) ? $data->user_email : '';
			}
			
			?>

			<?php if ( ! empty( $_POST ) && array_key_exists( 'contact-form', $_POST ) ) : ?>
			    <?php
				$is_form_filled = ! empty( $_POST['email'] ) && ! empty( $_POST['subject'] ) && ! empty( $_POST['message'] );
				?>

			    <?php if ( $is_form_filled ) : ?>
			        <?php
			        $email = sanitize_text_field( $_POST['email'] );
			        $subject = sanitize_text_field( $_POST['subject'] );
			        $message = sanitize_text_field( $_POST['message'] );
			        $headers = sprintf( "From: %s <%s>\r\n Content-type: text/html", $email, $email );
			        $result = wp_mail( $author_email, $subject, $message, $headers );
			        ?>

			        <?php if ( $result ) : ?>
			            <div class="alert alert-success"><?php echo esc_html__( 'Your message has been successfully sent.', 'findgo' ); ?></div>
			        <?php else : ?>
			            <div class="alert alert-warning"><?php echo esc_html__( 'An error occurred when sending an email.', 'findgo' ); ?></div>
			        <?php endif; ?>
			    <?php else : ?>
			        <div class="alert alert-warning"><?php echo esc_html__( 'Form has been not filled correctly.', 'findgo' ); ?></div>
			    <?php endif; ?>
			<?php endif; ?>

			<?php if ( ! empty( $author_email ) ) : ?>
			    <form method="post" action="?">
			    	<div class="row">
				        <div class="col-sm-12">
					        <div class="form-group">
					        	<label><?php echo esc_html__( 'Your Subject', 'findgo' ); ?></label>
					            <input type="text" class="form-control" name="subject" placeholder="<?php esc_attr_e( 'Subject', 'findgo' ); ?>" required="required">
					        </div><!-- /.form-group -->
					    </div>
					    <div class="col-sm-12">
					        <div class="form-group">
					        	<label><?php echo esc_html__( 'Your Email', 'findgo' ); ?></label>
					            <input type="email" class="form-control" name="email" placeholder="<?php esc_attr_e( 'E-mail', 'findgo' ); ?>" required="required">
					        </div><!-- /.form-group -->
					    </div>
			        </div>
			        <div class="form-group">
			        	<label><?php echo esc_html__( 'Your Message', 'findgo' ); ?></label>
			            <textarea class="form-control" name="message" placeholder="<?php esc_attr_e( 'Message', 'findgo' ); ?>" required="required"></textarea>
			        </div><!-- /.form-group -->

			        <button class="button btn btn-theme" name="contact-form"><?php echo esc_html__( 'Send Message', 'findgo' ); ?></button>
			    </form>
			<?php endif; ?>
		</div>
	</div>
	<!-- form contact -->
</div>