<article id="post-<?php the_ID(); ?>" <?php post_class('detail-listing-v4'); ?>>
	<?php
	$style = '';
	if ( has_post_thumbnail() ) {
		$img_url = get_the_post_thumbnail_url(get_the_ID(), 'full');
		$style = 'background-image:url('.esc_url($img_url).')';
	}
	?>
	<div class="header-gallery-wrapper header-gallery-wrapper-v4 header-top-job" style="<?php echo esc_attr($style); ?>">
		
		<?php get_template_part( 'job_manager/single/parts/header-2' ); ?>
	</div>
	<?php
	$block_contents = array();
	?>
	<div class="panel-affix-wrapper">
		<div class="header-tabs-wrapper panel-affix">
			<div class="container">
				<div class="header-tabs-nav">
					<ul class="nav">
						<?php
						$contents = findgo_get_content_sort();
						$defaults = findgo_listing_single_sort_content();
						foreach ($contents as $key => $title) {
							$content = trim(findgo_listing_display_part($key));
							if ( !empty($content) ) {
								$block_contents[$key] = $content;
								?>
								<li><a href="#listing-<?php echo esc_attr($key); ?>">
									<?php if ( !empty($defaults[$key]) ) {
										echo esc_html($defaults[$key]);
									} else {
										echo esc_html($title);
									} ?>
								</a></li>
								<?php
							}
						}
						?>
					</ul>
				</div>
			</div>
		</div>
	</div>
	<div class="container">
		<div class="entry-listing-content">
			<?php
			$job_manager = $GLOBALS['job_manager'];

			remove_filter( 'the_content', array( $job_manager->post_types, 'job_content' ) );
			
			ob_start();

			do_action( 'job_content_start' );
			
			get_job_manager_template( 'single/content-default.php', array('block_contents' => $block_contents) );

			do_action( 'job_content_end' );

			$content = ob_get_clean();

			add_filter( 'the_content', array( $job_manager->post_types, 'job_content' ) );

			echo apply_filters( 'job_manager_single_job_content', $content, $post );

			wp_link_pages( array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'findgo' ),
				'after'  => '</div>',
			) ); ?>
		</div>
	</div><!-- .entry-content -->
</article><!-- #post-## -->
