<?php
$data = get_userdata( $user_id );

$url = findgo_get_user_url($user_id, $data->user_nicename);

$args = array(
	'post_type'           => 'job_listing',
	'post_status'         => array( 'publish' ),
	'posts_per_page'      => -1,
	'author'              => $user_id
);

$jobs = new WP_Query($args);
$listing_count = (int)$jobs->post_count;
$followers = get_user_meta( $user_id, '_apus_followers', true );
$followers = !empty($followers) && is_array($followers) ? count($followers) : 0;
$following = get_user_meta( $user_id, '_apus_following', true );
$following = !empty($following) && is_array($following) ? count($following) : 0;

$args = array(
	'user_id' => $user_id,
	'post_type' => 'job_listing'
);
$comments = get_comments( $args );
$comment_count = !empty($comments) ? count($comments) : 0;
$time = strtotime($data->user_registered);
$registed_date = date('F', $time).' '.date('Y', $time);

$total_rating = findgo_get_total_rating_by_user($user_id);
?>
<div class="user-item">
	<div class="media">
		<div class="media-left">
			<div class="img-comment">
				<?php if ( !empty($url) ) { ?>
					<a href="<?php echo esc_url($url); ?>">
				<?php } ?>
				<?php echo get_avatar($user_id,80); ?>
				<?php if ( !empty($url) ) { ?>
					</a>
				<?php } ?>
			</div>
		</div>
		<div class="media-body">
			<h3 class="title-user">
				<?php echo esc_html($data->display_name); ?>
				<?php
					if ( $total_rating > 0 ) {
						findgo_print_review($total_rating);
					}
				?>
			</h3>

			<ul class="user-metas">
				<?php if ( $listing_count > 0 ) { ?>
					<li><?php echo sprintf(_n('<span>%d</span> Listing', '<span>%d</span> Listings', $listing_count, 'findgo'), $listing_count); ?></li>
				<?php } ?>
				<?php if ( $followers > 0 ) { ?>
					<li><?php echo sprintf(_n('<span>%d</span> Follower', '<span>%d</span> Followers', $followers, 'findgo'), $followers); ?></li>
				<?php } ?>
				<?php if ( $following > 0 ) { ?>
					<li><?php echo sprintf(_n('<span>%d</span> Following', '<span>%d</span> Following', $following, 'findgo'), $following); ?></li>
				<?php } ?>
				<?php if ( $comment_count > 0 ) { ?>
					<li><?php echo sprintf(_n('<span>%d</span> Comment', '<span>%d</span> Comments', $comment_count, 'findgo'), $comment_count); ?></li>
				<?php } ?>
				<?php if ( $registed_date ) { ?>
					<li><?php echo sprintf(__('Member Since: %s', 'findgo'), $registed_date); ?></li>
				<?php } ?>
			</ul>
		</div>
		<div class="media-right">
			<?php if ( is_user_logged_in() && get_current_user_id() != $user_id ) {
				$check = findgo_check_follow_user($user_id);
			?>
				<a href="#follow-btn" class="btn radius-3x btn-theme btn-follow-following <?php echo esc_attr($check ? 'btn-following-user' : 'btn-follow-user btn-outline'); ?>" data-id="<?php echo esc_attr($user_id); ?>">
					<?php if ( $check ) { ?>
						<span class="text-following"><?php esc_html_e('Following', 'findgo'); ?></span>
						<span class="text-following-hover"><?php esc_html_e('Unfollow', 'findgo'); ?></span>
					<?php } else { ?>
						<?php esc_html_e('Follow', 'findgo'); ?>
					<?php } ?>
				</a>
			<?php } ?>
		</div>
	</div>
</div>