<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $apus_author;
$data = get_userdata( $apus_author->ID );

$author_email = !empty($data->user_email) ? $data->user_email : '';
?>

<?php if ( ! empty( $_POST ) && array_key_exists( 'contact-form', $_POST ) ) : ?>
    <?php
	$is_form_filled = ! empty( $_POST['email'] ) && ! empty( $_POST['subject'] ) && ! empty( $_POST['message'] );
	?>

    <?php if ( $is_form_filled ) : ?>
        <?php
        $email = sanitize_text_field( $_POST['email'] );
        $subject = sanitize_text_field( $_POST['subject'] );
        $message = sanitize_text_field( $_POST['message'] );
        $headers = sprintf( "From: %s <%s>\r\n Content-type: text/html", $email, $email );
        $result = wp_mail( $author_email, $subject, $message, $headers );
        ?>

        <?php if ( $result ) : ?>
            <div class="alert alert-success"><?php echo esc_html__( 'Your message has been successfully sent.', 'findgo' ); ?></div>
        <?php else : ?>
            <div class="alert alert-warning"><?php echo esc_html__( 'An error occurred when sending an email.', 'findgo' ); ?></div>
        <?php endif; ?>
    <?php else : ?>
        <div class="alert alert-warning"><?php echo esc_html__( 'Form has been not filled correctly.', 'findgo' ); ?></div>
    <?php endif; ?>
<?php endif; ?>

<?php if ( ! empty( $author_email ) ) : ?>
    <h4 class="contact-form-title"><?php echo esc_html__( 'Contact Form', 'findgo' ); ?></h4>

    <form method="post" action="?">
        <div class="form-group">
            <input type="text" class="form-control" name="subject" placeholder="<?php esc_attr_e( 'Subject', 'findgo' ); ?>">
        </div><!-- /.form-group -->

        <div class="form-group">
            <input type="email" class="form-control" name="email" placeholder="<?php esc_attr_e( 'E-mail', 'findgo' ); ?>">
        </div><!-- /.form-group -->

        <div class="form-group space-20">
            <textarea class="form-control" name="message" placeholder="<?php esc_attr_e( 'Message', 'findgo' ); ?>"></textarea>
        </div><!-- /.form-group -->

        <button class="button btn btn-block btn-theme" name="contact-form"><?php echo esc_html__( 'Send Message', 'findgo' ); ?></button>
    </form>
<?php endif; ?>