<?php
$post_id = $_GET['listing_id'];
global $post;
$post = get_post($post_id);
$total_rating = findgo_get_total_rating( $post_id );
$totals = findgo_get_total_reviews( $post_id );

$terms = get_the_terms( $post_id, 'job_listing_category' );
$termString  = '';
if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ) {
	$count = 1;
	foreach ( $terms as $term ) {
		$termString .= '<a href="'.get_term_link($term).'">'.findgo_display_category_icon($term).$term->name.'</a>';
		if ( $count != count( $terms ) ) {
			$termString .= ', ';
		}
		$count ++;
	}
}
$phone = get_post_meta( $post_id, '_company_phone', true );

$geolocation_long = get_post_meta($post_id, 'geolocation_long', true);
$geolocation_lat = get_post_meta($post_id, 'geolocation_lat', true);
$description = apply_filters( 'the_job_description', get_the_content( $post ) );
?>
<div class="quickview-wrapper job_listing"
	data-longitude="<?php echo esc_attr( $geolocation_long ); ?>"
	data-latitude="<?php echo esc_attr( $geolocation_lat ); ?>"
	data-img="<?php echo esc_attr( findgo_get_post_image_src( $post_id, 'findgo-card-image' ) ); ?>"
	data-permalink="<?php echo esc_url(get_permalink($post_id)); ?>" >

	<?php findgo_display_hidden_category_icon($terms); ?>
	<div class="hidden listing-review">
		<?php findgo_print_review($total_rating, 'list', $comments); ?>
	</div>
	
	<div class="row no-margin">
		<div class="col-sm-6 no-padding">
			<div class="preview-content-wrapper">
				<div class="preview-content-inner">
					<?php
					if ( has_post_thumbnail($post_id) ) {
						$thumbnail_id = get_post_thumbnail_id($post_id);
						?>
						<div class="listing-image-wrapper">
							<div class="listing-image-inner">
								<?php findgo_job_manager_display_price_range(get_the_ID()); ?>
								<?php echo trim(findgo_get_attachment_thumbnail($thumbnail_id, 'full')); ?>
								<div class="bookmark-view">
									<?php Findgo_Bookmark::display_bookmark_btn(); ?>
								</div>
							</div>
						</div>
						<?php
					}
					?>
					<div class="content-quickview-listing">
						<div class="listing-content">
							<h3 class="listing-title"><a href="<?php echo esc_url(get_permalink($post_id)); ?>"><?php echo get_the_title($post_id); ?></a></h3>
							<?php the_company_tagline( '<div class="listing-tagline">', '</div>' ); ?>
							<div class="listing-tags">
								<div class="listing-review">
									<span class="review-avg"><?php echo number_format((float)$total_rating, 1, '.', ''); ?></span>
									<?php echo sprintf(_n('%d Rating', '%d Ratings', $totals, 'findgo'), $totals); ?>
								</div>
								<?php if ( !empty($termString) ) { ?>
									<div class="listing-category"><?php echo trim($termString); ?></div>
								<?php } ?>
								<?php findgo_display_time_status(); ?>
							</div>
						</div>
						<div class="listing-content-bottom clearfix ">
							<div class="pull-left">
								<?php findgo_display_city_country(); ?>
							</div>
							<?php if ( ! empty( $phone ) ) { ?>
								<div class="listing-phone pull-left">
									<i class="flaticon-phone-call"></i>
									<?php echo trim($phone); ?>
								</div>
							<?php } ?>
						</div>
						<?php if(get_post_field('post_content', $post_id)){ ?>
						<div class="description ">
							<h3 class="title-des"><?php esc_html_e( 'Description', 'findgo' ); ?></h3>
							<?php echo apply_filters('the_content', get_post_field('post_content', $post_id) ); ?>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<div class="col-sm-6 no-padding ">
			<div id="apus-preview-listing-map" class="apus-preview-listing-map"></div>
		</div>
	</div>
</div>