<?php
global $post;
$total_rating = findgo_get_total_rating( $job->ID );
$comments = findgo_get_total_reviews( $job->ID );
$phone = get_post_meta( $job->ID, '_company_phone', true);
?>
<div class="my-listing-item-wrapper job-list-style job_listing ">
	<div class="wrapper-list">
		<?php $img_src = findgo_get_post_image_src($job->ID, 'findgo-card-image');
		if ($img_src) {
		?>
			<div class="listing-image">
				<div class="listing-image-inner">
					<?php findgo_display_listing_image('findgo-image-list', true, $job); ?>
				</div>
			</div>
		<?php } ?>
		<div class="bottom-grid">
			<div class="bottom-grid-inner">
				<div class="listing-content">
					<h3 class="listing-title">
						<?php if ( $job->post_status == 'publish' ) : ?>
							<a href="<?php echo get_permalink( $job->ID ); ?>"><?php echo trim($job->post_title); ?></a>
						<?php else : ?>
							<?php echo trim($job->post_title); ?> <small>(<?php the_job_status( $job ); ?>)</small>
						<?php endif; ?>
					</h3>
					<?php the_company_tagline( '<div class="listing-tagline">', '</div>', true, $job ); ?>
					<div class="listing-tags">
						<div class="quick-view">
							<a href="#preview-<?php echo esc_attr($job->ID); ?>" class="listing-preview" data-id="<?php echo esc_attr($job->ID); ?>"><i class="flaticon-visible"></i><span class="preview-text"><?php esc_html_e('Preview', 'findgo'); ?></span></a>
						</div>
						<?php
							$actions = array();

							switch ( $job->post_status ) {
								case 'publish' :
									$actions['edit'] = array( 'label' => esc_html__( 'Edit', 'findgo' ), 'nonce' => false, 'icon' => 'flaticon-eraser' );
									break;
								case 'expired' :
									if ( job_manager_get_permalink( 'submit_job_form' ) ) {
										$actions['relist'] = array( 'label' => esc_html__( 'Relist', 'findgo' ), 'nonce' => true, 'icon' => 'flaticon-eraser' );
									}
									break;
								case 'pending_payment' :
								case 'pending' :
									if ( job_manager_user_can_edit_pending_submissions() ) {
										$actions['edit'] = array( 'label' => esc_html__( 'Edit', 'findgo' ), 'nonce' => false, 'icon' => 'flaticon-eraser' );
									}
								break;
							}

							$actions['delete'] = array( 'label' => esc_html__( 'Delete', 'findgo' ), 'nonce' => true, 'icon' => 'flaticon-dustbin' );
							$actions = apply_filters( 'job_manager_my_job_actions', $actions, $job );

							foreach ( $actions as $action => $value ) {
								$action_url = add_query_arg( array( 'action' => $action, 'job_id' => $job->ID ) );
								if ( $value['nonce'] ) {
									$action_url = wp_nonce_url( $action_url, 'job_manager_my_job_actions' );
								}
								echo '<div><a href="' . esc_url( $action_url ) . '" class="job-dashboard-action-' . esc_attr( $action ) . '">' 
									. (isset($value['icon']) ? '<i class="'.esc_attr($value['icon']).'"></i>' : '')
									. esc_html( $value['label'] ) . '</a></div>';
							}
						?>
					</div>
				</div>
				<div class="listing-content-bottom clearfix">
					<div class="pull-left">
						<?php findgo_display_city_country($job->ID); ?>
					</div>
					<?php if ( ! empty( $phone ) ) { ?>
						<div class="listing-phone pull-left">
							<i class="flaticon-phone-call"></i>
							<?php echo trim($phone); ?>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
	</div>			
</div>