<?php
global $post;
$terms = get_the_terms( get_the_ID(), 'job_listing_category' );
$firstTermHTML  = '';
if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ) {
	$firstTerm = $terms[0];
	if ( ! $firstTerm == null ) {
		$term_id = $firstTerm->term_id;
		$firstTermHTML .= '<a href="'.get_term_link($firstTerm).'">'.findgo_display_category_icon($firstTerm).$firstTerm->name.'</a>';
	}
}
$total_rating = findgo_get_total_rating( get_the_ID() );
$comments = findgo_get_total_reviews( get_the_ID() );
$phone = get_post_meta( get_the_ID(), '_company_phone', true);
$listing_is_claimed = get_post_meta( get_the_ID(), '_claimed', true );

?>
<div <?php job_listing_class('job-grid-style-v2'); ?>
	data-longitude="<?php echo esc_attr( $post->geolocation_long ); ?>"
	data-latitude="<?php echo esc_attr( $post->geolocation_lat ); ?>"
	data-img="<?php echo esc_attr( findgo_get_post_image_src( $post->ID, 'findgo-card-image-grid2' ) ); ?>"
	data-permalink="<?php the_job_permalink(); ?>" >
	<div class="inner">
		<?php findgo_display_hidden_category_icon($terms); ?>
		<div class="hidden listing-review">
			<?php findgo_print_review($total_rating, 'list', $comments); ?>
		</div>
		<span class="listing-address hidden">
			<?php the_job_location( false ); ?>
		</span>
		<div class="listing-image">
			<div class="listing-image-inner">
				<?php findgo_display_listing_image('findgo-card-image-grid2'); ?>
				<?php findgo_display_price_range(get_the_ID()); ?>
				<div class="listing-bookmark">
					<?php Findgo_Bookmark::display_bookmark_btn(); ?>
				</div>
				<div class="content-top">
					<h3 class="listing-title">
						<a href="<?php the_job_permalink(); ?>"><?php the_title(); ?></a>
						<?php
						if ( $listing_is_claimed ) {
							echo '<span class="listing-claimed-icon" data-toggle="tooltip" title="'.esc_attr__('Claimed', 'findgo').'"><i class="text-theme fa fa-check-circle"></i></span>';
						}
						?>
					</h3>
					<?php the_company_tagline( '<div class="listing-tagline">', '</div>' ); ?>
					<div class="phone-location clearfix">
						<span>
							<?php findgo_display_city_country(); ?>
						</span>
						<?php if ( ! empty( $phone ) ) { ?>
							<span>
								<i class="flaticon-phone-call"></i><?php echo trim($phone); ?>
							</span>
						<?php } ?>
					</div>
				</div>
			</div>
		</div>
		<div class="bottom-grid">
			<div class="listing-content">
				<div class="listing-tags">
					<div class="listing-review">
						<span class="review-avg"><?php echo number_format((float)$total_rating, 1, '.', ''); ?></span>
						<?php echo sprintf(_n('%d Rating', '%d Ratings', $comments, 'findgo'), $comments); ?>
					</div>
					<?php if ( $firstTermHTML ) { ?>
						<div class="listing-category">
							<?php echo trim($firstTermHTML); ?>
						</div>
					<?php } ?>
					<?php findgo_display_time_status(); ?>
				</div>
			</div>
		</div>
	</div>
</div>