<?php
$display_mode = findgo_get_listing_display_mode();
$sidebar_position = findgo_get_config('listing_archive_layout', 'left-main');

$layout = findgo_get_listing_archive_version();
$layouts = findgo_get_listing_all_half_map_version();
$class = 'col-md-8 col-xs-12';
if ( $sidebar_position == 'main' ) {
	$class = 'col-xs-12';
}
if ( in_array($layout, $layouts) ) {
	$class = '';
}
?>
<div class="<?php echo esc_attr($class); ?> main-results">

	<?php

	global $wp_query;
	$term =	$wp_query->queried_object;
	$show_title = findgo_get_config('listing_show_cat_title', 0);
	$show_des = findgo_get_config('listing_show_cat_description', 0);
	
	if ( isset($term->taxonomy) && $term->taxonomy == 'job_listing_category' && ($show_title || $show_des) ) { ?>
		
		<div class="listings-cat-description">
			<?php if ( $show_title ) { ?>
				<h2 class="cat-title"><?php echo trim($term->name); ?></h2>
			<?php } ?>
			<?php if ( $show_des ) { ?>
				<div class="description"><?php echo trim($term->description); ?></div>
			<?php } ?>
		</div>
	<?php } ?>

	<div class="listing-action clearfix">
		<div class="listing-search-result"></div>
		<div class="listing-display-mode">
			<div class="display-mode">
				<a href="#grid" class="change-view <?php echo ($display_mode == 'grid' ? 'active' : ''); ?>" data-mode="grid"><i class="fa fa-th-large" aria-hidden="true"></i></a>
				<a href="#list" class="change-view <?php echo ($display_mode == 'list' ? 'active' : ''); ?>" data-mode="list"><i class="fa fa-th-list" aria-hidden="true"></i></a>
			</div>
		</div>
	</div>
	<div class="job_listings job_listings_cards clearfix row">