<?php wp_enqueue_script( 'wp-job-manager-ajax-filters' ); ?>

<?php
	do_action( 'job_manager_job_filters_before', $atts );
	$atts['atts'] = $atts;
	$atts['keywords'] = $keywords;
?>
<?php
	$layout = findgo_get_listing_archive_version();
	$sidebar_position = '';
	if ( $layout == 'default' ) {
		$sidebar_position = findgo_get_config('listing_archive_layout', 'left-main');
	}
	if ($layout == 'half-map-v4' || $sidebar_position == 'main' ) {
?>
		<?php if ( findgo_get_config('listing_filter_type', 'region') === 'region' ) { ?>
			<?php get_job_manager_template( 'job-filters-region.php', $atts ); ?>
		<?php } else { ?>
			<?php get_job_manager_template( 'job-filters-location.php', $atts ); ?>
		<?php } ?>

<?php } else { 

	$sidebar = findgo_get_listings_sidebar_configs();
?>
	<?php if ( $layout == 'default' ) { ?>
		<div class="col-md-4 col-xs-12 sidebar listings-sidebar <?php echo esc_attr($sidebar['class']); ?>">
			<div class="close-sidebar-btn hidden-lg hidden-md"> <i class="fa fa-close"></i> <span><?php esc_html_e('Close', 'findgo'); ?></span></div>
			<h3 class="title-filter"><?php esc_html_e('Search Filters', 'findgo'); ?></h3>
	<?php } elseif($layout == 'half-map-v1' || $layout == 'half-map-v2' || $layout == 'half-map-v3' ) { ?>
		<div class="wrapper-123-filter">
			<div class="listings-filter-header hidden-sm hidden-xs">
				<?php esc_html_e('Search Filters', 'findgo'); ?><i class="fa fa-align-center" aria-hidden="true"></i>
			</div>
			<div class="listings-filter-wrapper">
				<div class="filter-stick">
					<h3 class="title-filter-2"><?php esc_html_e('What are you looking for?', 'findgo'); ?></h3>
					<div class="desc"><?php esc_html_e('Search or select categories', 'findgo'); ?></div>
					<span class="close-filter"><i class="flaticon-cross-out"></i></span>
				</div>
		<?php } ?>
				<form class="job_filters job_filters-sidebar">
					<?php
						$display_mode = findgo_get_listing_display_mode();
					?>
					<input class="input_display_mode" type="hidden" name="display_mode" value="<?php echo trim($display_mode); ?>">

					<div class="filter-inner clearfix">
					<?php do_action( 'job_manager_job_filters_start', $atts ); ?>
					<div class="search_jobs">
						<?php do_action( 'job_manager_job_filters_search_jobs_start', $atts ); ?>

						<div class="widget">
							<div class="content">
								<div class="filter-top">
									<div class="row filter-top-inner clearfix">
										<?php if ( findgo_get_config('listing_filter_show_price', true) ) {
											$price_ranges = findgo_job_manager_price_range_icons();
											$price_range_default = isset( $_REQUEST['filter_price_range'] ) ? $_REQUEST['filter_price_range'] : array();

										?>
										<div class="col-xs-6">
											<div class="search_price_range clearfix">
												<div class="click-price clearfix">
													<span class="pull-left"><?php esc_html_e('Price', 'findgo'); ?></span>
													<span class="pull-right"><?php esc_html_e('$', 'findgo'); ?></span>
												</div>
												<ul class="list-price">
													<?php
														foreach ($price_ranges as $key => $label) {
															?>
															<li>
																<label for="filter_price_range_<?php echo esc_attr($key); ?>" data-placement="right" data-toggle="tooltip" title="<?php echo esc_attr($label['label']); ?>">
																	<input id="filter_price_range_<?php echo esc_attr($key); ?>" type="checkbox" name="filter_price_range[]" value="<?php echo esc_attr($key); ?>" <?php echo trim(in_array($key, $price_range_default) ? 'checked="checked"' : ''); ?>> <?php echo esc_attr($label['icon']); ?>
																</label>
															</li>
															<?php
														}
													?>
												</ul>
											</div>
										</div>
										<?php } ?>
										<?php if ( findgo_get_config('listing_filter_show_sortby') ) { ?>
											<div class="col-xs-6">
												<?php
													$options = array(
														'default' => esc_html__( 'Default Order', 'findgo' ),
														'date-desc' => esc_html__( 'Newest First', 'findgo' ),
														'date-asc' => esc_html__( 'Oldest First', 'findgo' ),
														'rating-desc' => esc_html__( 'Highest Rating', 'findgo' ),
														'rating-asc' => esc_html__( 'Lowest Rating', 'findgo' ),
														'random' => esc_html__( 'Random', 'findgo' ),
													);
													$default = isset($_COOKIE['findgo_order']) ? $_COOKIE['findgo_order'] : findgo_get_config('listing_filter_sortby_default', 'default');
												?>
												<div class="listing-orderby">
													<select name="filter_order" autocomplete="off">
														<?php foreach ( $options as $id => $option ) : ?>
															<option value="<?php echo esc_attr( $id ); ?>" <?php echo trim($id == $default ? 'selected="selected"' : ''); ?>><?php echo esc_html( $option ); ?></option>
														<?php endforeach; ?>
													</select>
												</div>
											</div>
										<?php } ?>
									</div>
								</div>
								<div class="search_keywords <?php if ( !findgo_get_config('listing_filter_show_keyword', true) ) { ?> hidden <?php } ?>">
									<input type="text" name="search_keywords" id="search_keywords" placeholder="<?php esc_attr_e( 'Keywords', 'findgo' ); ?>" value="<?php echo esc_attr( $keywords ); ?>" />
								</div>
								<?php if ( findgo_get_config('listing_filter_show_categories', true) ) { ?>
									<div class="select-categories">
										<?php
										if ( $show_categories && get_terms( 'job_listing_category' ) ) :

											//select the current category
											if ( empty( $selected_category ) ) {
												//try to see if there is a search_categories (notice the plural form) GET param
												$search_categories = isset( $_REQUEST['search_categories'] ) ? $_REQUEST['search_categories'] : '';
												if ( ! empty( $search_categories ) && is_array( $search_categories ) ) {
													$search_categories = $search_categories[0];
												}
												$search_categories = sanitize_text_field( stripslashes( $search_categories ) );
												if ( ! empty( $search_categories ) ) {
													if ( is_numeric( $search_categories ) ) {
														$selected_category = intval( $search_categories );
													} else {
														$term = get_term_by( 'slug', $search_categories, 'job_listing_category' );
														$selected_category = $term->term_id;
													}
												} elseif (  ! empty( $categories ) ) {
													if ( is_array($categories) ) {
														$selected_category = intval( $categories[0] );
													} else {
														$selected_category = intval( $categories );
													}
												}
											} ?>

											<div class="search_categories1">
												<?php job_manager_dropdown_categories( array(
													'taxonomy'        => 'job_listing_category',
						                            'hierarchical'    => 1,
						                            'show_option_all' => esc_html__( 'All categories', 'findgo' ),
						                            'placeholder' 	=> esc_html__( 'All Categories', 'findgo' ),
						                            'name'            => 'search_categories',
						                            'orderby'         => 'name',
						                            'selected'        => $selected_category,
						                            'multiple'        => false,
						                            'hide_empty' 	  => false 
												) ); ?>
											</div>

										<?php endif; ?>
									</div><!-- .select-categories -->
								<?php } ?>

								<?php if ( findgo_get_config('listing_filter_type', 'region') === 'region' ) { ?>
									<?php if ( findgo_get_config('listing_filter_show_regions', true) ) { ?>
										<?php
										$job_regions = get_terms( array( 'job_listing_region' ), array( 'hierarchical' => 1, 'hide_empty' => false ) );
										if ( ! is_wp_error( $job_regions ) && ! empty ( $job_regions ) ) {

											$selected_region = '';
											//try to see if there is a search_categories (notice the plural form) GET param
											$search_regions = isset( $_REQUEST['job_region_select'] ) ? $_REQUEST['job_region_select'] : '';
											if ( ! empty( $search_regions ) && is_array( $search_regions ) ) {
												$search_regions = $search_regions[0];
											}
											$search_regions = sanitize_text_field( stripslashes( $search_regions ) );
											if ( ! empty( $search_regions ) ) {
												if ( is_numeric( $search_regions ) ) {
													$selected_region = intval( $search_regions );
												} else {
													$term = get_term_by( 'slug', $search_regions, 'job_listing_region' );
													$selected_region = $term->term_id;
												}
											} elseif (  ! empty( $atts['regions'] ) ) {
												$selected_region = intval( $atts['regions'] );
											}
											?>
											<div class="select-regions">
												<select class="regions-select" data-placeholder="<?php esc_attr_e( 'Filter by regions', 'findgo' ); ?>" name="job_region_select">
													<option value=""><?php esc_html_e( 'All regions', 'findgo' ); ?></option>
													<?php foreach ( $job_regions as $term ) : ?>
														<option value="<?php echo esc_attr($term->term_id); ?>" <?php echo ($term->term_id == $selected_region) ? 'selected="selected"' : ''; ?>><?php echo trim($term->name); ?></option>
													<?php endforeach; ?>
												</select>
											</div>
										<?php } ?>
									<?php } ?>
								<?php } else { ?>
									<?php if ( findgo_get_config('listing_filter_show_location', true) ) { ?>
										<div class="search_location">
											<?php
												$search_location = isset( $_REQUEST['search_location'] ) ? $_REQUEST['search_location'] : '';
												$search_lat = isset( $_REQUEST['search_lat'] ) ? $_REQUEST['search_lat'] : '';
												$search_lng = isset( $_REQUEST['search_lng'] ) ? $_REQUEST['search_lng'] : '';
												$use_search_distance = isset( $_REQUEST['use_search_distance'] ) ? $_REQUEST['use_search_distance'] : 'on';
												$search_distance = isset( $_REQUEST['search_distance'] ) ? $_REQUEST['search_distance'] : findgo_get_config('listing_filter_distance_default', 50);
											?>
											<input type="text" name="search_location" id="search_location" placeholder="<?php esc_attr_e( 'Location', 'findgo' ); ?>" value="<?php echo esc_html($search_location); ?>" />
											<span class="clear-location"><i class="fa fa-times"></i></span>
											<span class="find-me"><?php get_template_part( 'images/icon/location' ); ?></span>
											<input type="hidden" name="search_lat" id="search_lat" value="<?php echo esc_html($search_lat); ?>" />
											<input type="hidden" name="search_lng" id="search_lng" value="<?php echo esc_html($search_lng); ?>" />
										</div>
									<?php } ?>
									<?php
									if ( is_tax('job_listing_region') ) {
										global $wp_query;
										$term =	$wp_query->queried_object;
										?>
										<input type="hidden" name="job_region_select" value="<?php echo esc_attr($term->term_id); ?>">
										<?php
									}
									?>
									
								<?php } ?>
									
								<?php if ( findgo_get_config('listing_filter_show_tags', 'more-filter') ) {
									$job_amenities = get_terms( array( 'job_listing_amenity' ), array( 'hierarchical' => 1, 'hide_empty' => false  ) );
									if ( !empty( $job_amenities ) ) {
										?>
										<div class="search_tag_wrapper">
											<a href="javascript:void(0);" class="show-more-filter title"><?php esc_html_e('Tags', 'findgo'); ?>
												<?php if ( findgo_get_config('listing_filter_show_tags', 'more-filter') === 'more-filter' ) { ?>
													<i class="fa fa-plus"></i>
												<?php } else { ?>
													<i class="fa fa-minus"></i>
												<?php } ?>
											</a>
											<div class="tags-wrap <?php if ( findgo_get_config('listing_filter_show_tags', 'more-filter') !== 'more-filter' ) { ?>active<?php } ?>">
											<?php
											$selected = '';
											if ( is_tax( 'job_listing_amenity' )  ) {
												global $wp_query;
												$term =	$wp_query->queried_object;
												$selected = $term->slug;
											}
										?>
												<ul class="row job_tags">
													<?php foreach ( $job_amenities as $amenity ) : ?>
														<li class="col-xs-6"><label for="job_amenity_<?php echo esc_attr($amenity->slug); ?>" class="<?php echo sanitize_title( $amenity->name ); ?>"><input type="checkbox" name="filter_job_amenity[]" value="<?php echo trim($amenity->slug); ?>" id="job_amenity_<?php echo esc_attr($amenity->slug); ?>" <?php echo trim($selected == $amenity->slug ? 'checked="checked"' : ''); ?> /> <?php echo trim($amenity->name); ?></label></li>
													<?php endforeach; ?>
												</ul>
											</div>
										</div>
								<?php }
								} ?>

								<?php if ( findgo_get_config('listing_filter_show_distance', true) && ( findgo_get_config('listing_filter_type', 'region') !== 'region' ) ) {
									$distance_type = findgo_get_config('listing_filter_distance_type', 'km');
								?>
									<div class="search_distance_wrapper clearfix">
										<div class="search-distance-label">
											<label for="use_search_distance">
												<input name="use_search_distance" id="use_search_distance" checked="checked" type="checkbox">
												<?php echo sprintf(__('Radius: <span class="text-distance">%s</span> %s', 'findgo'), esc_html($search_distance), esc_html($distance_type)); ?>
											</label>
										</div>
										<div class="search-distance-wrapper">
											<input type="hidden" name="search_distance" id="search_distance" value="<?php echo esc_html($search_distance); ?>" />
											<div id="search-distance-slider"><div id="distance-custom-handle" class="ui-slider-handle"></div></div>
										</div>
									</div>
								<?php } ?>

								<!-- tags -->
								<?php
									if ( is_tax( 'job_listing_tag' )  ) {
										global $wp_query;
										$term =	$wp_query->queried_object;
										?>
										<input type="hidden" name="filter_job_tag[]" value="<?php echo trim($term->slug); ?>" id="job_tag_<?php echo esc_attr($amenity->slug); ?>" />
								<?php } ?>
								<div class="listing-search-result-filter"></div>
							</div>
						</div>
						
						<?php do_action( 'job_manager_job_filters_search_jobs_end', $atts ); ?>
					</div>
					<?php do_action( 'job_manager_job_filters_end', $atts ); ?>
					</div>
				</form>
	  		
		<?php if ( $layout == 'default' ) { ?>
				<?php if ( is_active_sidebar( $sidebar['sidebar'] ) ): ?>
			  		<aside class="sidebar1" itemscope="itemscope" itemtype="http://schema.org/WPSideBar">
			   			<?php dynamic_sidebar( $sidebar['sidebar'] ); ?>
			   		</aside>
		   		<?php endif; ?>
			</div>
	<?php } elseif($layout == 'half-map-v1' || $layout == 'half-map-v2' || $layout == 'half-map-v3' ) { ?>
		</div>
		</div>
		<div class="mobile-groups-button hidden-lg hidden-md">
			<button class="btn-xs btn btn-second btn-filter">
				<?php esc_html_e('Search Filters', 'findgo'); ?>
			</button>
			<button class="pull-right btn btn-xs btn-second btn-view-map" type="button"><i class="fa fa-map-o" aria-hidden="true"></i> <?php esc_html_e( 'Map View', 'findgo' ); ?></button>
			<button class="pull-right btn btn-xs btn-second btn-view-listing hidden-sm hidden-xs" type="button"><i class="fa fa-list" aria-hidden="true"></i> <?php esc_html_e( 'Listing View', 'findgo' ); ?></button>
		</div>

	<?php } ?>
<?php } ?>
<?php do_action( 'job_manager_job_filters_after', $atts ); ?>
<noscript><?php esc_html_e( 'Your browser does not support JavaScript, or it is disabled. JavaScript must be enabled in order to view listings.', 'findgo' ); ?></noscript>	