<?php
/**
 * The template for displaying the WP Job Manager Filters on the front page hero
 *
 * @package Findgo
 */
$show_categories = true;
if ( ! get_option( 'job_manager_enable_categories' ) ) {
	$show_categories = false;
}
$atts = apply_filters( 'job_manager_ouput_jobs_defaut', array(
    'per_page' => get_option( 'job_manager_per_page' ),
    'orderby' => 'featured',
    'order' => 'DESC',
    'show_categories' => $show_categories,
    'show_tags' => false,
    'categories' => true,
    'selected_category' => false,
    'job_types' => false,
    'location' => false,
    'keywords' => false,
    'selected_job_types' => false,
    'show_category_multiselect' => false,
    'selected_region' => false
) );

?>

<?php do_action( 'job_manager_job_filters_before', $atts ); ?>

<form class="job_search_form  js-search-form" action="<?php echo findgo_get_listings_page_url(); ?>" method="get" role="search">
	<?php if ( ! get_option('permalink_structure') ) {
		//if the permalinks are not activated we need to put the listings page id in a hidden field so it gets passed
		$listings_page_id = get_option( 'job_manager_jobs_page_id', false );
		//only do this in case we do have a listings page selected
		if ( false !== $listings_page_id ) {
			echo '<input type="hidden" name="p" value="' . $listings_page_id . '">';
		}
	} ?>
	<?php do_action( 'job_manager_job_filters_start', $atts ); ?>

	<div class="search_jobs clearfix visible-table search_jobs--frontpage">

		<?php do_action( 'job_manager_job_filters_search_jobs_start', $atts ); ?>
		<div class="inner-left">
			<div class="visible-table table-wrapper">
				<!-- keywords -->
				<?php if ( !empty($search_keyword) ) {
					$has_search_menu = false;
					if ( has_nav_menu( 'suggestions_search' ) )  {
						$has_search_menu = true;
					}
				?>
					<div class="search-field-wrapper  search-filter-wrapper <?php echo ($has_search_menu ? 'has-suggestion' : ''); ?>">
						<label for="search_keywords" class="hidden"><?php esc_html_e( 'Keywords', 'findgo' ); ?></label>
						<input class="search-field" autocomplete="off" type="text" name="search_keywords" id="search_keywords" placeholder="<?php esc_attr_e( 'What are you looking for?', 'findgo' ); ?>" value="<?php the_search_query(); ?>"/>
						<?php
						if ( !empty($show_search_suggestions) ) {
							$args = array(
			                    'theme_location' => 'suggestions_search',
			                    'container_class' => 'navbar-collapse navbar-collapse-suggestions',
			                    'menu_class' => 'nav search-suggestions-menu',
			                    'fallback_cb' => '',
			                    'walker' => new Findgo_Nav_Menu()
			                );
			                wp_nav_menu($args);
			            }
		                ?>
					</div>
				<?php } ?>
				<!-- location -->
				<?php if ( !empty($search_region_location) && $search_region_location == 'region' ) { ?>
					<div class="search_location search-filter-wrapper">
						<?php
						$job_regions = get_terms( array( 'job_listing_region' ), array( 'hierarchical' => 1, 'hide_empty' 	  => false ) );
						if ( ! is_wp_error( $job_regions ) && ! empty ( $job_regions ) ) { ?>
							<div class="select-regions">
								<select class="regions-select <?php echo ( is_rtl() ? 'chosen-rtl' : '' ); ?>" data-placeholder="<?php esc_attr_e( 'Filter by regions', 'findgo' ); ?>" name="job_region_select">
									<option value=""><?php esc_html_e( 'All Regions', 'findgo' ); ?></option>
									<?php foreach ( $job_regions as $term ) : ?>
										<option value="<?php echo esc_attr($term->term_id); ?>"><?php echo trim($term->name); ?></option>
									<?php endforeach; ?>
								</select>
							</div>
						<?php } ?>
					</div>
				<?php } elseif ( !empty($search_region_location) && $search_region_location == 'location' ) { ?>
					<div class="search_location search-filter-wrapper">
						<input type="text" name="search_location" id="search_location" placeholder="<?php esc_attr_e( 'Location', 'findgo' ); ?>" />
						<span class="clear-location"><i class="fa fa-times"></i></span>
						<span class="find-me"><?php get_template_part( 'images/icon/location' ); ?></span>
						<input type="hidden" name="search_lat" id="search_lat" />
						<input type="hidden" name="search_lng" id="search_lng" />
						<input class="hidden" type="checkbox" checked name="use_search_distance" id="use_search_distance" value="on">
						<input type="hidden" name="search_distance" id="search_distance" value="<?php echo esc_attr(findgo_get_config('listing_filter_distance_default', 50)); ?>" />
					</div>
				<?php } ?>

				<?php if ( !empty($search_category) && true === $show_categories ) { ?>
			        <div class="search_categories  search-filter-wrapper">
			            <?php job_manager_dropdown_categories( array( 'taxonomy' => 'job_listing_category', 'hierarchical' => 1, 'show_option_all' => esc_html__( 'All Categories', 'findgo' ), 'name' => 'search_categories', 'orderby' => 'name', 'multiple' => false, 'hide_empty' 	  => false, 'placeholder' => esc_html__( 'All Categories', 'findgo' ) ) ); ?>
			        </div>
		        <?php } ?>
	        </div>
		</div>
		<?php do_action( 'job_manager_job_filters_search_jobs_end', $atts ); ?>

		<div class="submit">
			<button class="search-submit btn pull-right <?php echo ($style == 'style2') ?'btn-second':'btn-theme'; ?> " name="submit">
				<span><?php esc_html_e( 'Search', 'findgo' ); ?></span>
				<i class="flaticon-search"></i>
			</button>
		</div>
	</div>

	<?php if ( !empty($show_popular_search) ) { ?>
		<div class="popular-searchs">
			<span class="popular-searchs-title"><?php esc_html_e('Popular Searchs', 'findgo'); ?></span>
			<?php
				$args = array(
				    'menu' => $show_popular_search,
				    'container_class' => 'nav-popular-searchs-wrapper',
				    'menu_class' => 'nav-popular-searchs',
				    'fallback_cb' => ''
				);
                wp_nav_menu($args);
            ?>
		</div>
	<?php } ?>

	<div class="filters_end">
		<?php do_action( 'job_manager_job_filters_end', $atts ); ?>
	</div>
</form>
<?php do_action( 'job_manager_job_filters_after', $atts ); ?> 