<div id="job-manager-job-dashboard" class="box-user">
	<h3 class="title my-listing-title"><?php esc_html_e( 'My Listings', 'findgo' ); ?></h3>
	<div class="content-inner">
		<p class="hidden"><?php esc_html_e( 'Your listings are shown in the table below.', 'findgo' ); ?></p>
		<div class="job-manager-jobs clearfix">
			
			<?php if ( ! $jobs ) : ?>
				<div>
					<?php esc_html_e( 'You do not have any active listings.', 'findgo' ); ?>
				</div>
			<?php else :
				$jobs_status = array();
				foreach ($jobs as $job) {
					$jobs_status[$job->post_status][] = $job;
				}
			?>	
				<ul class="nav-tabs nav-tabs-manager">
				  	<li class="active"><a data-toggle="tab" href="#tab-all"><?php esc_html_e('All', 'findgo'); ?>(<?php echo count($jobs); ?>)</a></li>
				  	<?php foreach ($jobs_status as $key => $value) { ?>
				  		<li><a data-toggle="tab" href="#tab-<?php echo esc_attr($key); ?>">
				  		<?php if ( $key == 'publish' ) { ?>
				  			<?php echo sprintf(__('active (%s)', 'findgo'), count($jobs_status[$key])); ?>
			  			<?php } else { ?>
			  				<?php echo esc_attr($key).'('.count($jobs_status[$key]).')'; ?>
			  			<?php } ?>
				  		</a></li>
				  	<?php } ?>
				</ul>
				<div class="tab-content clearfix">
					<div id="tab-all" class="tab-pane fade in active">
						<?php foreach ( $jobs as $job ) { ?>
							<?php get_job_manager_template( 'job_manager/loop/list-my-listing.php', array('job' => $job) ); ?>
						<?php } ?>
					</div>
					<?php foreach ($jobs_status as $key => $value) { ?>
				  		<div id="tab-<?php echo esc_attr($key); ?>" class="tab-pane fade">
				  			<?php foreach ( $jobs_status[$key] as $job ) { ?>
								<?php get_job_manager_template( 'job_manager/loop/list-my-listing.php', array('job' => $job) ); ?>
							<?php } ?>
				  		</div>
				  	<?php } ?>
				</div>
				
			<?php endif; ?>
		</div>
		<?php get_job_manager_template( 'pagination.php', array( 'max_num_pages' => $max_num_pages ) ); ?>
	</div>
</div>