<?php
global $wp_locale, $thepostid;
$days = findgo_get_days_of_week();
if ( is_admin() ) {
	global $field;
}
if ( empty( $field[ 'value' ] ) ) {
	$field[ 'value' ] = get_post_meta( $thepostid, '_job_hours', true );
}
?>
<table>
	<tr>
		<th width="40%" class="day-th"><?php esc_html_e( 'Day', 'findgo' ); ?></th>
		<th align="left"><?php esc_html_e( 'Open', 'findgo' ); ?></th>
		<th align="left"><?php esc_html_e( 'Close', 'findgo' ); ?></th>
	</tr>

	<?php foreach ( $days as $key => $day ) :
		$start_value = isset( $field[ 'value' ][ $day ] ) && isset( $field[ 'value' ][ $day ][ 'start' ] ) ? $field[ 'value' ][ $day ][ 'start' ] : '';
		$end_value = isset( $field[ 'value' ][ $day ] ) && isset( $field[ 'value' ][ $day ][ 'end' ] ) ? $field[ 'value' ][ $day ][ 'end' ] : '';
	?>
		<tr>
			<td align="left"><?php echo trim($wp_locale->get_weekday( $day )); ?></td>
			<td align="left" class="hours">
				<input type="text" class="timepicker" name="job_hours[<?php echo trim($day); ?>][start]" value="<?php echo trim($start_value); ?>" class="regular-text" />
			</td>
			<td align="left" class="hours">
				<input type="text" class="timepicker" name="job_hours[<?php echo trim($day); ?>][end]" value="<?php echo trim($end_value); ?>" class="regular-text" />
			</td>
		</tr>
	<?php endforeach; ?>
</table>