<?php

class Findgo_Listing_Search extends Apus_Widget {
    public function __construct() {
        parent::__construct(
            'apus_listing_search',
            esc_html__('Apus Listing Search Widget', 'findgo'),
            array( 'description' => esc_html__( 'Show listing search form in sidebar', 'findgo' ), )
        );
        $this->widgetName = 'listing-search';
    }

    public function getTemplate() {
        $this->template = 'listing-search.php';
    }

    public function widget( $args, $instance ) {
        $this->display($args, $instance);
    }
    
    public function form( $instance ) {
        $defaults = array(
            'show_on_homepage' => '',
            'search_keyword' => 'on',
            'show_search_suggestions' => 'on',
            'search_region' => 'on',
            'search_category' => 'on',
        );
        $instance = wp_parse_args((array) $instance, $defaults);
        // Widget admin form
        ?>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['show_on_homepage'], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id('show_on_homepage')); ?>"
                name="<?php echo esc_attr($this->get_field_name('show_on_homepage')); ?>" />
                <label for="<?php echo esc_attr($this->get_field_id('show_on_homepage')); ?>">
                    <?php echo esc_html__( 'Enable Search Form on Homepage', 'findgo' ); ?>
                </label>
        </p>
        <p>
            <input class="checkbox p_input_search_keyword" type="checkbox" <?php checked( $instance['search_keyword'], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id('search_keyword')); ?>"
                name="<?php echo esc_attr($this->get_field_name('search_keyword')); ?>" />
                <label for="<?php echo esc_attr($this->get_field_id('search_keyword')); ?>">
                    <?php echo esc_html__( 'Enable Search Keyword', 'findgo' ); ?>
                </label>
        </p>
        <p class="p_show_search_suggestions">
            <label for="<?php echo esc_attr($this->get_field_id('show_search_suggestions')); ?>">
                <input class="checkbox" type="checkbox" <?php checked( $instance['show_search_suggestions'], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id('show_search_suggestions')); ?>"
                name="<?php echo esc_attr($this->get_field_name('show_search_suggestions')); ?>" />
               
                    <?php echo esc_html__( 'Enable Search Suggestions', 'findgo' ); ?>
            </label>
            <br>
            <span><?php esc_html_e( 'Go to', 'findgo' ); ?></span>
            <a href="<?php echo  esc_url( admin_url( 'nav-menus.php') ); ?>" target="_blank" title="<?php esc_attr_e( 'Menu', 'findgo' ); ?>"><?php esc_html_e( 'Menu', 'findgo' ); ?></a>
            <span><?php esc_html_e( 'to add menu for "Suggestions Search" location', 'findgo' ); ?></span>
        </p>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['search_region'], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id('search_region')); ?>"
                name="<?php echo esc_attr($this->get_field_name('search_region')); ?>" />
                <label for="<?php echo esc_attr($this->get_field_id('search_region')); ?>">
                    <?php echo esc_html__( 'Enable Search Regions', 'findgo' ); ?>
                </label>
        </p>
        <p>
            <input class="checkbox" type="checkbox" <?php checked( $instance['search_category'], 'on' ); ?> id="<?php echo esc_attr($this->get_field_id('search_category')); ?>"
                name="<?php echo esc_attr($this->get_field_name('search_category')); ?>" />
                <label for="<?php echo esc_attr($this->get_field_id('search_category')); ?>">
                    <?php echo esc_html__( 'Enable Search Category', 'findgo' ); ?>
                </label>
        </p>
<?php
    }

    public function update( $new_instance, $old_instance ) {
        $instance = array();
        $instance['show_on_homepage'] = ( ! empty( $new_instance['show_on_homepage'] ) ) ? strip_tags( $new_instance['show_on_homepage'] ) : '';
        $instance['search_keyword'] = ( ! empty( $new_instance['search_keyword'] ) ) ? strip_tags( $new_instance['search_keyword'] ) : '';
        $instance['show_search_suggestions'] = ( ! empty( $new_instance['show_search_suggestions'] ) ) ? strip_tags( $new_instance['show_search_suggestions'] ) : '';
        $instance['search_region'] = ( ! empty( $new_instance['search_region'] ) ) ? strip_tags( $new_instance['search_region'] ) : '';
        $instance['search_category'] = ( ! empty( $new_instance['search_category'] ) ) ? strip_tags( $new_instance['search_category'] ) : '';
        return $instance;
    }
}

register_widget( 'Findgo_Listing_Search' );