<?php

// get listings
function findgo_get_listings( $args = array() ) {
	$args = wp_parse_args( $args, array(
		'type' => '',
		'post_per_page' => -1,
		'paged' => 1,
		'categories' => '',
		'regions' => '',
		'orderby' => '',
        'order' => '',
	));

	$query_args = array(
		'post_type' => 'job_listing',
		'post_status' => 'publish',
		'posts_per_page' => $args['post_per_page'],
		'ignore_sticky_posts' => true,
		'paged' => $args['paged'],
		'orderby'   => $args['orderby'],
        'order' => $args['order']
	);

	if ( $args['type'] == 'popular' ) {
		$query_args['meta_key'] = '_listing_views_count';
		$query_args['order'] = 'DESC';
	} elseif ( $args['type'] == 'featured' ) {
		$query_args['meta_query'] =  array(
	       	array(
	           'key' => '_featured',
	           'value' => '1',
	           'compare' => '=',
	       	)
		);
	} elseif ( $args['type'] == 'rand' ) {
		$query_args['orderby'] = 'rand';
	}

	if ( !empty($args['categories']) && is_array($args['categories']) ) {
        $query_args['tax_query'][] = array(
            'taxonomy'      => 'job_listing_category',
            'field'         => 'slug',
            'terms'         => $args['categories'],
            'operator'      => 'IN'
        );
    }

    if ( !empty($args['regions']) && is_array($args['regions']) ) {
        $query_args['tax_query'][] = array(
            'taxonomy'      => 'job_listing_region',
            'field'         => 'slug',
            'terms'         => $args['regions'],
            'operator'      => 'IN'
        );
    }

	$wp_query = new WP_Query( $query_args );
	return $wp_query;
}

function findgo_get_listings_nearby($categories, $lat, $lng, $post_per_page = -1, $excludes = array()) {
	global $wpdb, $wp_query;
	$args = array(
		'post_type' => 'job_listing',
		'post_status' => 'publish',
		'posts_per_page' => $post_per_page,
		'ignore_sticky_posts' => true,
		'paged' => 1
	);
	if ($categories) {
		foreach ($categories as $category) {
			$tax_query[] = array(
				'taxonomy' => 'job_listing_category',
				'field'    => 'term_id',
				'terms'    => $category
			);
		}
		$args['tax_query'] = $tax_query;
	}
	if (!empty($excludes)) {
		$args['post__not_in'] = $excludes;
	}

	$use_distance = true;
	$distance = 50;
	$location = true;

	if ( !( $use_distance && $lat && $lng && $distance ) || !$location ) {
		return false;
	}
	$earth_distance = 3959;

	$sql = $wpdb->prepare( "
		SELECT $wpdb->posts.ID, 
			( %s * acos( 
				cos( radians(%s) ) * 
				cos( radians( latitude.meta_value ) ) * 
				cos( radians( longitude.meta_value ) - radians(%s) ) + 
				sin( radians(%s) ) * 
				sin( radians( latitude.meta_value ) ) 
			) ) 
			AS distance, latitude.meta_value AS latitude, longitude.meta_value AS longitude
			FROM $wpdb->posts
			INNER JOIN $wpdb->postmeta AS latitude ON $wpdb->posts.ID = latitude.post_id
			INNER JOIN $wpdb->postmeta AS longitude ON $wpdb->posts.ID = longitude.post_id
			WHERE 1=1 AND ($wpdb->posts.post_status = 'publish' ) AND latitude.meta_key='geolocation_lat' AND longitude.meta_key='geolocation_long' 
			HAVING distance < %s
			ORDER BY $wpdb->posts.menu_order ASC, distance ASC",
		$earth_distance,
		$lat,
		$lng,
		$lat,
		$distance
	);

	$post_ids = $wpdb->get_results( $sql, OBJECT_K );

	$distances = array();
	if ( empty( $post_ids ) || ! $post_ids ) {
        $post_ids = array(0);
	} else {
		foreach ($post_ids as $listing) {
			$distances[$listing->ID] = $listing->distance;
		}
		
	}
	$args[ 'post__in' ] = array_keys( (array) $post_ids );
	$args = findgo_remove_location_meta_query( $args );
	$listings = get_posts( $args );

	return array( 'listings' => $listings, 'distances' => $distances );
}

function findgo_set_post_views($postID) {
    $count_key = '_listing_views_count';
    $count = get_post_meta($postID, $count_key, true);
    if ($count == '') {
        $count = 0;
        delete_post_meta($postID, $count_key);
        add_post_meta($postID, $count_key, '0');
    } else {
        $count++;
        update_post_meta($postID, $count_key, $count);
    }
}

function findgo_track_post_views ($post_id) {
    if ( !is_singular('job_listing') )
    	return;
    if ( empty ( $post_id) ) {
        global $post;
        $post_id = $post->ID;    
    }
    findgo_set_post_views($post_id);
}
add_action( 'wp_head', 'findgo_track_post_views');

if ( !function_exists('findgo_listing_content_class') ) {
	function findgo_listing_content_class( $class ) {
		$page = 'archive';
		if ( is_singular( 'job_listing' ) ) {
            $page = 'single';
        }
		if ( findgo_get_config('listing_'.$page.'_fullwidth') ) {
			return 'container-fluid';
		}
		return $class;
	}
}
add_filter( 'findgo_listing_content_class', 'findgo_listing_content_class', 1 , 1  );


if ( !function_exists('findgo_get_listings_sidebar_configs') ) {
	function findgo_get_listings_sidebar_configs() {
		$page = 'archive';
		if ( is_singular( 'job_listing' ) ) {
            $page = 'single';
        }
		$sidebar = findgo_get_config('listing_'.$page.'_sidebar');

		switch ( findgo_get_config('listing_'.$page.'_layout') ) {
			case 'main':
		 		$configs = array( 'sidebar' => $sidebar,  'class' => '' );
		 		break;
		 	case 'main-right':
		 		$configs = array( 'sidebar' => $sidebar,  'class' => 'pull-right sidebar-right' );
		 		break;
	 		case 'left-main':
		 	default:
		 		$configs = array( 'sidebar' => $sidebar, 'class' => 'pull-left sidebar-left' );
		 		break;
		}

		return $configs; 
	}
}

function findgo_get_listing_all_half_map_version() {
	return apply_filters( 'findgo_get_listing_all_half_map_version', array(
		'half-map-v1',
		'half-map-v2',
		'half-map-v3',
		'half-map-v4'
	) );
}

function findgo_get_listing_archive_version() {
	$version = findgo_get_config('listing_archive_layout_version', 'half-map-v1');
	$version = !empty($version) ? $version : 'half-map-v1';
	
	return $version;
}

function findgo_get_listing_item_style() {
	return findgo_get_listing_display_mode();
}

function findgo_get_listing_display_mode() {
	if (isset($_COOKIE['findgo_display_mode']) && in_array($_COOKIE['findgo_display_mode'], array('grid', 'list'))) {
		return $_COOKIE['findgo_display_mode'];
	}
	return findgo_get_config('listing_archive_display_mode', 'grid');
}

function findgo_get_listing_item_columns() {
	$display_mode = findgo_get_listing_display_mode();
	switch ($display_mode) {
		case 'list':
			$columns = 1;
			break;
		default:
			$columns = findgo_get_config('listing_columns', 2);
			break;
	}
	return apply_filters( 'findgo_get_listing_item_columns', $columns );
}

function findgo_get_listing_single_version() {
	global $post;
	$single_layout = get_post_meta($post->ID, '_job_layout_type', true);
	if ( empty($single_layout) || $single_layout == 'global' ) {
		$single_layout = findgo_get_config('listing_single_layout_version', 'v1');
	}
	$single_layout = !empty($single_layout) ? $single_layout : 'v1';
	return $single_layout;
}

function findgo_listing_enqueue_styles() {
    wp_enqueue_style( 'leaflet', get_template_directory_uri() . '/css/leaflet.css', array(), '0.7.7' );
}
add_action( 'wp_enqueue_scripts', 'findgo_listing_enqueue_styles', 99 );

function findgo_listing_enqueue_scripts() {
    wp_enqueue_script( 'leaflet', get_template_directory_uri() . '/js/leaflet.js', array( 'jquery' ), '0.7.7', true );
	wp_enqueue_script( 'findgo-listing', get_template_directory_uri() . '/js/listing.js', array( 'jquery', 'jquery-ui-slider', 'wp-job-manager-ajax-filters', 'google-map-api' ), '0.7.7', true );

	$mapbox_token = '';
	$mapbox_style = '';
	$custom_style = '';
	$map_service = findgo_get_config('listing_map_style_type', 'google');
	if ( $map_service == 'mapbox' ) {
		$mapbox_token = findgo_get_config('listing_mapbox_token', '');
		$mapbox_style = findgo_get_config('listing_mapbox_style', 'streets-v11');
		if ( empty($mapbox_style) || !in_array($mapbox_style, array( 'streets-v11', 'light-v10', 'dark-v10', 'outdoors-v11', 'satellite-v9' )) ) {
			$mapbox_style = 'streets-v11';
		}
	} else {
		$custom_style = findgo_get_config('listing_map_custom_style', '');
	}
	wp_localize_script( 'findgo-listing', 'findgo_listing_opts', array(
		'ajaxurl' => admin_url( 'admin-ajax.php' ),
		'login_url' => rtrim( esc_url( wp_login_url() ) , '/'),
		'strings' => array(
			'wp-job-manager-file-upload' => esc_html__( 'Add Photo', 'findgo' ),
			'no_job_listings_found' => esc_html__( 'No results', 'findgo' ),
			'results-no' => esc_html__( 'Results Found', 'findgo')
		),
		'map_service' => $map_service,
		'mapbox_token' => $mapbox_token,
		'mapbox_style' => $mapbox_style,
		'custom_style' => $custom_style,
		'default_icon' => get_template_directory_uri() . '/images/default-icon.png',

		// submit form vars
		'timeFormat' => str_replace( '\\', '\\\\', get_option( 'time_format' ) ),
		'none_option_label' => esc_html__( 'Closed', 'findgo' ),
		'none_option_value' => esc_html__( 'Closed', 'findgo' ),

		'default_latitude' => findgo_get_config('listing_map_latitude', '54.800685'),
		'default_longitude' => findgo_get_config('listing_map_longitude', '-4.130859'),
		'nonce' => wp_create_nonce( 'ajax-nonce' ),
	) );
}
add_action( 'wp_enqueue_scripts', 'findgo_listing_enqueue_scripts', 10 );

function findgo_get_listings_page_url( $default_link = null  ) {
	//if there is a page set in the Listings settings use that
	$listings_page_id = get_option( 'job_manager_jobs_page_id', false );
	if ( ! empty( $listings_page_id ) ) {
		return get_permalink( $listings_page_id );
	}

	if ( $default_link !== null ) {
		return $default_link;
	}
	return get_post_type_archive_link( 'job_listing' );
}

function findgo_display_categories_icon( $terms ) {
	if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ) {
		foreach ($terms as $term) {
			$icon = '';
			if ( class_exists('Taxonomy_MetaData_CMB2') ) {
				$icon = Taxonomy_MetaData_CMB2::get('job_listing_category', $term->term_id, 'icon');
			}
			if ( !empty($icon) ) {
			?>
				<a href="<?php echo esc_url( get_term_link($term->term_id, 'job_listing_category') ); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $term->name); ?>">
					<img src="<?php echo esc_url($icon); ?>" alt="<?php echo esc_attr( $term->name ); ?>">
				</a>
			<?php
			}
		}
	}
}

function findgo_display_categories( $terms ) {
	if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ) {
		echo '<strong>'.esc_html__('In: ','findgo').'</strong>';
		$i = 0;
		foreach ($terms as $term) {
			?>
				<?php if($i != 0) echo ', ';?>
				<a href="<?php echo esc_url( get_term_link($term->term_id, 'job_listing_category') ); ?>" data-toggle="tooltip" data-placement="top" title="<?php echo esc_attr( $term->name); ?>">
					<?php echo esc_attr( $term->name); ?>
				</a>

			<?php
			$i++;
		}
	}
}

function findgo_display_hidden_category_icon( $terms ) {
	if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ) {
		foreach ($terms as $term) {
			$icon = $icon_font = '';
			if ( class_exists('Taxonomy_MetaData_CMB2') ) {
				$icon = Taxonomy_MetaData_CMB2::get('job_listing_category', $term->term_id, 'icon');
				$icon_font = Taxonomy_MetaData_CMB2::get( 'job_listing_category', $term->term_id, 'icon_font' );
			}
			if ( !empty($icon) ) {
				?>
				<div class="listing-cat-icon hidden">
					<img src="<?php echo esc_url_raw($icon); ?>" alt="<?php echo esc_attr( $term->name ); ?>">
				</div>
				<?php
				return;
			} elseif( !empty($icon_font) ) {
				?>
				<div class="listing-cat-icon hidden">
					<i class="<?php echo esc_attr($icon_font); ?>"></i>
				</div>
				<?php
				return;
			}
		}
	}
}

function findgo_display_category_icon( $term ) {
	$icon = $icon_font = '';
	if ( class_exists('Taxonomy_MetaData_CMB2') ) {
		$icon = Taxonomy_MetaData_CMB2::get('job_listing_category', $term->term_id, 'icon');
		$icon_font = Taxonomy_MetaData_CMB2::get( 'job_listing_category', $term->term_id, 'icon_font' );
	}
	$html = '';
	if ( !empty($icon) ) {
		$html = '<img class="listing-cat-icon-img" src="'.esc_url_raw($icon).'" alt="'.esc_attr( $term->name ).'">';
	} elseif( !empty($icon_font) ) {
		$html = '<i class="'.esc_attr($icon_font).'"></i>';
	}
	return $html;
}

function findgo_get_days_of_week() {
	$days = array(0, 1, 2, 3, 4, 5, 6);

	$start_day = get_option( 'start_of_week' );

	$first = array_splice( $days, $start_day, count( $days ) - $start_day );

	$second = array_splice( $days, 0, $start_day );

	$days = array_merge( $first, $second );

	return $days;
}

function findgo_get_day_hours($hours) {
	global $wp_locale;
	if (empty($hours) || !is_array($hours)) {
		return;
	}
    $numericdays = findgo_get_days_of_week();
    $days = array();
    foreach ( $numericdays as $key => $i ) {
        $day = $wp_locale->get_weekday( $i );
        $start = isset( $hours[ $i ][ 'start' ] ) ? $hours[ $i ][ 'start' ] : false;
        $end = isset( $hours[ $i ][ 'end' ] ) ? $hours[ $i ][ 'end' ] : false;

        if ( ! ( $start && $end ) ) {
            continue;
        }

        $days[ strtolower($day) ] = array( $start, $end );
    }
    return $days;
}

function findgo_set_course_views($content) {
	global $post;
	if ( empty($post->post_type) || $post->post_type != 'job_listing' ) {
		return $content;
	}
    $count_key = '_views_count';
    $count = get_post_meta($post->ID, $count_key, true);
    if ($count == '') {
        delete_post_meta($post->ID, $count_key);
        add_post_meta($post->ID, $count_key, 1);
    } else {
        $count++;
        $value = sanitize_text_field($count);
        update_post_meta($post->ID, $count_key, $value);
    }
    return $content;
}
//To keep the count accurate, lets get rid of prefetching
remove_action( 'wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
add_filter( 'the_content', 'findgo_set_course_views' );

function findgo_get_content_sort() {
	$contents = findgo_get_config( 'listing_single_sort_content', array() );

	if ( isset( $contents['enabled'] ) ) {
		$contents = $contents['enabled'];
		if ( isset($contents['placebo']) ) {
			unset($contents['placebo']);
		}
		return $contents;
	}

	return array();
}

function findgo_get_sidebar_content_sort() {
	$contents = findgo_get_config( 'listing_single_sort_sidebar', array() );

	if ( isset( $contents['enabled'] ) ) {
		$contents = $contents['enabled'];
		if ( isset($contents['placebo']) ) {
			unset($contents['placebo']);
		}
		return $contents;
	}

	return array();
}

function findgo_follow_user() {

	check_ajax_referer( 'ajax-nonce', 'nonce' );

	if ( !is_user_logged_in() ) {
		echo json_encode( array('status' => 'error', 'msg' => esc_html__('Please login to follow', 'findgo') ) );
		die();
	}
	$current_user_id = get_current_user_id();
	if ( $current_user_id == $user->ID ) {
		echo json_encode( array('status' => 'error', 'msg' => esc_html__('You can not follow yourself', 'findgo') ) );
		die();
	}
	$user_id = !empty($_POST['user_id']) ? $_POST['user_id'] : '';
	if ( empty($user_id) ) {
		echo json_encode( array('status' => 'error', 'msg' => esc_html__('Can not follow this user', 'findgo') ) );
		die();
	}
	$meta_key = '_apus_following';
	
	$data = get_user_meta( $current_user_id, $meta_key, true );

	if ( !empty($data) && is_array($data) && !empty($data[$user_id]) ) {
		unset($data[$user_id]);
		$class = 'btn-follow-user';
	} else {
		if ( is_array($data) ) {
			$data[$user_id] = $user_id;
		} else {
			$data = array($user_id => $user_id);
		}
		
		$class = 'btn-following-user';
	}
	update_user_meta( $current_user_id, $meta_key, $data );

	// follower
	$follower_meta_key = '_apus_followers';
	$data = get_user_meta( $user_id, $follower_meta_key, true );

	if ( !empty($data) && is_array($data) && !empty($data[$current_user_id]) ) {
		unset($data[$current_user_id]);
		$class = 'btn-follow-user';
		$msg = esc_html__('Follow', 'findgo');
	} else {
		if ( is_array($data) ) {
			$data[$current_user_id] = $current_user_id;
		} else {
			$data = array($current_user_id => $current_user_id);
		}
		
		$class = 'btn-following-user';
		$msg = '<span class="text-following">'.esc_html__('Following', 'findgo').'</span>
				<span class="text-following-hover">'.esc_html__('Unfollow', 'findgo').'</span>';
	}
	update_user_meta( $user_id, $follower_meta_key, $data );

	echo json_encode( array('status' => 'success', 'class' => $class, 'msg' => $msg) );
	die();
}
add_action( 'wp_ajax_findgo_follow_user', 'findgo_follow_user' );
add_action( 'wp_ajax_nopriv_findgo_follow_user', 'findgo_follow_user' );

function findgo_check_follow_user($user_id) {
	$current_user_id = get_current_user_id();
	$data = get_user_meta( $current_user_id, '_apus_following', true );
	if ( !empty($data) && is_array($data) && !empty($data[$user_id]) ) {
		return true;
	}
	return false;
}

function findgo_listing_display_part($template) {
	ob_start();
	get_template_part( 'job_manager/single/parts/'.$template );
	$content = ob_get_clean();
	return apply_filters( 'findgo_listing_display_part', $content, $template );
}

function findgo_preview_listing() {

	check_ajax_referer( 'ajax-nonce', 'nonce' );
	
	get_template_part( 'job_manager/preview-listing' );
	die();
}
add_action( 'wp_ajax_findgo_preview_listing', 'findgo_preview_listing' );
add_action( 'wp_ajax_nopriv_findgo_preview_listing', 'findgo_preview_listing' );


function findgo_get_listing_layout_style() {
	return apply_filters( 'findgo_get_listing_layout_style', array(
		'v1' => array(
				'title' => esc_html__('Layout Style 1', 'findgo'),
				'img' => get_template_directory_uri() . '/images/listing-layouts/v1.jpg'
			),
		'v2' => array(
				'title' => esc_html__('Layout Style 2', 'findgo'),
				'img' => get_template_directory_uri() . '/images/listing-layouts/v2.jpg'
			),
		'v3' => array(
				'title' => esc_html__('Layout Style 3', 'findgo'),
				'img' => get_template_directory_uri() . '/images/listing-layouts/v3.jpg'
			),
		'v4' => array(
				'title' => esc_html__('Layout Style 4', 'findgo'),
				'img' => get_template_directory_uri() . '/images/listing-layouts/v4.jpg'
			),
		'v5' => array(
				'title' => esc_html__('Layout Style 5', 'findgo'),
				'img' => get_template_directory_uri() . '/images/listing-layouts/v5.jpg'
			),
	));
}

function findgo_listing_single_sort_content() {
	return apply_filters( 'findgo_listing_single_sort_content', array(
        'description' => esc_html__( 'Description', 'findgo' ),
        'amenities' => esc_html__( 'Amenities', 'findgo' ),
        'photos' => esc_html__( 'Photos', 'findgo' ),
        'menu-prices' => esc_html__( 'Menu Prices', 'findgo' ),
        'video' => esc_html__( 'Video', 'findgo' ),
        'tags' => esc_html__( 'Tags', 'findgo' ),
        'hours' => esc_html__( 'Hours', 'findgo' ),
        'maps-contact' => esc_html__( 'Maps', 'findgo' ),
        'comments' => esc_html__( 'Reviews', 'findgo' ),
    ));
}

function findgo_listing_single_sort_sidebar() {
	return apply_filters( 'findgo_listing_single_sort_sidebar', array(
        'maps-contact' => esc_html__( 'Maps - Contact Info', 'findgo' ),
        'contact-form' => esc_html__( 'Contact Form', 'findgo' ),
        'tags' => esc_html__( 'Tags', 'findgo' ),
        'hours' => esc_html__( 'Hours', 'findgo' ),
        'nearby' => esc_html__( 'Nearby Places', 'findgo' ),
        'nearby_browse' => esc_html__( 'Browse Nearby Places', 'findgo' ),
        'price_range' => esc_html__( 'Price Range', 'findgo' ),
    ));
}

function findgo_the_company_name($company_name, $post) {
	return $post->post_title;
}
add_filter('the_company_name', 'findgo_the_company_name', 10, 2);

function findgo_job_manager_select2_enabled($return) {
    return true;
}
add_filter( 'job_manager_enhanced_select_enabled', 'findgo_job_manager_select2_enabled', 100 );

function findgo_get_job_listing_structured_data($data, $post) {
	return array();
}
add_filter('wpjm_get_job_listing_structured_data', 'findgo_get_job_listing_structured_data', 10, 2);


function findgo_child_add_tax_to_api() {
	$tax = get_taxonomy( 'job_listing_region' );
	if ( !empty($tax) ) {
		$tax->show_in_rest = true;
	}
	$tax = get_taxonomy( 'job_listing_amenity' );
	if ( !empty($tax) ) {
		$tax->show_in_rest = true;
	}
	$tax = get_taxonomy( 'job_listing_tag' );
	if ( !empty($tax) ) {
		$tax->show_in_rest = true;
	}
}
add_action( 'init', 'findgo_child_add_tax_to_api', 30 );

function findgo_submit_job_form_save_job_data($job_data) {
	$job_data['comment_status'] = 'open';
	return $job_data;
}
add_filter('submit_job_form_save_job_data', 'findgo_submit_job_form_save_job_data');