<?php
/**
 * apus findgo
 *
 * @package    apus-findgo
 * @author     ApusTheme <apusthemes@gmail.com >
 * @license    GNU General Public License, version 3
 * @copyright  13/06/2016 ApusTheme
 */
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}

// for custyom admin 'job_manager_input_' . $type

class Findgo_Post_Type_Job_Listing{

	public static function init() {
		add_action( 'admin_enqueue_scripts', array( __CLASS__, 'admin_enqueue_scripts' ) );
		// save [front, back]
		add_filter( 'register_post_type_job_listing', array( __CLASS__, 'change_post_type_label' ), 10 );
		add_filter( 'manage_edit-job_listing_columns', array( __CLASS__, 'job_listing_admin_columns' ), 100 );
		// custom fields
		add_filter( 'cmb2_meta_boxes', array( __CLASS__, 'metaboxes' ) );
		add_filter( 'job_manager_job_listing_data_fields', array( __CLASS__, 'add_custom_fields' ), 1 );
		add_filter( 'submit_job_form_fields', array( __CLASS__, 'custom_submit_job_form_fields' ) );

		// for admin fields
		add_action( 'job_manager_input_findgo_hours', array( __CLASS__, 'input_hours_fields' ), 10, 2 );
		add_action( 'job_manager_input_findgo-images', array( __CLASS__, 'input_radio_images_fields' ), 10, 2 );
		add_action( 'job_manager_input_findgo-location', array( __CLASS__, 'input_location_fields' ), 10, 2 );
		add_action( 'job_manager_input_findgo-menu-prices', array( __CLASS__, 'input_menu_prices_fields' ), 10, 2 );
		
		add_action( 'add_meta_boxes', array( 'Findgo_Post_Type_Job_Listing', 'addMetaBoxes' ) );
		
		// get current value
		add_filter( 'submit_job_form_fields_get_job_data', array( __CLASS__, 'get_job_data' ), 10, 2 );
		// front-end
		add_filter( 'submit_job_form_save_job_data', array( __CLASS__, 'clean_gallery_images_on_submit' ), 10, 5);
		add_action( 'job_manager_update_job_data', array( __CLASS__, 'listing_submit' ), 10, 2 );
		add_action( 'job_manager_save_job_listing', array( __CLASS__, 'listing_update_job_data' ), 10, 2 );

		add_filter( 'submit_job_form_prefix_post_name_with_company', array( __CLASS__, 'slug_only_title' ), 100 );
		add_filter( 'submit_job_form_prefix_post_name_with_location', array( __CLASS__, 'slug_only_title' ), 100 );
		add_filter( 'submit_job_form_prefix_post_name_with_job_type', array( __CLASS__, 'slug_only_title' ), 100 );
	}

	public static function change_post_type_label($args) {
		$singular = esc_html__( 'Listing', 'findgo' );
		$plural   = esc_html__( 'Listings', 'findgo' );

		$args['labels']      = array(
			'name'               => $plural,
			'singular_name'      => $singular,
			'menu_name'          => $plural,
			'all_items'          => sprintf( esc_html__( 'All %s', 'findgo' ), $plural ),
			'add_new'            => esc_html__( 'Add New', 'findgo' ),
			'add_new_item'       => sprintf( esc_html__( 'Add %s', 'findgo' ), $singular ),
			'edit'               => esc_html__( 'Edit', 'findgo' ),
			'edit_item'          => sprintf( esc_html__( 'Edit %s', 'findgo' ), $singular ),
			'new_item'           => sprintf( esc_html__( 'New %s', 'findgo' ), $singular ),
			'view'               => sprintf( esc_html__( 'View %s', 'findgo' ), $singular ),
			'view_item'          => sprintf( esc_html__( 'View %s', 'findgo' ), $singular ),
			'search_items'       => sprintf( esc_html__( 'Search %s', 'findgo' ), $plural ),
			'not_found'          => sprintf( esc_html__( 'No %s found', 'findgo' ), $plural ),
			'not_found_in_trash' => sprintf( esc_html__( 'No %s found in trash', 'findgo' ), $plural ),
			'parent'             => sprintf( esc_html__( 'Parent %s', 'findgo' ), $singular )
		);
		$args['description'] = sprintf( esc_html__( 'This is where you can create and manage %s.', 'findgo' ), $plural );
		$args['supports']    = array( 'title', 'editor', 'custom-fields', 'publicize', 'comments', 'thumbnail' );
		$args['rewrite']     = array( 'slug' => esc_html__( 'listings', 'findgo' ) );		
		$args['has_archive'] = esc_html__( 'listings', 'findgo' );
		
		return $args;
	}

	public static function admin_enqueue_scripts() {
		global $pagenow;

		if ( ! ( in_array( $pagenow, array( 'post-new.php', 'post.php'  )) && get_post_type() == 'job_listing' ) ) {
			return;
		}

		wp_enqueue_script( 'timepicker', get_template_directory_uri() . '/js/jquery.timepicker.min.js' );
		wp_enqueue_style( 'timepicker', get_template_directory_uri() . '/css/jquery.timepicker.css' );

		wp_register_script( 'findgo-timepicker', get_template_directory_uri() . '/js/admin/custom-timepicker.js', array( 'jquery', 'timepicker'  ), '20131022', true );
		wp_localize_script( 'findgo-timepicker', 'findgo_opts', array(
			'time_format' => str_replace( '\\', '\\\\', get_option( 'time_format' ) ),
			'closed_text' => esc_html__( 'Closed', 'findgo' )
		));
		wp_enqueue_script( 'findgo-timepicker' );
	}

	public static function metaboxes( array $metaboxes ) {
		$prefix = APUSFINDGO_PREFIX;
		
		$metaboxes[ $prefix . 'info' ] = array(
			'id'                        => $prefix . 'info',
			'title'                     => esc_html__( 'Gallery Images', 'findgo' ),
			'object_types'              => array( 'job_listing' ),
			'context'                   => 'side',
			'priority'                  => 'low',
			'show_names'                => true,
			'fields'                    => apply_filters( 'apus_findgo_postype_apb_room_type_metaboxes_fields_management', array(
				   	array(
					    'name' => '',
					    'id'   => $prefix . 'gallery_images',
					    'type' => 'file_list',
					    'text' => array(
					        'add_upload_files_text' => esc_html__('Add Images', 'findgo'),
					        'remove_image_text' => esc_html__('Remove Image', 'findgo'),
					        'file_text' => esc_html__('File:', 'findgo'),
					        'file_download_text' => esc_html__('Download', 'findgo'),
					        'remove_text' => esc_html__('Remove', 'findgo'),
					    ),
					)
				)
			)
		);
		return $metaboxes;
	}
	
	public static function price_ranges() {
		return apply_filters( 'apus_findgo_price_ranges', array(
				'inexpensive' => esc_html__('$ - Inexpensive', 'findgo'),
				'moderate' => esc_html__('$$ - Moderate', 'findgo'),
				'pricey' => esc_html__('$$$ - Pricey', 'findgo'),
				'ultra_high_end' => esc_html__('$$$$ - Ultra High', 'findgo'),
			));
	}

	public static function add_custom_fields( $fields ) {

		// reorder fields
		$fields['_job_location']['priority']    = 1;
		$fields['_job_location']['type']    = 'findgo-location';
		
		$fields['_company_twitter']['priority'] = 2.6;

		$fields['_company_website']['priority'] = 1.1;
		$fields['_company_tagline']['priority'] = 1.2;
		$fields['_job_expires']['priority'] = 1.3;


		$fields['_company_price_range'] = array(
			'label' => esc_html__('Price Range', 'findgo'),
			'type' => 'select',
			'required' => false,
			'placeholder' => '',
			'priority' => 1.4,
			'options' => self::price_ranges()
		);
		$fields['_company_price_from'] = array(
			'label' => esc_html__('Price From', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => '',
			'priority' => 1.5
		);
		$fields['_company_price_to'] = array(
			'label' => esc_html__('Price To', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => '',
			'priority' => 1.6
		);


		$fields['_claimed'] = array(
			'label'       => esc_html__( 'Claimed:', 'findgo' ),
			'type'        => 'checkbox',
			'description' => esc_html__( 'The owner has been verified.', 'findgo' ),
			'priority'    => 2.3,
			'required' => false,
		);
		$fields['_company_phone'] = array(
			'label'       => esc_html__( 'Phone', 'findgo' ),
			'type'        => 'text',
			'placeholder' => esc_html__( 'e.g +84-669-996', 'findgo' ),
			'priority'    => 2.4,
			'required' => false,
		);

		$fields['_company_email'] = array(
			'label'       => esc_html__( 'Email', 'findgo' ),
			'type'        => 'text',
			'placeholder' => esc_html__( 'youremail@email.com', 'findgo' ),
			'description' => '',
			'priority'    => 2.5,
			'required' => false,
		);

		$fields['_company_twitter']['label'] = esc_html__('Twitter url', 'findgo');
		$fields['_company_twitter']['placeholder'] = esc_html__('http://twitter.com/yourusername', 'findgo');
		$fields['_company_facebook'] = array(
			'label' => esc_html__('Facebook url', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => esc_html__('http://facebook.com/yourusername', 'findgo'),
			'priority' => 2.7
		);
		$fields['_company_linkedin'] = array(
			'label' => esc_html__('Linkedin url', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => esc_html__('http://linkedin.com/yourusername', 'findgo'),
			'priority' => 2.8
		);
		$fields['_company_pinterest'] = array(
			'label' => esc_html__('Pinterest url', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => esc_html__('http://pinterest.com/yourusername', 'findgo'),
			'priority' => 2.9
		);
		$fields['_company_instagram'] = array(
			'label' => esc_html__('Instagram url', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => esc_html__('http://instagram.com/yourusername', 'findgo'),
			'priority' => 3.0
		);

		

		$fields['_job_menu_prices'] = array(
			'label' => esc_html__('Menu Prices', 'findgo'),
			'type' => 'findgo-menu-prices',
			'priority' => 15,
			'placeholder' => '',
			'description' => '',
			'required' => false,
		);

		$options = findgo_get_listing_layout_style();
		$option_default = findgo_get_config('listing_single_layout_version', 'v1');
		$img = '';
		foreach ($options as $key => $option) {
			if ( $key == $option_default ) {
				$img = $option['img'];
			}
		}
		$options = array_merge( array(
			'global' => array(
				'title' => esc_html__('Global Setting', 'findgo'),
				'img' => $img
			)), $options );

		$fields['_job_layout_type'] = array(
			'label' => esc_html__('Listing Style', 'findgo'),
			'type' => 'findgo-images',
			'required' => false,
			'priority' => 20,
			'options' => $options,
			'default' => 'global'
		);

		unset( $fields['_company_logo'] );
		unset( $fields['_company_name'] );
		unset( $fields['_application'] );
		return $fields;
	}

	public static function custom_submit_job_form_fields( $fields ) {
		array_walk_recursive( $fields, array( __CLASS__, 'replace_jobs_with_listings' ) );

		if ( findgo_get_config('submit_listing_enable_listing_style', true) ) {
			$options = findgo_get_listing_layout_style();
			$option_default = findgo_get_config('listing_single_layout_version', 'v1');
			$img = '';
			foreach ($options as $key => $option) {
				if ( $key == $option_default ) {
					$img = $option['img'];
				}
			}
			$options = array_merge( array(
				'global' => array(
					'title' => esc_html__('Global Setting', 'findgo'),
					'img' => $img
				)), $options );

			$fields['job']['job_layout_type'] = array(
				'type' => 'findgo-images',
				'priority' => 0.1,
				'placeholder' => '',
				'description' => '',
				'options' => $options,
				'default' => 'global',
				'required' => false,
				'section' => 'section-1'
			);
		}
		
		// Section 2
		$fields['job']['job_title']['label']       = esc_html__( 'Listing Name', 'findgo' );
		$fields['job']['job_title']['placeholder'] = esc_html__( 'Your listing name', 'findgo' );
		$fields['job']['job_title']['section'] = 'section-2';

		// tagline
		$fields['company']['company_tagline']['section'] = 'section-2';
		$fields['company']['company_tagline']['priority'] = 2;

		// category 
		$fields['job']['job_category']['priority']    = 2.4;
		$fields['job']['job_category']['placeholder'] = esc_html__( 'Choose one or more categories', 'findgo' );

		$fields['job']['job_category']['label'] = esc_html__( 'Listing category', 'findgo' );
		$fields['job']['job_category']['description'] = sprintf( '<span class="description_tooltip right">%s</span>', esc_html__( 'Visitors can filter their search by the categories they want - so make sure you choose them wisely and include all the relevant ones', 'findgo' ) );
		$fields['job']['job_category']['section'] = 'section-2';

		// region
		$fields['job']['job_regions'] = array(
			'type' => 'term-select',
			'taxonomy' => 'job_listing_region',
			'priority' => 2.5,
			'required' => false,
			'placeholder' => esc_html__( 'Add Region', 'findgo' ),
			'label' => esc_html__( 'Listing Region', 'findgo' ),
			'description' => '',
			'default' => '',
			'section' => 'section-2',
		);

		$fields['company']['company_price_range'] = array(
			'label' => esc_html__('Price Range', 'findgo'),
			'type' => 'select',
			'required' => false,
			'priority' => 3.4,
			'options' => self::price_ranges(),
			'section' => 'section-2',
		);
		$fields['company']['company_price_from'] = array(
			'label' => esc_html__('Price From', 'findgo'),
			'type' => 'text',
			'required' => false,
			'priority' => 3.5,
			'placeholder' => esc_html__( 'e.g $100', 'findgo' ),
			'section' => 'section-2',
		);
		$fields['company']['company_price_to'] = array(
			'label' => esc_html__('Price To', 'findgo'),
			'type' => 'text',
			'required' => false,
			'priority' => 3.6,
			'placeholder' => esc_html__( 'e.g $200', 'findgo' ),
			'section' => 'section-2',
		);

		$fields['job']['job_amenities'] = array(
			'type' => 'term-multiselect',
			'taxonomy' => 'job_listing_amenity',
			'priority' => 4.5,
			'required' => false,
			'placeholder' => esc_html__( 'Choose one or more amenities', 'findgo' ),
			'label' => esc_html__( 'Listing Amenities', 'findgo' ),
			'description' => esc_html__( 'Visitors can filter their search by the amenities too, so make sure you include all the relevant ones.', 'findgo' ),
			'default' => '',
			'section' => 'section-2',
		);

		// Section 3
		$fields['job']['job_description']['priority']    = 2.2;
		$fields['job']['job_description']['placeholder'] = esc_html__( 'An overview of your listing and the things you love about it.', 'findgo' );
		$fields['job']['job_description']['section'] = 'section-3';

		$fields['job']['job_hours'] = array(
			'label'       => esc_html__( 'Hours of Operation', 'findgo' ),
			'type'        => 'findgo-hours',
			'required'    => false,
			'placeholder' => '',
			'priority'    => 3.1,
			'default'     => '',
			'section' => 'section-3'
		);

		// Section 4
		$fields['job']['job_location'] = array(
			'label'       => esc_html__( 'Location', 'findgo' ),
			'type' => 'findgo-location',
			'required' => false,
			'priority' => 2.3,
			'placeholder' => esc_html__( 'e.g 34 Wigmore Street, London', 'findgo' ),
			'description' => esc_html__( 'Leave this blank if the location is not important.', 'findgo' ),
			'section' => 'section-4',
		);

		$fields['company']['company_phone'] = array(
			'label'       => esc_html__( 'Phone', 'findgo' ),
			'type'        => 'text',
			'placeholder' => esc_html__( 'e.g +84-669-996', 'findgo' ),
			'required'    => false,
			'priority'    => 3.7,
			'section' => 'section-4'
		);
		$fields['company']['company_email'] = array(
			'label'       => esc_html__( 'Email', 'findgo' ),
			'type'        => 'text',
			'placeholder' => esc_html__( 'e.g youremail@email.com', 'findgo' ),
			'required'    => false,
			'priority'    => 3.8,
			'section' => 'section-4'
		);

		$fields['company']['company_website']['priority']    = 3.2;
		$fields['company']['company_website']['placeholder'] = esc_html__( 'e.g yourwebsite.com, London', 'findgo' );
		$fields['company']['company_website']['description'] = sprintf( '<span class="description_tooltip left">%s</span>', esc_html__( 'You can add more similar panels to better help the user fill the form', 'findgo' ) );
		$fields['company']['company_website']['section'] = 'section-4';

		// Section 5
		$fields['job']['job_menu_prices'] = array(
			'type' => 'findgo-menu-prices',
			'priority' => 3.9,
			'placeholder' => '',
			'description' => '',
			'required' => false,
			'section' => 'section-5',
		);

		// Section 6
		$fields['company']['company_logo']['label']       = esc_html__( 'Featured Image', 'findgo' );
		$fields['company']['company_logo']['priority']    = 2.7;
		$fields['company']['company_logo']['multiple']    = false;
		$fields['company']['company_logo']['description'] = esc_html__( 'The image will be shown on listing cards.', 'findgo' );
		$fields['company']['company_logo']['section'] = 'section-6';

		$fields['company']['gallery_images'] = array(
			'label' => esc_html__( 'Gallery Images', 'findgo' ),
			'priority' => 2.9,
			'required' => false,
			'type' => 'file',
			'ajax' => true,
			'placeholder' => '',
			'allowed_mime_types' => $fields['company']['company_logo']['allowed_mime_types'],
			'multiple' => true,
			'section' => 'section-6',
		);
		
		$fields['company']['company_video']['priority']    = 3.0;
		$fields['company']['company_video']['section']    = 'section-6';

		
		// Section 6
		$fields['company']['company_twitter']['label'] = esc_html__('Twitter url', 'findgo');
		$fields['company']['company_twitter']['placeholder'] = esc_html__('http://twitter.com/yourusername', 'findgo');
		$fields['company']['company_twitter']['section'] = 'section-7';
		$fields['company']['company_facebook'] = array(
			'label' => esc_html__('Facebook url', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => esc_html__('http://facebook.com/yourusername', 'findgo'),
			'priority' => 7,
			'section'    => 'section-7'
		);
		$fields['company']['company_linkedin'] = array(
			'label' => esc_html__('Linkedin url', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => esc_html__('http://linkedin.com/yourusername', 'findgo'),
			'priority' => 7.1,
			'section'    => 'section-7'
		);
		$fields['company']['company_instagram'] = array(
			'label' => esc_html__('Instagram url', 'findgo'),
			'type' => 'text',
			'required' => false,
			'placeholder' => esc_html__('http://instagram.com/yourusername', 'findgo'),
			'priority' => 7.2,
			'section'    => 'section-7'
		);

		// temporary unsets
		//unset( $fields['company']['company_tagline'] );
		unset( $fields['job']['job_type'] );
		unset( $fields['company']['company_name'] );
		unset( $fields['job']['application'] );
		
		return $fields;
	}

	public static function replace_jobs_with_listings( &$item, $key ) {

		if ( $item === 'Job Listings' ) {
			$item = esc_html__( 'Listing', 'findgo' );
		}

		if ( $item === 'Job Submission' ) {
			$item = esc_html__( 'Submission', 'findgo' );
		}

		if ( $key === 'desc' || $key === 'any' || $key === 'all' || $key === 'label' ) {
			if ( is_numeric( strpos( $item, 'Job' ) ) ) {
				$item = str_replace( 'Job', esc_html__( 'Listing', 'findgo' ), $item );
			}
		}

		return $item;
	}

	public static function clean_gallery_images_on_submit( $job_data, $post_title, $post_content, $status, $values ) {
		if ( empty( $values['gallery_images'] ) ) {
			$listing = get_page_by_title( $post_title, null, 'job_listing' );
			if ( ! is_wp_error( $listing ) && isset( $listing->ID ) ) {
				$meta_key = APUSFINDGO_PREFIX.'gallery_images';
				update_post_meta( $listing->ID, $meta_key, '' );
			}
		}
		return $job_data;
	}
	

	public static function listing_submit( $id, $values ) {

		$company_logo = $values['company']['gallery_images'];

		// turn company logo in featured image
		if ( isset( $company_logo ) && ! empty( $company_logo ) ) {

			$gallery_images = array();

			// we may have a simple string(on image upload) or an array of images, so we need to treat them all
			if ( is_numeric( $company_logo ) ) {
				$attach_id = self::get_attachment_id_from_url( $company_logo );
				if ( ! empty( $attach_id ) && is_numeric( $attach_id ) ) {
					$gallery_images[$attach_id] = $company_logo;
				}
			} elseif ( is_array( $company_logo ) && ! empty( $company_logo ) ) {

				foreach ( $company_logo as $key => $url ) {
					$attach_id = self::get_attachment_id_from_url( $url );
					if ( ! empty( $attach_id ) && is_numeric( $attach_id ) ) {
						$gallery_images[$attach_id] = $url;
					}
				}
			}

			// empty or not .. we're gonna update something
			$meta_key = APUSFINDGO_PREFIX.'gallery_images';
			update_post_meta( $id, $meta_key, $gallery_images );
		}
		self::listing_update_job_data($id, $values);
	}

	public static function listing_update_job_data( $id, $values ) {

		if ( isset( $_POST[ 'job_hours' ] ) ) {
			update_post_meta( $id, '_job_hours', stripslashes_deep( $_POST[ 'job_hours' ] ) );
		}

		if ( isset( $_POST[ 'geo_latitude' ] ) ) {
			update_post_meta( $id, 'geolocation_lat', stripslashes_deep( $_POST[ 'geo_latitude' ] ) );
		}
		if ( isset( $_POST[ 'geo_longitude' ] ) ) {
			update_post_meta( $id, 'geolocation_long', stripslashes_deep( $_POST[ 'geo_longitude' ] ) );
		}

		if ( isset( $_POST[ '_job_menu_prices_title' ] ) ) {
			update_post_meta( $id, '_job_menu_prices_title', $_POST[ '_job_menu_prices_title' ] );
		}
		if ( isset( $_POST[ '_job_menu_prices_price' ] ) ) {
			update_post_meta( $id, '_job_menu_prices_price', $_POST[ '_job_menu_prices_price' ] );
		}
		if ( isset( $_POST[ '_job_menu_prices_description' ] ) ) {
			update_post_meta( $id, '_job_menu_prices_description', $_POST[ '_job_menu_prices_description' ] );
		}

		if ( isset( $_POST[ '_job_menu_prices' ] ) ) {
			update_post_meta( $id, '_job_menu_prices_data', $_POST[ '_job_menu_prices' ] );
		}
	}

	public static function get_attachment_id_from_url( $attachment_url = '' ) {

		global $wpdb;
		$attachment_id = false;

		// If there is no url, bail.
		if ( '' == $attachment_url ) {
			return false;
		}

		// Get the upload directory paths
		$upload_dir_paths = wp_upload_dir();

		// Make sure the upload path base directory exists in the attachment URL, to verify that we're working with a media library image
		if ( false !== strpos( $attachment_url, $upload_dir_paths['baseurl'] ) ) {

			// If this is the URL of an auto-generated thumbnail, get the URL of the original image
			$attachment_url = preg_replace( '/-\d+x\d+(?=\.(jpg|jpeg|png|gif)$)/i', '', $attachment_url );

			// Remove the upload path base directory from the attachment URL
			$attachment_url = str_replace( $upload_dir_paths['baseurl'] . '/', '', $attachment_url );

			// Finally, run a custom database query to get the attachment ID from the modified attachment URL
			$attachment_id = $wpdb->get_var( $wpdb->prepare( "SELECT wposts.ID FROM $wpdb->posts wposts, $wpdb->postmeta wpostmeta WHERE wposts.ID = wpostmeta.post_id AND wpostmeta.meta_key = '_wp_attached_file' AND wpostmeta.meta_value = '%s' AND wposts.post_type = 'attachment'", $attachment_url ) );

		}

		return $attachment_id;
	}

	public static function job_listing_admin_columns( $columns ) {
		if ( ! is_array( $columns ) ) {
			$columns = array();
		}
		unset ( $columns["job_listing_type"] );
		
		return $columns;
	}

	public static function get_job_data( $fields, $job ) {
		$hours = get_post_meta( $job->ID, '_job_hours', true );

		if ( $hours ) {
			$fields[ 'job' ][ 'job_hours' ][ 'value' ] = $hours;
		}

		$gallery_images = get_post_meta( $job->ID, APUSFINDGO_PREFIX.'gallery_images', true );

		if ( $gallery_images ) {
			$fields[ 'company' ][ 'gallery_images' ][ 'value' ] = $gallery_images;
		}
		
		return $fields;
	}

	

	public static function input_hours_fields() {
		global $wp_locale, $post, $thepostid;

		$thepostid = $post->ID;
		?>

		<div class="form-field">

			<?php if ( ! is_admin() ) : ?>
			<label for="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $field['label'] ) ; ?>:</label>
			<?php endif; ?>

			<?php
			global $field;
			if ( empty( $field[ 'value' ] ) ) {
				$field[ 'value' ] = get_post_meta( $thepostid, '_job_hours', true );
			}
			get_job_manager_template( 'form-fields/findgo-hours-field.php' );
			?>
		</div>

		<?php
	}

	public static function input_radio_images_fields($key, $field) {
		global $wp_locale, $post, $thepostid;
		
		$thepostid = $post->ID;
		?>

		<div class="form-field filed-images-layout">

			<label for="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $field['label'] ) ; ?>:</label>
			

			<?php
			if ( empty( $field[ 'value' ] ) ) {
				$field[ 'value' ] = get_post_meta( $thepostid, '_job_layout_type', true );
			}
			get_job_manager_template( 'form-fields/findgo-images-field.php', array('key' => $key, 'field' => $field) );
			?>

		</div>

		<?php
	}

	public static function input_location_fields($key, $field) {
		global $wp_locale, $post, $thepostid;
		
		$thepostid = $post->ID;
		?>

		<div class="form-field location-form-field">
			
			<label for="<?php echo esc_attr( $key ); ?>"><?php echo esc_html( $field['label'] ) ; ?>:</label>
			
			<?php
			if ( empty( $field[ 'value' ] ) ) {
				$field[ 'value' ] = get_post_meta( $thepostid, '_job_location', true );
			}
			get_job_manager_template( 'form-fields/findgo-location-field.php', array('key' => $key, 'field' => $field) );
			?>
		</div>

		<?php
	}

	public static function input_menu_prices_fields($key, $field) {
		global $wp_locale, $post, $thepostid;
		
		$thepostid = $post->ID;
		?>

		<div class="form-field location-form-field">
			<?php

			if ( empty( $field[ 'value' ] ) ) {
				$field[ 'value' ] = get_post_meta( $thepostid, '_job_menu_prices', true );
			}

			get_job_manager_template( 'form-fields/findgo-menu-prices-field.php', array('key' => $key, 'field' => $field) );
			?>
		</div>

		<?php
	}

	public static function addMetaBoxes() {
		add_meta_box( 'apusfindgo_hours', esc_html__( 'Hours of Operation', 'findgo' ), array( __CLASS__, 'admin_hours' ), 'job_listing', 'side', 'low');
	}

	public static function admin_hours() {
		do_action( 'job_manager_input_findgo_hours', '_job_hours', array(
			'label' => esc_html__( 'Hours of Operation', 'findgo' ),
			'type' => 'findgo_hours',
			'placeholder' => '',
			'priority' => 99
		) );
	}

	public static function generate_sections($fields) {
		$all_sections = array();
		$empty_section = array();
		if ( !empty($fields) ) {
			foreach ($fields as $key => $field) {
				if ( !empty($field['section']) ) {
					$all_sections[$field['section']][$key] = $field;
				} else {
					$empty_section[$key] = $field;
				}
			}
		}
		if ( !empty($empty_section) ) {
			$all_sections['section-empty'] = $empty_section;
		}
		return apply_filters( 'findgo_generate_sections', $all_sections, $fields );
	}

	public static function section_labels() {
		return apply_filters( 'findgo_section_labels', array(
			'section-1' => esc_html__( 'Listing Style', 'findgo' ),
			'section-3' => esc_html__( 'Description	& Hours', 'findgo' ),
			'section-6' => esc_html__( 'Media', 'findgo' ),
			'section-7' => esc_html__( 'Social', 'findgo' ),
		) );
	}

	public static function slug_only_title($return) {
		return false;
	}

}

Findgo_Post_Type_Job_Listing::init();