<?php
 
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
 
class Findgo_Products {

	public static function init() {

        add_filter( 'findgo_redux_config_sections_after_listing', array( __CLASS__, 'settings' ), 10 );
        
        if ( !findgo_get_config('listing_products_enable', true) ) {
            return;
        }

        add_filter( 'findgo_listing_single_sort_content', array( __CLASS__, 'content_fields' ) );
        add_filter( 'findgo_listing_single_sort_sidebar', array( __CLASS__, 'sidebar_fields' ) );
        add_filter( 'findgo_listing_display_part', array( __CLASS__, 'display' ), 10, 2 );

        // Add products field to submit form
        add_filter( 'submit_job_form_fields', array( __CLASS__, 'submit_job_form_fields' ) );

        // Save products from submit form
        add_action( 'job_manager_update_job_data', array( __CLASS__, 'update_job_data_products' ), 10, 2 );

        // Add products field to backend
        add_filter( 'job_manager_job_listing_data_fields', array( __CLASS__, 'add_listing_data_fields_product' ) );

        // Save products from backend
        add_action( 'job_manager_save_job_listing', array( __CLASS__, 'save_job_listing_data' ), 25, 2 );

	}

    public static function settings($sections) {
        $sections[] = array(
            'title' => esc_html__('Listing Products', 'findgo'),
            'fields' => array(
                array(
                    'id' => 'listing_products_enable',
                    'type' => 'switch',
                    'title' => esc_html__('Enbale Listing Products', 'findgo'),
                    'default' => 1
                ),
                array(
                    'id'          => 'listing_products_select_products_text',
                    'type'          => 'text',
                    'title'         => esc_html__( 'Select Products Text', 'findgo' ),
                    'description' => '<em>'.esc_html__( 'Default: "Select Your Services & Products"', 'findgo' ).'</em>',
                    'default' => 'Select Your Services & Products',
                ),
                array(
                    'id' => 'listing_products_font_end',
                    'type' => 'switch',
                    'title' => esc_html__('enable filed in submit form', 'findgo'),
                    'default' => true,
                ),
                array(
                    'id' => 'listing_products_limit',
                    'type' => 'select',
                    'title' => esc_html__( 'Products limitation', 'findgo' ),
                    'description' => esc_html__( 'What products can listing owners select? <small>Admins will see all products</small>', 'findgo' ),
                    'options'       => array(
                        'own' => esc_html__( 'Only their own', 'findgo' ),
                        'all' => esc_html__( 'All', 'findgo' ),
                    ),
                    'default' => 'own'
                ),
                array (
                    'id' => 'listing_products_display_setting',
                    'icon' => true,
                    'type' => 'info',
                    'raw' => '<h3> '.esc_html__('Display Settings', 'findgo').'</h3>',
                ),
                array(
                    'id' => 'listing_products_title',
                    'type' => 'text',
                    'title' => esc_html__('Listing Products Title (Main Content)', 'findgo'),
                    'default' => esc_html__('Listings Products', 'findgo')
                ),
                array(
                    'id' => 'listing_sidebar_products_title',
                    'type' => 'text',
                    'title' => esc_html__('Sidebar Listing Products Title (Sidebar)', 'findgo'),
                    'default' => esc_html__('Booking Now', 'findgo')
                ),
            )
        );

        return $sections;
    }
    
    public static function content_fields($fields) {
        $fields['products'] = esc_html__( 'Listing Products', 'findgo' );
        return $fields;
    }

    public static function sidebar_fields($fields) {
        $fields['products-sidebar'] = esc_html__( 'Listing Products', 'findgo' );
        return $fields;
    }

    public static function display($content, $template) {
        if ( $template == 'products' ) {
            ob_start();
            get_template_part( 'job_manager/single/parts/'.$template );
            $content = ob_get_clean();
        } elseif ( $template == 'products-sidebar' ) {
            ob_start();
            get_template_part( 'job_manager/single/parts/'.$template );
            $content = ob_get_clean();
        }
        return $content;
    }

    public static function submit_job_form_fields($fields) {
        if ( ! findgo_get_config('listing_products_font_end', true) ) {
            return $fields;
        }

        global $current_user;

        $options        = array();
        $args   = array(
            'post_type'         => 'product',
            'posts_per_page'    => '-1',
            'tax_query' => array(
                'relation' => 'AND',
                array(
                    'taxonomy' => 'product_visibility',
                    'field'    => 'slug',
                    'terms'    => array( 'exclude-from-search', 'exclude-from-catalog' ),
                    'operator' => 'NOT IN',
                ),
                array(
                    'taxonomy' => 'product_type',
                    'field' => 'slug',
                    'terms' => array( 'job_package', 'job_package_subscription', 'resume_package', 'resume_package_subscription' ),
                    'operator' => 'NOT IN'
                ),
            ),
            'meta_query' => array(
                'relation' => 'OR',
                array(
                   'key' => '_ywsbs_subscription',
                   'value' => 'yes',
                   'compare' => '!=',
                ),
                array( //if no date has been added show these posts too
                    'key' => '_ywsbs_subscription',
                    'value' => 'yes',
                    'compare' => 'NOT EXISTS'
                )
            )
        );

        if ( 'own' == findgo_get_config( 'listing_products_limit', 'own' ) && ! array_key_exists( 'administrator', $current_user->caps ) ) {
            // Don't show this field when user is not logged in
            if ( ! is_user_logged_in() ) :
                return $fields;
            endif;

            $args['author'] = get_current_user_id();
        }

        $products = get_posts( apply_filters( 'apusfindgos_products_form_args', $args ) );

        foreach ( $products as $p ) {
            $options[ $p->ID ] = $p->post_title;
        }

        if ( class_exists( 'WC_Product_Vendors_Utils' ) ) {
            $vproducts = WC_Product_Vendors_Utils::get_vendor_product_ids();

            foreach ( $vproducts as $p ) {
                $options[ $p ] = get_the_title( $p );
            }
        }

        if ( empty( $options ) ) :
            return $fields;
        endif;

        $fields['company']['products'] = array(
            'label'         => findgo_get_config('listing_products_select_products_text', 'Select Your Services & Products'),
            'type'          => 'multiselect',
            'options'       => $options,
            'required'      => false,
            'priority'      => 10,
            'placeholder' => findgo_get_config('listing_products_select_products_text', 'Select Your Services & Products'),
        );

        return $fields;
    }

    public static function update_job_data_products( $job_id, $values ) {

        $value = isset( $values['company']['products'] ) ? $values['company']['products'] : false;

        if ( $value ) {
            update_post_meta( $job_id, '_products', $value );
        }

    }

    public static function add_listing_data_fields_product( $fields ) {
        
        global $current_user;

        $args   = array(
            'post_type'         => 'product',
            'posts_per_page'    => -1,
            'meta_query' => array(
                'relation' => 'OR',
                array(
                   'key' => '_ywsbs_subscription',
                   'value' => 'yes',
                   'compare' => '!=',
                ),
                array( //if no date has been added show these posts too
                    'key' => '_ywsbs_subscription',
                    'value' => 'yes',
                    'compare' => 'NOT EXISTS'
                )
            )
        );
        if ( 'own' == findgo_get_config( 'listing_products_limit', 'own' ) && ! array_key_exists( 'administrator', $current_user->caps ) ) {
            $args['author'] = get_current_user_id();
        }

        $products = get_posts( apply_filters( 'apusfindgos_admin_job_form_products_args', $args ) );

        foreach ( $products as $p ) {
            $options[ $p->ID ] = $p->post_title;
        }

        if ( class_exists( 'WC_Product_Vendors_Utils' ) ) {
            $vproducts = WC_Product_Vendors_Utils::get_vendor_product_ids();

            foreach ( $vproducts as $p ) {
                $options[ $p ] = get_the_title( $p );
            }
        }

        if ( empty( $options ) ) {
            return $fields;
        }

        $fields['_products'] = array(
            'label'         => findgo_get_config('listing_products_select_products_text', 'Select Your Services & Products'),
            'placeholder'   => '',
            'type'          => 'multiselect',
            'options'       => $options,
            'priority' => 15
        );

        return $fields;

    }

    public static function save_job_listing_data( $post_id, $post ) {

        if ( ! isset( $_POST['_products'] ) ) {
            update_post_meta( $post_id, '_products', '' );
        }

    }

}

Findgo_Products::init();