<?php

if ( ! function_exists( 'findgo_get_term_icon_url' ) ) {
	function findgo_get_term_icon_url( $term_id = null ) {
		if ( class_exists('Taxonomy_MetaData_CMB2') ) {
			return Taxonomy_MetaData_CMB2::get( 'job_listing_category', $term_id, 'icon' );
		}
		return '';
	}
}

if ( ! function_exists( 'findgo_get_post_image_src' ) ) {
	function findgo_get_post_image_src( $post_id = null, $size = 'thumbnail' ) {
		if ( empty( $post_id ) ) {
			$post_id = get_the_ID();
		}

		if ( has_post_thumbnail( $post_id ) ) {
			$attach_id = esc_sql( get_post_thumbnail_id( $post_id ) );
			$data = wp_get_attachment_image_src( $attach_id, $size );
			if ( isset( $data[0] ) && ! empty ( $data ) ) {
				return $data[0];
			}
		}
		$gallery_ids = findgo_get_listing_gallery( $post_id );
		if (!empty($gallery_ids) && isset($gallery_ids[0]) && $gallery_ids[0]) {
			return $gallery_ids[0];
		}

		return false;
	}
}

if ( ! function_exists( 'findgo_display_listing_image' ) ) {
	function findgo_display_listing_image( $size = 'thumbnail', $link = true, $post = null ) {
		if ( empty($post) ) {
			global $post;
		}
		$post_id = $post->ID;

		if ( has_post_thumbnail( $post_id ) ) {
			$attach_id = esc_sql( get_post_thumbnail_id( $post_id ) );
			$data = wp_get_attachment_image_src( $attach_id, $size );
			if ( isset( $data[0] ) && ! empty ( $data ) ) {
				$img = $data;
			}
		} else {
			$gallery_ids = findgo_get_listing_gallery( $post_id );
			if (!empty($gallery_ids) && isset($gallery_ids[0]) && $gallery_ids[0]) {
				$img = $gallery_ids;
			}
		}
		if (isset($img) && !empty($img)) {
			$img_src = $img[0];

			if (findgo_get_config('image_lazy_loading', true)) {
				$placeholder_image = findgo_create_placeholder(array($img[1],$img[2]));
				?>
				<div class="image-wrapper">
					<?php if ($link) { ?>
						<a href="<?php the_job_permalink($post); ?>">
					<?php } ?>
							<img src="<?php echo trim($placeholder_image); ?>" data-src="<?php echo esc_url_raw($img_src); ?>" alt="<?php echo esc_attr( get_the_company_name( $post ) ); ?>" class="unveil-image">
					<?php if ($link) { ?>
						</a>
					<?php } ?>
				</div>
				<?php
			} else {
				?>
				<div class="image-wrapper">
					<?php if ($link) { ?>
						<a href="<?php the_job_permalink($post); ?>">
					<?php } ?>
							<img src="<?php echo esc_url($img_src); ?>" alt="<?php echo esc_attr( get_the_company_name( $post ) ); ?>">
					<?php if ($link) { ?>
						</a>
					<?php } ?>
				</div>
				<?php
			}
		}
	}
}

if ( ! function_exists( 'findgo_get_listing_gallery' ) ) {
	function findgo_get_listing_gallery( $post_id ) {
		$ids = array();
		if ( has_post_thumbnail($post_id) ) {
			$ids[get_post_thumbnail_id($post_id)] = get_post_thumbnail_id($post_id);
		}
		if ( defined('APUSFINDGO_PREFIX') ) {
			$return  =  get_post_meta( $post_id, APUSFINDGO_PREFIX . 'gallery_images', true );
			if ( !empty($return) ) {
				$ids = $ids + $return;
			}
		}
		return $ids;
	}
}

function findgo_sort_array_by_priority( $a, $b ) {
	if ( $a['priority'] == $b['priority'] ) {
		return 0;
	}

	return ( $a['priority'] < $b['priority'] ) ? - 1 : 1;
}

function findgo_get_current_time() {
	global $wp_locale;
	$timezone  = get_option('gmt_offset');
	$time = gmdate(get_option('time_format'), time() + 3600*($timezone+date("I"))); 
	
	$time = strtotime($time);
	$day_of_week = date('N',$time);
	if ( $day_of_week == 7 ) {
		$day_of_week = 0;
	}
	$day = $wp_locale->get_weekday( $day_of_week );
	
	$day = ucfirst($day);
	return array( 'day' => $day, 'time' => $time );
}

function findgo_get_current_time_status($listing_id) {
	$current = findgo_get_current_time();
	$current_day = strtolower($current['day']);
	$current_time = $current['time'];
	$hours = get_post_meta( $listing_id, '_job_hours', true );
	$days = findgo_get_day_hours($hours);

	if ( !empty($days[$current_day]) ) {
		$times = $days[$current_day];
		if ( is_array($times) && count($times) == 2 ) {
			$opentime = strtotime($times[0]);	
			$closedtime = strtotime($times[1]);
			if ( $closedtime >= $opentime ) {
				if ( $current_time >= $opentime && $current_time <= $closedtime ) {
					return true;
				}
			} else {
				if ( $current_time >= $opentime || $current_time <= $closedtime ) {
					return true;
				}
			}
		}
	} else {
		return true;
	}
	return false;
}

function findgo_display_time_status($listing_id = null) {
	if ( empty($listing_id) ) {
		$listing_id = get_the_ID();
	}
	$status = findgo_get_current_time_status( $listing_id );
	if ( $status ) { ?>
		<div class="listing-time opening">
			<?php esc_html_e( 'Open', 'findgo' ); ?>
		</div>
	<?php } else { ?>
		<div class="listing-time closed">
			<?php esc_html_e( 'Closed', 'findgo' ); ?>
		</div>
	<?php }
}

function findgo_display_city_country($listing_id = null) {
	if ( empty($listing_id) ) {
		$listing_id = get_the_ID();
	}
	$terms = get_the_terms( $listing_id, 'job_listing_region' );

	$firstTermHTML  = '';
	if ( ! is_wp_error( $terms ) && ( is_array( $terms ) || is_object( $terms ) ) ) {
		$firstTerm = $terms[0];
		if ( ! $firstTerm == null ) {
			$term_id = $firstTerm->term_id;
			$firstTermHTML .= '<a href="'.get_term_link($firstTerm).'">'.$firstTerm->name.'</a>';
		}
	}

	if ( !empty($firstTermHTML) ) { ?>
		<div class="listing-location">
			<i class="flaticon-placeholder"></i><?php echo trim($firstTermHTML); ?>
		</div>
	<?php }
}

function findgo_display_price_range($listing_id = null) {
	if ( empty($listing_id) ) {
		$listing_id = get_the_ID();
	}
	$price_from = get_post_meta($listing_id, '_company_price_from', true);
	$price_to = get_post_meta($listing_id, '_company_price_to', true);
	if ( $price_from || $price_to ) {
		?>
		<span class="price-range">
			<?php echo esc_html($price_from); ?>
			<?php if ( $price_to ) { ?>
				- <?php echo esc_html($price_to); ?>
			<?php } ?>
		</span>
		<?php
	}
}

function findgo_check_menu_prices_empty($section) {
	$titles_value = !empty($section['title']) ? $section['title'] : array();
	$items_prices = !empty($section['price']) ?  $section['price'] : array();
	$items_descriptions = !empty($section['description']) ? $section['description'] : array();
	if ( !empty($titles_value) && count($titles_value) > 0 ) {
		foreach ($titles_value as $key => $value) {
			if ( !empty($value) || !empty($items_prices[$key]) || !empty($items_descriptions[$key])  ) {
				return true;
			}
		}
	}
	return false;
}

function findgo_display_menu_prices($items_data) {
	$html = '';
	if ( !empty($items_data) && is_array($items_data) ) {
		foreach ($items_data as $section) {

			$section_title = !empty($section['section_title']) ? $section['section_title'] : '';
			$titles_value = !empty($section['title']) ? $section['title'] : array();
			$items_prices = !empty($section['price']) ?  $section['price'] : array();
			$items_descriptions = !empty($section['description']) ? $section['description'] : array();
			
			if ( findgo_check_menu_prices_empty($section) ) {
				$html .= '<div class="col-xs-12 col-sm-6">
						<div class="menu-prices-wrapper">';
				if ( !empty($section_title) ) {
					$html .= '<h3 class="title-price">'.esc_html($section_title).'</h3>';
				}
				$html .= '<ul class="listing-menu-prices-list">';
				foreach ($titles_value as $key => $title_value) {
					$price_value = !empty($items_prices[$key]) ? $items_prices[$key] : '';
					$description_value = !empty($items_descriptions[$key]) ? $items_descriptions[$key] : '';
				
					$html .= '<li>
							<h5>'.esc_html($title_value).'<span class="price">'.esc_html($price_value).'</span></h5>
							<div class="description">
								'.esc_html($description_value).'
							</div>
						</li>';
				}
				$html .= '</ul>
						</div>
					</div>';
			}
		}
	}
	return $html;
}


function findgo_create_attachment( $attachment_url, $post_id = 0 ) {
	include_once ABSPATH . 'wp-admin/includes/image.php';
	include_once ABSPATH . 'wp-admin/includes/media.php';

	$upload_dir     = wp_upload_dir();
	$attachment_url = esc_url( $attachment_url, array( 'http', 'https' ) );
	if ( empty( $attachment_url ) ) {
		return 0;
	}

	$attachment_url = str_replace( array( $upload_dir['baseurl'], WP_CONTENT_URL, site_url( '/' ) ), array( $upload_dir['basedir'], WP_CONTENT_DIR, ABSPATH ), $attachment_url );
	if ( empty( $attachment_url ) || ! is_string( $attachment_url ) ) {
		return 0;
	}

	$attachment = array(
		'post_title'   => esc_html__('Attachment Image', 'findgo'),
		'post_content' => '',
		'post_status'  => 'inherit',
		'post_parent'  => $post_id,
		'guid'         => $attachment_url,
	);

	$info = wp_check_filetype( $attachment_url );
	if ( $info ) {
		$attachment['post_mime_type'] = $info['type'];
	}

	$attachment_id = wp_insert_attachment( $attachment, $attachment_url, $post_id );

	if ( ! is_wp_error( $attachment_id ) ) {
		wp_update_attachment_metadata( $attachment_id, wp_generate_attachment_metadata( $attachment_id, $attachment_url ) );
		return $attachment_id;
	}

	return 0;
}