<?php

if ( !function_exists('findgo_load_load_theme_element')) {
	function findgo_load_load_theme_element() {
		$columns = array(1,2,3,4,6);
		// Heading Text Block
		vc_map( array(
			'name'        => esc_html__( 'Apus Widget Heading','findgo'),
			'base'        => 'apus_title_heading',
			"class"       => "",
			"category" => esc_html__('Apus Elements', 'findgo'),
			'description' => esc_html__( 'Create title for one Widget', 'findgo' ),
			"params"      => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Widget title', 'findgo' ),
					'param_name' => 'title',
					'value'       => esc_html__( 'Title', 'findgo' ),
					'description' => esc_html__( 'Enter heading title.', 'findgo' ),
					"admin_label" => true
				),
				array(
					"type" => "textarea",
					'heading' => esc_html__( 'Description', 'findgo' ),
					"param_name" => "descript",
					"value" => '',
					'description' => esc_html__( 'Enter description for title.', 'findgo' )
			    ),
			    array(
					"type" => "dropdown",
					"heading" => esc_html__("Style", 'findgo'),
					"param_name" => "style",
					'value' 	=> array(
						esc_html__('Default ', 'findgo') => '', 
						esc_html__('Center ', 'findgo') => 'center', 
						esc_html__('Center White', 'findgo') => 'center_white', 
						esc_html__('Center White Small', 'findgo') => 'center st_white', 
					),
					'std' => ''
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'findgo' ),
					'param_name' => 'el_class',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'findgo' )
				)

			),
		));
		// calltoaction
		vc_map( array(
			'name'        => esc_html__( 'Apus Widget Call To Action','findgo'),
			'base'        => 'apus_call_action',
			"class"       => "",
			"category" => esc_html__('Apus Elements', 'findgo'),
			'description' => esc_html__( 'Create title for one Widget', 'findgo' ),
			"params"      => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Widget title', 'findgo' ),
					'param_name' => 'title',
					'value'       => esc_html__( 'Title', 'findgo' ),
					'description' => esc_html__( 'Enter heading title.', 'findgo' ),
					"admin_label" => true
				),
				array(
					"type" => "textarea",
					'heading' => esc_html__( 'Description', 'findgo' ),
					"param_name" => "descript",
					"value" => '',
					'description' => esc_html__( 'Enter description for title.', 'findgo' )
			    ),

			    array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Text Button', 'findgo' ),
					'param_name' => 'textbutton',
					'description' => esc_html__( 'Text Button', 'findgo' ),
					"admin_label" => true
				),

				array(
					'type' => 'textfield',
					'heading' => esc_html__( ' Link Button', 'findgo' ),
					'param_name' => 'linkbutton',
					'description' => esc_html__( 'Link Button', 'findgo' ),
					"admin_label" => true
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Button Style", 'findgo'),
					"param_name" => "buttons",
					'value' 	=> array(
						esc_html__('Default ', 'findgo') => 'btn-default ', 
						esc_html__('Primary ', 'findgo') => 'btn-primary ', 
						esc_html__('Success ', 'findgo') => 'btn-success ', 
						esc_html__('Info ', 'findgo') => 'btn-info ', 
						esc_html__('Warning ', 'findgo') => 'btn-warning ', 
						esc_html__('Danger ', 'findgo') => 'btn-danger ', 
						esc_html__('Pink ', 'findgo') => 'btn-pink ', 
						esc_html__('White ', 'findgo') => 'btn-white ', 
					),
					'std' => ''
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'findgo' ),
					'param_name' => 'el_class',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'findgo' )
				)

			),
		));

		// Apus Counter
		vc_map( array(
		    "name" => esc_html__("Apus Counter",'findgo'),
		    "base" => "apus_counter",
		    "class" => "",
		    "description"=> esc_html__('Counting number with your term', 'findgo'),
		    "category" => esc_html__('Apus Elements', 'findgo'),
		    "params" => array(
		    	array(
					'type' => 'param_group',
					'heading' => esc_html__('Members Settings', 'findgo' ),
					'param_name' => 'items',
					'description' => '',
					'value' => '',
					'params' => array(
				    	array(
							"type" => "textfield",
							"heading" => esc_html__("Title", 'findgo'),
							"param_name" => "title",
							"value" => '',
							"admin_label"	=> true
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__("Number", 'findgo'),
							"param_name" => "number",
							"value" => ''
						),
					 	array(
							"type" => "textfield",
							"heading" => esc_html__("FontAwsome Icon", 'findgo'),
							"param_name" => "icon",
							"value" => '',
							'description' => esc_html__( 'This support display icon from FontAwsome, Please click', 'findgo' )
											. '<a href="' . ( is_ssl()  ? 'https' : 'http') . '://fortawesome.github.io/Font-Awesome/" target="_blank">'
											. esc_html__( 'here to see the list', 'findgo' ) . '</a>'
						),
						array(
							"type" => "attach_image",
							"description" => esc_html__("If you upload an image, icon will not show.", 'findgo'),
							"param_name" => "image",
							"value" => '',
							'heading'	=> esc_html__('Image', 'findgo' )
						)
					)
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
		   	)
		));


		// Apus Counter
		vc_map( array(
		    "name" => esc_html__("Apus Brands",'findgo'),
		    "base" => "apus_brands",
		    "class" => "",
		    "description"=> esc_html__('Display brands on front end', 'findgo'),
		    "category" => esc_html__('Apus Elements', 'findgo'),
		    "params" => array(
		    	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Number", 'findgo'),
					"param_name" => "number",
					"value" => ''
				),
			 	array(
					"type" => "dropdown",
					"heading" => esc_html__("Layout Type", 'findgo'),
					"param_name" => "layout_type",
					'value' 	=> array(
						esc_html__('Carousel', 'findgo') => 'carousel', 
						esc_html__('Grid', 'findgo') => 'grid'
					),
					'std' => ''
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Effect", 'findgo'),
					"param_name" => "effect",
					'value' 	=> array(
						esc_html__('Default', 'findgo') => '', 
						esc_html__('Darken', 'findgo') => 'darken',
					),
					'std' => ''
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Columns','findgo'),
	                "param_name" => 'columns',
	                "value" => array(1,2,3,4,5,6),
	            ),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
		   	)
		));
		
		vc_map( array(
		    "name" => esc_html__("Apus Socials link",'findgo'),
		    "base" => "apus_socials_link",
		    "description"=> esc_html__('Show socials link', 'findgo'),
		    "category" => esc_html__('Apus Elements', 'findgo'),
		    "params" => array(
		    	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__("Description", 'findgo'),
					"param_name" => "description",
					"value" => '',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Facebook Page URL", 'findgo'),
					"param_name" => "facebook_url",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Twitter Page URL", 'findgo'),
					"param_name" => "twitter_url",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Linkedin Page URL", 'findgo'),
					"param_name" => "linkedin_url",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Pinterest Page URL", 'findgo'),
					"param_name" => "pinterest_url",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Instagram Page URL", 'findgo'),
					"param_name" => "instagram_url",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Google Plus Page URL", 'findgo'),
					"param_name" => "google-plus_url",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Youtube Page URL", 'findgo'),
					"param_name" => "youtube_url",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Align", 'findgo'),
					"param_name" => "align",
					'value' 	=> array(
						esc_html__('Inherit', 'findgo') => '', 
						esc_html__('left', 'findgo') => 'left',
						esc_html__('Right', 'findgo') => 'right',
						esc_html__('Center', 'findgo') => 'center',
						esc_html__('Center No Border', 'findgo') => 'center_border',
					),
					'std' => ''
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
		   	)
		));
		// newsletter
		vc_map( array(
		    "name" => esc_html__("Apus Newsletter",'findgo'),
		    "base" => "apus_newsletter",
		    "class" => "",
		    "description"=> esc_html__('Show newsletter form', 'findgo'),
		    "category" => esc_html__('Apus Elements', 'findgo'),
		    "params" => array(
		    	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "textarea",
					"heading" => esc_html__("Description", 'findgo'),
					"param_name" => "description",
					"value" => '',
				),
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Layout Type", 'findgo'),
					"param_name" => "style",
					'value' 	=> array(
						esc_html__('Default', 'findgo') => '', 
						esc_html__('Style Light', 'findgo') => 'light',
					),
					'std' => ''
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
		   	)
		));
		// google map
		vc_map( array(
		    "name" => esc_html__("Apus Google Map",'findgo'),
		    "base" => "apus_googlemap",
		    "description" => esc_html__('Diplay Google Map', 'findgo'),
		    "category" => esc_html__('Apus Elements', 'findgo'),
		    "params" => array(
		    	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"admin_label" => true,
					"value" => '',
				),
	            array(
	                'type' => 'googlemap',
	                'heading' => esc_html__( 'Location', 'findgo' ),
	                'param_name' => 'location',
	                'value' => ''
	            ),
	            array(
	                'type' => 'hidden',
	                'heading' => esc_html__( 'Latitude Longitude', 'findgo' ),
	                'param_name' => 'lat_lng',
	                'value' => '21.0173222,105.78405279999993'
	            ),
	            array(
					"type" => "textfield",
					"heading" => esc_html__("Map height", 'findgo'),
					"param_name" => "height",
					"value" => '',
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Map Zoom", 'findgo'),
					"param_name" => "zoom",
					"value" => '13',
				),
	            array(
	                'type' => 'dropdown',
	                'heading' => esc_html__( 'Map Type', 'findgo' ),
	                'param_name' => 'type',
	                'value' => array(
	                    esc_html__( 'roadmap', 'findgo' ) 		=> 'ROADMAP',
	                    esc_html__( 'hybrid', 'findgo' ) 	=> 'HYBRID',
	                    esc_html__( 'satellite', 'findgo' ) 	=> 'SATELLITE',
	                    esc_html__( 'terrain', 'findgo' ) 	=> 'TERRAIN',
	                )
	            ),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
		   	)
		));
		// Testimonial
		vc_map( array(
            "name" => esc_html__("Apus Testimonials",'findgo'),
            "base" => "apus_testimonials",
            'description'=> esc_html__('Display Testimonials In FrontEnd', 'findgo'),
            "class" => "",
            "category" => esc_html__('Apus Elements', 'findgo'),
            "params" => array(
              	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"admin_label" => true,
					"value" => '',
				),
              	array(
	              	"type" => "textfield",
	              	"heading" => esc_html__("Number", 'findgo'),
	              	"param_name" => "number",
	              	"value" => '4',
	            ),
	            array(
	                'type' => 'dropdown',
	                'heading' => esc_html__( 'Style', 'findgo' ),
	                'param_name' => 'style',
	                'value' => array(
	                    esc_html__( 'Default', 'findgo' ) 		=> '',
	                    esc_html__( 'Box', 'findgo' ) 	=> 'box',
	                )
	            ),
	            array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
            )
        ));
        // Our Team
		vc_map( array(
            "name" => esc_html__("Apus Our Team",'findgo'),
            "base" => "apus_ourteam",
            'description'=> esc_html__('Display Our Team In FrontEnd', 'findgo'),
            "class" => "",
            "category" => esc_html__('Apus Elements', 'findgo'),
            "params" => array(
              	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"admin_label" => true,
					"value" => '',
				),
				array(
					"type" => "attach_image",
					"description" => esc_html__("If you upload an image, icon will not show.", 'findgo'),
					"param_name" => "image_icon",
					"value" => '',
					'heading'	=> esc_html__('Title Icon', 'findgo' )
				),
              	array(
					'type' => 'param_group',
					'heading' => esc_html__('Members Settings', 'findgo' ),
					'param_name' => 'members',
					'description' => '',
					'value' => '',
					'params' => array(
						array(
			                "type" => "textfield",
			                "class" => "",
			                "heading" => esc_html__('Name','findgo'),
			                "param_name" => "name",
			            ),
			            array(
			                "type" => "textfield",
			                "class" => "",
			                "heading" => esc_html__('Job','findgo'),
			                "param_name" => "job",
			            ),
						array(
							"type" => "attach_image",
							"heading" => esc_html__("Image", 'findgo'),
							"param_name" => "image"
						),

			            array(
			                "type" => "textfield",
			                "class" => "",
			                "heading" => esc_html__('Facebook','findgo'),
			                "param_name" => "facebook",
			            ),

			            array(
			                "type" => "textfield",
			                "class" => "",
			                "heading" => esc_html__('Twitter Link','findgo'),
			                "param_name" => "twitter",
			            ),

			            array(
			                "type" => "textfield",
			                "class" => "",
			                "heading" => esc_html__('Google plus Link','findgo'),
			                "param_name" => "google",
			            ),

			            array(
			                "type" => "textfield",
			                "class" => "",
			                "heading" => esc_html__('Linkin Link','findgo'),
			                "param_name" => "linkin",
			            ),

					),
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Columns','findgo'),
	                "param_name" => 'columns',
	                "value" => $columns
	            ),
	            array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
            )
        ));


 		// Widget contact
		vc_map( array(
            "name" => esc_html__("Apus Contact",'findgo'),
            "base" => "apus_contact",
            'description'=> esc_html__('Display Contact In FrontEnd', 'findgo'),
            "class" => "",
            "category" => esc_html__('Apus Elements', 'findgo'),
            "params" => array(
              	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"admin_label" => true,
					"value" => '',
				),
              	array(
					'type' => 'param_group',
					'heading' => esc_html__('Items Settings', 'findgo' ),
					'param_name' => 'members',
					'description' => '',
					'value' => '',
					'params' => array(
						array(
							"type" => "attach_image",
							"description" => esc_html__("If you upload an image, icon will not show.", 'findgo'),
							"param_name" => "image",
							"value" => '',
							'heading'	=> esc_html__('Image', 'findgo' )
						),
						array(
							"type" => "textfield",
							"heading" => esc_html__("FontAwsome Icon", 'findgo'),
							"param_name" => "icon",
							"value" => '',
							'description' => esc_html__( 'This support display icon from FontAwsome, Please click', 'findgo' )
											. '<a href="' . ( is_ssl()  ? 'https' : 'http') . '://fontawesome.io/" target="_blank">'
											. esc_html__( 'here to see the list', 'findgo' ) . '</a>'
						),
						array(
			                "type" => "textfield",
			                "class" => "",
			                "heading" => esc_html__('Title','findgo'),
			                "param_name" => "title",
			            ),
			            array(
			                "type" => "textarea",
			                "class" => "",
			                "heading" => esc_html__('Description','findgo'),
			                "param_name" => "description",
			            ),
					),
				),
              	array(
	              	"type" => "textfield",
	              	"heading" => esc_html__("Number", 'findgo'),
	              	"param_name" => "number",
	              	"value" => '1',
	            ),
	           	array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Style','findgo'),
	                "param_name" => 'style',
	                'value' 	=> array(
						esc_html__('Default ', 'findgo') => 'default',
						esc_html__('Background White ', 'findgo') => 'default white', 
					),
					'std' => ''
	            ),
	            array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
            )
        ));

        // Gallery Images
		vc_map( array(
            "name" => esc_html__("Apus Gallery",'findgo'),
            "base" => "apus_gallery",
            'description'=> esc_html__('Display Gallery In FrontEnd', 'findgo'),
            "class" => "",
            "category" => esc_html__('Apus Elements', 'findgo'),
            "params" => array(
              	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"admin_label" => true,
					"value" => '',
				),
              	array(
					"type" => "attach_images",
					"heading" => esc_html__("Images", 'findgo'),
					"param_name" => "images"
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Columns','findgo'),
	                "param_name" => 'columns',
	                "value" => $columns
	            ),
	            array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
            )
        ));
        // Gallery Images
		vc_map( array(
            "name" => esc_html__("Apus Video",'findgo'),
            "base" => "apus_video",
            'description'=> esc_html__('Display Video In FrontEnd', 'findgo'),
            "class" => "",
            "category" => esc_html__('Apus Elements', 'findgo'),
            "params" => array(
              	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"admin_label" => true,
					"value" => '',
				),
				array(
					"type" => "textarea",
					'heading' => esc_html__( 'Description', 'findgo' ),
					"param_name" => "description",
					"value" => '',
					'description' => esc_html__( 'Enter description for title.', 'findgo' )
			    ),
			    array(
					"type" => "attach_image",
					"heading" => esc_html__("Background Image", 'findgo'),
					"param_name" => "image_bg"
				),
				array(
	                "type" => "textfield",
	                "heading" => esc_html__('Youtube Video Link','findgo'),
	                "param_name" => 'video_link'
	            ),
	            array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
            )
        ));
		
        // Features Box
		vc_map( array(
            "name" => esc_html__("Apus Features Box",'findgo'),
            "base" => "apus_features_box",
            'description'=> esc_html__('Display Features In FrontEnd', 'findgo'),
            "class" => "",
            "category" => esc_html__('Apus Elements', 'findgo'),
            "params" => array(
				array(
					'type' => 'param_group',
					'heading' => esc_html__('Members Settings', 'findgo' ),
					'param_name' => 'items',
					'description' => '',
					'value' => '',
					'params' => array(
						array(
							"type" => "textfield",
							"heading" => esc_html__("Title", 'findgo'),
							"param_name" => "title",
							"admin_label" => true,
							"value" => '',
						),
			            array(
			                "type" => "textarea",
			                "class" => "",
			                "heading" => esc_html__('Description','findgo'),
			                "param_name" => "description",
			            ),
						array(
							"type" => "textfield",
							"heading" => esc_html__("Font Icon", 'findgo'),
							"param_name" => "icon",
							"value" => '',
							'description' => esc_html__( 'This support display icon from FontAwsome, Please click', 'findgo' )
											. '<a href="' . ( is_ssl()  ? 'https' : 'http') . '://fontawesome.io/" target="_blank">'
											. esc_html__( 'here to see the list', 'findgo' ) . '</a>'
						),
						array(
							"type" => "attach_image",
							"description" => esc_html__("If you upload an image, icon will not show.", 'findgo'),
							"param_name" => "image",
							"value" => '',
							'heading'	=> esc_html__('Image', 'findgo' )
						),
						array(
							"type" => "attach_image",
							"description" => esc_html__("If you upload an image, Just in Case Style is Box Color", 'findgo'),
							"param_name" => "image_hover",
							"value" => '',
							'heading'	=> esc_html__('Image Hover For Box Color', 'findgo' ),
						),
					),
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Columns','findgo'),
	                "param_name" => 'columns',
	                "value" => array(1,2,3,4),
	            ),
	           	array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Style','findgo'),
	                "param_name" => 'style',
	                'value' 	=> array(
						esc_html__('Default ', 'findgo') => '',
						esc_html__('Box ', 'findgo') => 'box',
						esc_html__('Box Color', 'findgo') => 'box_color',
						esc_html__('Box White', 'findgo') => 'box_white',
					),
					'std' => ''
	            ),
	            array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
            )
        ));

		// Banner
		vc_map( array(
		    "name" => esc_html__("Apus Banner",'findgo'),
		    "base" => "apus_banner",
		    "class" => "",
		    "description"=> esc_html__('Show Text and Images', 'findgo'),
		    "category" => esc_html__('Apus Elements', 'findgo'),
		    "params" => array(
		    	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					"type" => "attach_image",
					"heading" => esc_html__("Image", 'findgo'),
					"param_name" => "image"
				),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Url", 'findgo'),
					"param_name" => "url",
					"admin_label"	=> true
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Style','findgo'),
	                "param_name" => 'style',
	                'value' 	=> array(
						esc_html__('Styel 1 ', 'findgo') => 'style1', 
						esc_html__('Styel 2 ', 'findgo') => 'style2',
					),
					'std' => ''
	            ),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
		   	)
		));
		
		$custom_menus = array();
		if ( is_admin() ) {
			$menus = get_terms( 'nav_menu', array( 'hide_empty' => false ) );
			if ( is_array( $menus ) && ! empty( $menus ) ) {
				foreach ( $menus as $single_menu ) {
					if ( is_object( $single_menu ) && isset( $single_menu->name, $single_menu->slug ) ) {
						$custom_menus[ $single_menu->name ] = $single_menu->slug;
					}
				}
			}
		}
		// Menu
		vc_map( array(
		    "name" => esc_html__("Apus Custom Menu",'findgo'),
		    "base" => "apus_custom_menu",
		    "class" => "",
		    "description"=> esc_html__('Show Custom Menu', 'findgo'),
		    "category" => esc_html__('Apus Elements', 'findgo'),
		    "params" => array(
		    	array(
					"type" => "textfield",
					"heading" => esc_html__("Title", 'findgo'),
					"param_name" => "title",
					"value" => '',
					"admin_label"	=> true
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Menu', 'findgo' ),
					'param_name' => 'nav_menu',
					'value' => $custom_menus,
					'description' => empty( $custom_menus ) ? esc_html__( 'Custom menus not found. Please visit Appearance > Menus page to create new menu.', 'findgo' ) : esc_html__( 'Select menu to display.', 'findgo' ),
					'admin_label' => true,
					'save_always' => true,
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Style','findgo'),
	                "param_name" => 'style',
	                'value' 	=> array(
						esc_html__('Left', 'findgo') => 'st_left', 
						esc_html__('Right White', 'findgo') => 'st_right',
						esc_html__('Center', 'findgo') => 'st_center',
						esc_html__('Line Center', 'findgo') => 'st_line',
						esc_html__('Line Center Circle', 'findgo') => 'st_line_circle',
					),
					'std' => ''
	            ),
				array(
					"type" => "textfield",
					"heading" => esc_html__("Extra class name", 'findgo'),
					"param_name" => "el_class",
					"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
				)
		   	)
		));

		vc_map( array(
	            "name" => esc_html__("Apus Instagram",'findgo'),
	            "base" => "apus_instagram",
	            'description'=> esc_html__('Display Instagram In FrontEnd', 'findgo'),
	            "class" => "",
	            "category" => esc_html__('Apus Elements', 'findgo'),
	            "params" => array(
	            	array(
						"type" => "textfield",
						"heading" => esc_html__("Title", 'findgo'),
						"param_name" => "title",
						"admin_label" => true,
						"value" => '',
					),
					array(
		              	"type" => "textfield",
		              	"heading" => esc_html__("Instagram Username", 'findgo'),
		              	"param_name" => "username",
		            ),
					array(
		              	"type" => "textfield",
		              	"heading" => esc_html__("Number", 'findgo'),
		              	"param_name" => "number",
		              	'value' => '1',
		            ),
	             	array(
		              	"type" => "textfield",
		              	"heading" => esc_html__("Number Columns", 'findgo'),
		              	"param_name" => "columns",
		              	'value' => '1',
		            ),
		           	array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Layout Type','findgo'),
		                "param_name" => 'layout_type',
		                'value' 	=> array(
							esc_html__('Grid', 'findgo') => 'grid', 
							esc_html__('Carousel', 'findgo') => 'carousel', 
						)
		            ),
		            array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Photo size','findgo'),
		                "param_name" => 'size',
		                'value' 	=> array(
							esc_html__('Thumbnail', 'findgo') => 'thumbnail', 
							esc_html__('Small', 'findgo') => 'small', 
							esc_html__('Large', 'findgo') => 'large', 
							esc_html__('Original', 'findgo') => 'original', 
						)
		            ),
		            array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Open links in','findgo'),
		                "param_name" => 'target',
		                'value' 	=> array(
							esc_html__('Current window (_self)', 'findgo') => '_self', 
							esc_html__('New window (_blank)', 'findgo') => '_blank',
						)
		            ),
		            array(
		                "type" => "dropdown",
		                "heading" => esc_html__('Style','findgo'),
		                "param_name" => 'style',
		                'value' 	=> array(
							esc_html__('Default', 'findgo') => '', 
							esc_html__('Center', 'findgo') => 'style_center', 
							esc_html__('Small', 'findgo') => 'style_small', 
							esc_html__('Large', 'findgo') => 'style_large', 
						)
		            ),
		            array(
						"type" => "textfield",
						"heading" => esc_html__("Extra class name", 'findgo'),
						"param_name" => "el_class",
						"description" => esc_html__("If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.", 'findgo')
					)
	            )
	        ));
	}
}
add_action( 'vc_after_set_mode', 'findgo_load_load_theme_element', 99 );

class WPBakeryShortCode_apus_title_heading extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_call_action extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_featurebanner extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_brands extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_socials_link extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_newsletter extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_banner extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_googlemap extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_testimonials extends WPBakeryShortCode {}

class WPBakeryShortCode_apus_counter extends WPBakeryShortCode {
	public function __construct( $settings ) {
		parent::__construct( $settings );
		$this->load_scripts();
	}

	public function load_scripts() {
		wp_register_script('findgo-counterup-js', get_template_directory_uri().'/js/jquery.counterup.min.js', array('jquery'), false, true);
	}
}
class WPBakeryShortCode_apus_contact extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_ourteam extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_gallery extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_video extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_features_box extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_custom_menu extends WPBakeryShortCode {}
class WPBakeryShortCode_apus_instagram extends WPBakeryShortCode {}