<?php

if ( function_exists('vc_map') && class_exists('WPBakeryShortCode') ) {

    function findgo_get_post_categories() {
        $return = array( esc_html__(' --- Choose a Category --- ', 'findgo') => '' );

        $args = array(
            'type' => 'post',
            'child_of' => 0,
            'orderby' => 'name',
            'order' => 'ASC',
            'hide_empty' => false,
            'hierarchical' => 1,
            'taxonomy' => 'category'
        );

        $categories = get_categories( $args );
        findgo_get_post_category_childs( $categories, 0, 0, $return );

        return $return;
    }

    function findgo_get_post_category_childs( $categories, $id_parent, $level, &$dropdown ) {
        foreach ( $categories as $key => $category ) {
            if ( $category->category_parent == $id_parent ) {
                $dropdown = array_merge( $dropdown, array( str_repeat( "- ", $level ) . $category->name => $category->slug ) );
                unset($categories[$key]);
                findgo_get_post_category_childs( $categories, $category->term_id, $level + 1, $dropdown );
            }
        }
	}

	function findgo_load_post2_element() {
		$layouts = array(
			esc_html__('Grid', 'findgo') => 'grid',
			esc_html__('List', 'findgo') => 'list',
			esc_html__('Carousel', 'findgo') => 'carousel',
		);
		$columns = array(1,2,3,4,6);
		$categories = array();
		if ( is_admin() ) {
			$categories = findgo_get_post_categories();
		}
		vc_map( array(
			'name' => esc_html__( 'Apus Grid Posts', 'findgo' ),
			'base' => 'apus_gridposts',
			'icon' => 'icon-wpb-news-12',
			"category" => esc_html__('Apus Post', 'findgo'),
			'description' => esc_html__( 'Create Post having blog styles', 'findgo' ),
			'params' => array(
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Title', 'findgo' ),
					'param_name' => 'title',
					'description' => esc_html__( 'Enter text which will be used as widget title. Leave blank if no title is needed.', 'findgo' ),
					"admin_label" => true
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Category','findgo'),
	                "param_name" => 'category',
	                "value" => $categories
	            ),
	            array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Order By','findgo'),
	                "param_name" => 'orderby',
	                "value" => array(
	                	esc_html__('Date', 'findgo') => 'date',
	                	esc_html__('ID', 'findgo') => 'ID',
	                	esc_html__('Author', 'findgo') => 'author',
	                	esc_html__('Title', 'findgo') => 'title',
	                	esc_html__('Modified', 'findgo') => 'modified',
	                	esc_html__('Parent', 'findgo') => 'parent',
	                	esc_html__('Comment count', 'findgo') => 'comment_count',
	                	esc_html__('Menu order', 'findgo') => 'menu_order',
	                	esc_html__('Random', 'findgo') => 'rand',
	                )
	            ),
	            array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Sort order','findgo'),
	                "param_name" => 'order',
	                "value" => array(
	                	esc_html__('Descending', 'findgo') => 'DESC',
	                	esc_html__('Ascending', 'findgo') => 'ASC',
	                )
	            ),
	            array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Limit', 'findgo' ),
					'param_name' => 'posts_per_page',
					'description' => esc_html__( 'Enter limit posts.', 'findgo' ),
					'std' => 4,
					"admin_label" => true
				),
				array(
					'type' => 'checkbox',
					'heading' => esc_html__( 'Show Pagination?', 'findgo' ),
					'param_name' => 'show_pagination',
					'description' => esc_html__( 'Enables to show paginations to next new page.', 'findgo' ),
					'value' => array( esc_html__( 'Yes, to show pagination', 'findgo' ) => 'yes' )
				),
				array(
	                "type" => "dropdown",
	                "heading" => esc_html__('Grid Columns','findgo'),
	                "param_name" => 'grid_columns',
	                "value" => $columns
	            ),
				array(
					"type" => "dropdown",
					"heading" => esc_html__("Layout Type", 'findgo'),
					"param_name" => "layout_type",
					"value" => $layouts
				),
				array(
					'type' => 'dropdown',
					'heading' => esc_html__( 'Items', 'findgo' ),
					'param_name' => 'item',
					'value' 	=> array(
						esc_html__('Grid 1', 'findgo') => '', 
						esc_html__('Grid 2', 'findgo') => 'grid-carousel2', 
						esc_html__('Grid 3', 'findgo') => 'grid-item-v3', 
					),
					'dependency' => array(
						'element' => 'layout_type',
						'value' => array('carousel'),
					),
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Thumbnail size', 'findgo' ),
					'param_name' => 'thumbsize',
					'description' => esc_html__( 'Enter thumbnail size. Example: thumbnail, medium, large, full or other sizes defined by current theme. Alternatively enter image size in pixels: 200x100 (Width x Height) . ', 'findgo' )
				),
				array(
					'type' => 'textfield',
					'heading' => esc_html__( 'Extra class name', 'findgo' ),
					'param_name' => 'el_class',
					'description' => esc_html__( 'If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'findgo' )
				)
			)
		) );
	}

	add_action( 'vc_after_set_mode', 'findgo_load_post2_element', 99 );

	class WPBakeryShortCode_apus_gridposts extends WPBakeryShortCode {}
}