<?php

if ( function_exists('apus_framework_add_param') ) {
	apus_framework_add_param();
}

function findgo_admin_init_scripts(){
	wp_enqueue_media();
	$key = get_option( 'job_manager_google_maps_api_key' );
	wp_enqueue_script('google-map-api', '//maps.googleapis.com/maps/api/js?sensor=false&libraries=places&key='.$key );
	wp_enqueue_script('jquery-geocomplete', get_template_directory_uri().'/js/admin/jquery.geocomplete.min.js');

	wp_enqueue_script('jquery-ui-datepicker');
	wp_enqueue_style('jquery-ui-css', get_template_directory_uri() . '/css/jquery-ui.css' );

	wp_register_script( 'findgo-admin-scripts', get_template_directory_uri() . '/js/admin/custom.js', array( 'jquery'  ), '20131022', true );
	wp_localize_script( 'findgo-admin-scripts', 'findgo_opts', array(
		'time_format' => str_replace( '\\', '\\\\', get_option( 'time_format' ) ),
		'closed_text' => esc_html__( 'Closed', 'findgo' )
	));
	wp_enqueue_script( 'findgo-admin-scripts' );

	wp_enqueue_style('findgo-admin',  get_template_directory_uri() . '/css/admin.css');
}
add_action( 'admin_enqueue_scripts', 'findgo_admin_init_scripts' );

function findgo_map_init_scripts() {
	$key = get_option( 'job_manager_google_maps_api_key' );
	wp_enqueue_script('google-map-api', 'https://maps.googleapis.com/maps/api/js?sensor=false&libraries=places&key='.$key );
	wp_enqueue_script('gmap3', get_template_directory_uri().'/js/gmap3.js', array( 'jquery'  ), '20131022', true );
}
add_action('wp_enqueue_scripts', 'findgo_map_init_scripts');
