<?php

if ( ! function_exists( 'findgo_body_classes' ) ) {
	function findgo_body_classes( $classes ) {
		global $post;
		if ( is_page() && is_object($post) ) {
			$class = get_post_meta( $post->ID, 'apus_page_extra_class', true );
			if ( !empty($class) ) {
				$classes[] = trim($class);
			}
			if ( $post->ID == get_option('job_manager_jobs_page_id') ) {
				$version = findgo_get_listing_archive_version();
				$halfmaps = findgo_get_listing_all_half_map_version();
				if ( in_array($version, $halfmaps) ) {
					$classes[] = ' no-footer ';
				}
			} else {
				$transparent = get_post_meta( $post->ID, 'apus_page_header_transparent', true );
				if ( $transparent == 'yes' ) {
					$classes[] = 'header_transparent';
				}
			}
			// when page has image
			$bgimage = get_post_meta( $post->ID, 'apus_page_breadcrumb_image', true );
			if ( $bgimage ) { 
				$classes[] = 'header_transparent';
			}
		}
		if( is_singular('post') || is_category() || is_home() ){
			$show = findgo_get_config('show_blog_breadcrumbs', true);
			if ( $show && !is_front_page() ) {
				$breadcrumb_img = findgo_get_config('blog_breadcrumb_image');
		        $breadcrumb_color = findgo_get_config('blog_breadcrumb_color');
		        $style = array();
		        if ( $breadcrumb_color || ( isset($breadcrumb_img['url']) && !empty($breadcrumb_img['url']) ) ) {
		            $classes[] = 'header_transparent';
		        }
	        }
		}
		if(is_singular('job_listing')){
			// add for single listing
			$single_layout = findgo_get_listing_single_version();
			if($single_layout == 'v3' || $single_layout == 'v4'){
				$classes[] = ' header_transparent ';
			}
		}
		if ( findgo_get_config('image_lazy_loading') ) {
			$classes[] = 'image-lazy-loading';
		}
		if ( findgo_get_config('preload', false) ) {
			$classes[] = 'apus-body-loading';
		}

		// no breadscrumb
		$post_type = get_query_var('post_type');
		if ( is_singular('post') || is_category() ) {
			$show = findgo_get_config('show_blog_breadcrumbs', true);
			if ( !$show  ) {
				$classes[] = 'no-breadscrumb';
			}
		} elseif ( is_post_type_archive('job_listing') || is_tax('job_listing_tag') || is_tax('job_listing_amenity') || is_tax('job_listing_category') || is_tax('job_listing_region') || is_tax('job_listing_type') || ( is_search() && $post_type == 'job_listing' )) {
			$classes[] = ' archive-jobs-listings ';
			$show_bread = findgo_get_config('show_listing_breadcrumbs', true);
			$show = true;
			if ( !is_singular('job_listing') ) {
				$version = findgo_get_listing_archive_version();
				$halfmaps = findgo_get_listing_all_half_map_version();
				if ( in_array($version, $halfmaps) ) {
					$show = false;
					$classes[] = 'no-footer fix-header';
				} else {
					$classes[] = 'listings-default-layout';
				}
			} else {
				$show = false;
			}
			if ( !$show_bread || !$show  ) {
				$classes[] = 'no-breadscrumb';
			}
		}
		return $classes;
	}
	add_filter( 'body_class', 'findgo_body_classes' );
}

if ( ! function_exists( 'findgo_get_shortcode_regex' ) ) {
	function findgo_get_shortcode_regex( $tagregexp = '' ) {
		// WARNING! Do not change this regex without changing do_shortcode_tag() and strip_shortcode_tag()
		// Also, see shortcode_unautop() and shortcode.js.
		return
			'\\['                                // Opening bracket
			. '(\\[?)'                           // 1: Optional second opening bracket for escaping shortcodes: [[tag]]
			. "($tagregexp)"                     // 2: Shortcode name
			. '(?![\\w-])'                       // Not followed by word character or hyphen
			. '('                                // 3: Unroll the loop: Inside the opening shortcode tag
			. '[^\\]\\/]*'                   // Not a closing bracket or forward slash
			. '(?:'
			. '\\/(?!\\])'               // A forward slash not followed by a closing bracket
			. '[^\\]\\/]*'               // Not a closing bracket or forward slash
			. ')*?'
			. ')'
			. '(?:'
			. '(\\/)'                        // 4: Self closing tag ...
			. '\\]'                          // ... and closing bracket
			. '|'
			. '\\]'                          // Closing bracket
			. '(?:'
			. '('                        // 5: Unroll the loop: Optionally, anything between the opening and closing shortcode tags
			. '[^\\[]*+'             // Not an opening bracket
			. '(?:'
			. '\\[(?!\\/\\2\\])' // An opening bracket not followed by the closing shortcode tag
			. '[^\\[]*+'         // Not an opening bracket
			. ')*+'
			. ')'
			. '\\[\\/\\2\\]'             // Closing shortcode tag
			. ')?'
			. ')'
			. '(\\]?)';                          // 6: Optional second closing brocket for escaping shortcodes: [[tag]]
	}
}

if ( ! function_exists( 'findgo_tagregexp' ) ) {
	function findgo_tagregexp() {
		return apply_filters( 'findgo_custom_tagregexp', 'video|audio|playlist|video-playlist|embed|findgo_media' );
	}
}

if ( !function_exists('findgo_get_header_layouts') ) {
	function findgo_get_header_layouts() {
		$headers = array();
		$files = glob( get_template_directory() . '/headers/*.php' );
	    if ( !empty( $files ) ) {
	        foreach ( $files as $file ) {
	        	$header = str_replace( '.php', '', basename($file) );
	            $headers[$header] = $header;
	        }
	    }
		return $headers;
	}
}

if ( !function_exists('findgo_get_header_layout') ) {
	function findgo_get_header_layout() {
		global $post;
		if ( is_page() && is_object($post) && isset($post->ID) ) {
			return findgo_page_header_layout();
		}
		return findgo_get_config('header_type');
	}
	add_filter( 'findgo_get_header_layout', 'findgo_get_header_layout' );
}

if ( !function_exists('findgo_get_footer_layouts') ) {
	function findgo_get_footer_layouts() {
		$footers = array();
		$args = array(
			'posts_per_page'   => -1,
			'offset'           => 0,
			'orderby'          => 'date',
			'order'            => 'DESC',
			'post_type'        => 'apus_footer',
			'post_status'      => 'publish',
			'suppress_filters' => true 
		);
		$posts = get_posts( $args );
		foreach ( $posts as $post ) {
			$footers[$post->post_name] = $post->post_title;
		}
		return $footers;
	}
}

if ( !function_exists('findgo_get_footer_layout') ) {
	function findgo_get_footer_layout() {
		if ( is_page() ) {
			global $post;
			$footer = '';
			if ( is_object($post) && isset($post->ID) ) {
				$footer = get_post_meta( $post->ID, 'apus_page_footer_type', true );
				if ( empty($footer) || $footer == 'global' ) {
					return findgo_get_config('footer_type', '');
				}
			}
			return $footer;
		}
		return findgo_get_config('footer_type', '');
	}
	add_filter('findgo_get_footer_layout', 'findgo_get_footer_layout');
}

if ( !function_exists('findgo_blog_content_class') ) {
	function findgo_blog_content_class( $class ) {
		$page = 'archive';
		if ( is_singular( 'post' ) ) {
            $page = 'single';
        }
		if ( findgo_get_config('blog_'.$page.'_fullwidth') ) {
			return 'container-fluid no-padding';
		}
		return $class;
	}
}
add_filter( 'findgo_blog_content_class', 'findgo_blog_content_class', 1 , 1  );


if ( !function_exists('findgo_get_blog_layout_configs') ) {
	function findgo_get_blog_layout_configs() {
		$page = 'archive';
		$addition_class = '';
		if ( is_singular( 'post' ) ) {
            $page = 'single';
            $addition_class = 'main-content-only';
        }
		$left = findgo_get_config('blog_'.$page.'_left_sidebar');
		$right = findgo_get_config('blog_'.$page.'_right_sidebar');

		switch ( findgo_get_config('blog_'.$page.'_layout') ) {
		 	case 'left-main':
		 		$configs['left'] = array( 'sidebar' => $left, 'class' => 'col-md-4 col-sm-12 col-xs-12'  );
		 		$configs['main'] = array( 'class' => 'col-md-8 col-sm-12 col-xs-12 pull-right' );
		 		break;
		 	case 'main-right':
		 		$configs['right'] = array( 'sidebar' => $right,  'class' => 'col-md-4 col-sm-12 col-xs-12 pull-right' ); 
		 		$configs['main'] = array( 'class' => 'col-md-8 col-sm-12 col-xs-12' );
		 		break;
	 		case 'main':
	 			$configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12 '.$addition_class );
	 			break;
		 	default:
		 		$configs['right'] = array( 'sidebar' => 'sidebar-default',  'class' => 'col-md-3 col-sm-12 col-xs-12 pull-right' ); 
		 		$configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12' );
		 		break;
		}

		return $configs; 
	}
}

if ( !function_exists('findgo_page_content_class') ) {
	function findgo_page_content_class( $class ) {
		global $post;
		if (is_object($post)) {
			$fullwidth = get_post_meta( $post->ID, 'apus_page_fullwidth', true );

			if ( !$fullwidth || $fullwidth == 'no' ) {
				return $class;
			}
		}
		return 'container-fluid';
	}
}
add_filter( 'findgo_page_content_class', 'findgo_page_content_class', 1 , 1  );

if ( !function_exists('findgo_get_page_layout_configs') ) {
	function findgo_get_page_layout_configs() {
		global $post;
		if ( is_object($post) ) {
			$left = get_post_meta( $post->ID, 'apus_page_left_sidebar', true );
			$right = get_post_meta( $post->ID, 'apus_page_right_sidebar', true );

			switch ( get_post_meta( $post->ID, 'apus_page_layout', true ) ) {
			 	case 'left-main':
			 		$configs['left'] = array( 'sidebar' => $left, 'class' => 'col-md-3 col-sm-12 col-xs-12'  );
			 		$configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12' );
			 		break;
			 	case 'main-right':
			 		$configs['right'] = array( 'sidebar' => $right,  'class' => 'col-md-3 col-sm-12 col-xs-12' ); 
			 		$configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12' );
			 		break;
		 		case 'main':
		 			$configs['main'] = array( 'class' => 'col-xs-12' );
		 			break;
			 	default:
			 		$configs['right'] = array( 'sidebar' => 'sidebar-default',  'class' => 'col-md-3 col-sm-12 col-xs-12 pull-right' ); 
		 			$configs['main'] = array( 'class' => 'col-md-9 col-sm-12 col-xs-12' );
			 		break;
			}
		} else {
			$configs['main'] = array( 'class' => 'col-md-12 col-xs-12' );
		}
		return $configs; 
	}
}

if ( !function_exists('findgo_page_header_layout') ) {
	function findgo_page_header_layout() {
		global $post;
		$header = get_post_meta( $post->ID, 'apus_page_header_type', true );
		if ( $header == 'global' ) {
			return findgo_get_config('header_type');
		}
		return $header;
	}
}

if ( ! function_exists( 'findgo_get_first_url_from_string' ) ) {
	function findgo_get_first_url_from_string( $string ) {
		$pattern = "/^\b(?:(?:https?|ftp):\/\/)[-a-z0-9+&@#\/%?=~_|!:,.;]*[-a-z0-9+&@#\/%=~_|]/i";
		preg_match( $pattern, $string, $link );

		$link_return = ( ! empty( $link[0] ) ) ? $link[0] : false;
		$content = str_replace($link_return, "", $string);
        $content = apply_filters( 'the_content', $content);
        return array( 'link' => $link_return, 'content' => $content );
	}
}

if ( !function_exists( 'findgo_get_link_attributes' ) ) {
	function findgo_get_link_attributes( $string ) {
		preg_match( '/<a href="(.*?)">/i', $string, $atts );

		return ( ! empty( $atts[1] ) ) ? $atts[1] : '';
	}
}

if ( !function_exists( 'findgo_post_media' ) ) {
	function findgo_post_media( $content ) {
		$is_video = ( get_post_format() == 'video' ) ? true : false;
		$media = findgo_get_first_url_from_string( $content );
		$media = $media['link'];
		if ( ! empty( $media ) ) {
			global $wp_embed;
			$content = do_shortcode( $wp_embed->run_shortcode( '[embed]' . $media . '[/embed]' ) );
		} else {
			$pattern = findgo_get_shortcode_regex( findgo_tagregexp() );
			preg_match( '/' . $pattern . '/s', $content, $media );
			if ( ! empty( $media[2] ) ) {
				if ( $media[2] == 'embed' ) {
					global $wp_embed;
					$content = do_shortcode( $wp_embed->run_shortcode( $media[0] ) );
				} else {
					$content = do_shortcode( $media[0] );
				}
			}
		}
		if ( ! empty( $media ) ) {
			$output = '<div class="entry-media">';
			$output .= ( $is_video ) ? '<div class="pro-fluid"><div class="pro-fluid-inner">' : '';
			$output .= $content;
			$output .= ( $is_video ) ? '</div></div>' : '';
			$output .= '</div>';

			return $output;
		}

		return false;
	}
}

if ( !function_exists( 'findgo_post_gallery' ) ) {
	function findgo_post_gallery( $content, $args = array() ) {
		$output = '';
		$defaults = array( 'size' => 'large' );
		$args = wp_parse_args( $args, $defaults );
	    $gallery_filter = findgo_gallery_from_content( $content );
	    if (count($gallery_filter['ids']) > 0) {
        	$output .= '<div class="slick-carousel post-gallery-slick" data-carousel="slick" data-smallmedium="1" data-extrasmall="1" data-items="1" data-pagination="false" data-nav="true">';
                foreach($gallery_filter['ids'] as $attach_id) {
                    $output .= '<div class="gallery-item">';
                    $output .= wp_get_attachment_image($attach_id, $args['size'] );
                    $output .= '</div>';
                }
            $output .= '</div>';
        }
        return $output;
	}
}

if (!function_exists('findgo_gallery_from_content')) {
    function findgo_gallery_from_content($content) {

        $result = array(
            'ids' => array(),
            'filtered_content' => ''
        );

        preg_match('/\[gallery.*ids=.(.*).\]/', $content, $ids);
        if(!empty($ids)) {
            $result['ids'] = explode(",", $ids[1]);
            $content =  str_replace($ids[0], "", $content);
            $result['filtered_content'] = apply_filters( 'the_content', $content);
        }

        return $result;

    }
}

if ( !function_exists( 'findgo_random_key' ) ) {
    function findgo_random_key($length = 5) {
        $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
        $return = '';
        for ($i = 0; $i < $length; $i++) {
            $return .= $characters[rand(0, strlen($characters) - 1)];
        }
        return $return;
    }
}

if ( !function_exists('findgo_substring') ) {
    function findgo_substring($string, $limit, $afterlimit = '[...]') {
        if ( empty($string) ) {
        	return $string;
        }
       	$string = explode(' ', strip_tags( $string ), $limit);

        if (count($string) >= $limit) {
            array_pop($string);
            $string = implode(" ", $string) .' '. $afterlimit;
        } else {
            $string = implode(" ", $string);
        }
        $string = preg_replace('`[[^]]*]`','',$string);
        return strip_shortcodes( $string );
    }
}

function findgo_get_user_url($user_id, $nicename, $tags = array()) {
	$url = get_author_posts_url( $user_id, $nicename );
	if ( !empty($tags) ) {
		foreach ($tags as $tag => $value) {
			$url = add_query_arg( $tag, $value, remove_query_arg( $tag, $url ) );
		}
	}
	return apply_filters('findgo_get_user_url', $url, $user_id, $tags);
}


function findgo_is_apus_framework_activated() {
	return defined('APUS_FRAMEWORK_VERSION') ? true : false;
}

function findgo_is_cmb2_activated() {
	return defined('CMB2_LOADED') ? true : false;
}

function findgo_is_woocommerce_activated() {
	return class_exists( 'woocommerce' ) ? true : false;
}

function findgo_is_vc_activated() {
	return class_exists( 'WPBakeryVisualComposerAbstract' ) ? true : false;
}

function findgo_is_revslider_activated() {
	return function_exists( 'putRevSlider' );
}

function findgo_is_dokan_activated() {
	return class_exists( 'WeDevs_Dokan' ) ? true : false;
}

function findgo_is_wcvendors_activated() {
	return class_exists( 'WC_Vendors' ) ? true : false;
}

function findgo_is_wp_job_manager_activated() {
	return class_exists( 'WP_Job_Manager' ) ? true : false;
}

function findgo_is_wc_paid_listings_activated() {
	return class_exists( 'WC_Paid_Listings' ) ? true : false;
}

function findgo_is_nextend_facebook_connect_activated() {
	return class_exists( 'NextendSocialLogin' ) ? true : false;
}

function findgo_marital_status_defaults() {
	return apply_filters( 'findgo_marital_status_defaults', array(
		'single' => esc_html__('Single', 'findgo'),
		'engaged' => esc_html__('Engaged', 'findgo'),
		'married' => esc_html__('Married', 'findgo'),
		'separated' => esc_html__('Separated', 'findgo'),
		'divorced' => esc_html__('Divorced', 'findgo'),
		'widow' => esc_html__('Widow', 'findgo'),
		'widower' => esc_html__('Widower', 'findgo'),
	) );
}

function findgo_sex_defaults() {
	return apply_filters( 'findgo_sex_defaults', array(
		'male' => esc_html__('Male', 'findgo'),
		'female' => esc_html__('Female', 'findgo'),
		'other' => esc_html__('Other', 'findgo')
	) );
}

function findgo_user_social_defaults() {
	return apply_filters( 'findgo_user_social_defaults', array(
		'facebook' => esc_html__('Facebook', 'findgo'),
		'twitter' => esc_html__('Twitter', 'findgo'),
		'google-plus' => esc_html__('Google+', 'findgo'),
		'pinterest' => esc_html__('Pinterest', 'findgo'),
		'linkedin' => esc_html__('Linkedin', 'findgo'),
		'instagram' => esc_html__('Instagram', 'findgo'),
	) );
}