<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$finbuzz_socials = FinbuzzTheme_Helper::socials();
?>
<div id="tophead" class="header-top-bar align-items-center">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-lg-6">
				<?php if(FinbuzzTheme::$options['top_header_text'] || FinbuzzTheme::$options['header_team_btn'] ): ?>
					<div class="topbar-left">
						<?php if ( FinbuzzTheme::$options['top_header_text'] ) { ?>
							<p class="item-paragraph">
								<?php echo wp_kses( FinbuzzTheme::$options['top_header_text'] , 'alltext_allow' );?>
							</p>
						<?php } ?>
						<?php if ( FinbuzzTheme::$options['header_team_btn_switch'] == '1' && !empty(FinbuzzTheme::$options['header_team_btn'])) { ?>
							<div class="header-button">
								<a target="_self"  href="<?php echo esc_url( FinbuzzTheme::$options['header_team_button_link']  );?>"><?php echo esc_html( FinbuzzTheme::$options['header_team_btn'] );?><i class="fas fa-long-arrow-alt-right"></i>
							</a>
							</div>
						<?php } ?>
					</div>
				<?php endif; ?>
			</div>
			<div class="col-lg-6 d-flex justify-content-end">
				<?php if( $finbuzz_socials || FinbuzzTheme::$options['online_button_text'] ): ?>
					<div class="topbar-right">
						<?php if ( $finbuzz_socials ) { ?>
							<ul>
								<li class="topbar-social">
								<div class="social-icon">
								<?php foreach ( $finbuzz_socials as $finbuzz_social ): ?>
									<a target="_blank" href="<?php echo esc_url( $finbuzz_social['url'] );?>"><i class="fab <?php echo esc_attr( $finbuzz_social['icon'] );?>"></i></a>
								<?php endforeach; ?>
								</div>
								</li>
							</ul>
						<?php } ?>
						<?php if ( FinbuzzTheme::$options['online_button'] == '1' && !empty(FinbuzzTheme::$options['online_button_text'])) { ?>
							<div class="header-right-button">
							<a target="_self" class="header-btn" href="<?php echo esc_url( FinbuzzTheme::$options['online_button_link']  );?>"><?php echo esc_html( FinbuzzTheme::$options['online_button_text'] );?></a>
							</div>
						<?php } ?>
					</div>
				<?php endif; ?>	
			</div>
		</div>
	</div>
</div>