<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$nav_menu_args = FinbuzzTheme_Helper::nav_menu_args();

// Logo

if( !empty( FinbuzzTheme::$options['logo'] ) ) {
	$logo_dark = wp_get_attachment_image( FinbuzzTheme::$options['logo'], 'full' );
	$finbuzz_dark_logo = $logo_dark;
}else {
	$finbuzz_dark_logo = "<img width='152' height='45' src='" . FINBUZZ_IMG_URL . 'logo-dark.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "' loading='lazy'>"; 
}

if( !empty( FinbuzzTheme::$options['logo_light'] ) ) {
	$logo_lights = wp_get_attachment_image( FinbuzzTheme::$options['logo_light'], 'full' );
	$finbuzz_light_logo = $logo_lights;
}else {
	$finbuzz_light_logo = "<img width='152' height='45' src='" . FINBUZZ_IMG_URL . 'logo-light.svg' . "' alt='" . esc_attr( get_bloginfo('name') ) . "'>";
}

?>
<div id="rt-sticky-placeholder"></div>
<div class="header-menu mobile-menu menu-layout1" id="header-menu">
	<div class="container">
		<div class="menu-full-wrap">
			<div class="site-branding-wrap">
				<div class="site-branding">
					<a class="dark-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_dark_logo, 'allow_link' ); ?></a>
						<a class="light-logo" href="<?php echo esc_url( home_url( '/' ) );?>"><?php echo wp_kses( $finbuzz_light_logo, 'allow_link' ); ?></a>
				</div>
			</div>
			<div class="header-right">
				<div class="menu-wrap">
					<div id="site-navigation" class="main-navigation">
						<?php wp_nav_menu( $nav_menu_args );?>
					</div>
				</div>
				<ul class="info-wrap">
					<?php if ( FinbuzzTheme::$options['search_icon'] ) { ?>
						<li class="search-btn">
							<?php get_template_part( 'template-parts/header/icon', 'search' ); ?>
						</li>
					<?php } ?>
					<?php if ( FinbuzzTheme::$options['cart_icon'] ) { ?>
						<li class="cart-icon-area">				
								<?php get_template_part( 'template-parts/header/icon', 'cart' );?>
						</li>
					<?php } ?>
					<?php if ( FinbuzzTheme::$options['online_button'] == '1' && !empty(FinbuzzTheme::$options['online_button_text'])) { ?>
						<li>
							<div class="header-right-button">
							<a target="_self" class="header-btn" href="<?php echo esc_url( FinbuzzTheme::$options['online_button_link']  );?>"><span class="btn-img"><img width="24" height="20" src="<?php echo FINBUZZ_ASSETS_URL . 'element/shape36.png'; ?>" alt="<?php echo esc_attr('shape','finbuzz'); ?>"></span><span class="btn-text"><?php echo esc_html( FinbuzzTheme::$options['online_button_text'] );?></span></a>
							</div>
						</li>
					<?php } ?> 
				</ul>
			</div>
		</div>
	</div>
</div>