<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size = 'finbuzz-size1';

global $post;

?>
<div id="post-<?php the_ID();?>" <?php post_class( 'portfolio-single' );?>>
	<div class="post-thumb">
			<?php
				if ( has_post_thumbnail() ){
					the_post_thumbnail( $thumb_size );
				} else {
					if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
						echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
					} else {
						echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_1210X584.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
					}
				}
			?>
		</div>	
	<div class="rtin-portfolio-content">
		<?php
			$i = 1;
			$term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
			if($term_lists){ ?>
				<div class="single-port-cat">
				<?php foreach ( $term_lists as $term_list ){ 
				$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; } ?>
				</div>	
			<?php } ?>	
		<?php the_content();?>
	</div>
	<!-- next/prev post -->
	<?php if ( FinbuzzTheme::$options['portfolio_post_links'] ) { finbuzz_portfolio_links_next_prev(); } ?>
	<?php if( FinbuzzTheme::$options['show_related_port'] == '1' && is_single() && !empty ( finbuzz_related_port() ) ) { ?>
	<div class="related-post">
		<?php finbuzz_related_port(); ?>
	</div>
	<?php } ?>
	
	
</div>