<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

$thumb_size = 'finbuzz-size5';
$id 		= get_the_ID();
$content 	= get_the_content();
$content 	= apply_filters( 'the_content', $content );
$content 	= wp_trim_words( get_the_excerpt(), FinbuzzTheme::$options['portfolio_arexcerpt_limit'], '' );
$finbuzz_port_no  = get_post_meta( $post->ID, 'portfolio_serial_num', true );
?>
<article id="post-<?php the_ID(); ?>">
	<div class="rtin-item">
		<div class="rtin-figure">
			<a href="<?php the_permalink(); ?>">
				<?php
					if ( has_post_thumbnail() ){
						the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
					} else {
						if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
							echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
						} else {
							echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
						}
					}
				?>
			</a>
			<div class="rtin-content">
				<?php 
					if($finbuzz_port_no && FinbuzzTheme::$options['portfolio_ar_number']){
						?>
							<div class="item-number"><?php echo esc_html( $finbuzz_port_no  ) ;?></div>
				 <?php 	}
				?>
				<?php if ( FinbuzzTheme::$options['portfolio_ar_category'] ) { ?>
					<?php
						$i = 1;
						$term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
						if($term_lists){ ?>
						<div class="cat-list">
							<?php foreach ( $term_lists as $term_list ){ 
							$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; } ?>
							</div>	
				<?php } }?>
				<h3><a href="<?php the_permalink();?>"><?php the_title();?></a></h3>
				<?php if(FinbuzzTheme::$options['portfolio_ar_excerpt']){ ?>
					<p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
				<?php } ?>	
				<?php if ( FinbuzzTheme::$options['portfolio_ar_link'] ) { ?>
					<div class="portfolio-btn">
						<?php if ( FinbuzzTheme::$options['portfolio_ar_link'] ) { ?>
							<a href="<?php the_permalink();?>" class="btn-style2">+ <span>Read More</span></a>
						<?php } ?>
					</div>
				<?php } ?>
			</div>
		</div>
	</div>
</article>