<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

// Layout class
if ( FinbuzzTheme::$layout == 'full-width' ) {
	$finbuzz_layout_class = 'col-sm-12 col-12';
}
else{
	$finbuzz_layout_class = FinbuzzTheme_Helper::has_active_widget();
}
$finbuzz_is_post_archive = is_home() || ( is_archive() && get_post_type() == 'post' ) ? true : false;

if ( is_post_type_archive( "finbuzz_service" ) || is_tax( "finbuzz_service_category" ) ) {
		get_template_part( 'template-parts/archive', 'service' );
	return;
}
if ( is_post_type_archive( "finbuzz_gallery" ) || is_tax( "finbuzz_gallery_category" ) ) {
		get_template_part( 'template-parts/archive', 'gallery' );
	return;
}
if ( is_post_type_archive( "finbuzz_team" ) || is_tax( "finbuzz_team_category" ) ) {
		get_template_part( 'template-parts/archive', 'team' );
	return;
}

?>
<?php get_header(); ?>
<div id="primary" class="content-area">
	<div class="container">
		<div class="row">
			<?php
			if ( FinbuzzTheme::$layout == 'left-sidebar' ) {
				get_sidebar();
			}
			?>
			<div class="<?php echo esc_attr( $finbuzz_layout_class );?>">
				<main id="main" class="site-main">
					<div class="rt-sidebar-sapcer">				
						<?php
						if ( have_posts() ) { ?>
							<?php
							if ( $finbuzz_is_post_archive && FinbuzzTheme::$options['blog_style'] == 'style1' ) {
								echo '<div class="row">';
								while ( have_posts() ) : the_post();
									get_template_part( 'template-parts/content-1', get_post_format() );
								endwhile;
								echo '</div>';
							} else if ( $finbuzz_is_post_archive && FinbuzzTheme::$options['blog_style'] == 'style2' ) {
								while ( have_posts() ) : the_post();
									get_template_part( 'template-parts/content-2', get_post_format() );
								endwhile;
							} else if ( class_exists( 'Finbuzz_Core' ) ) {
								if ( is_tax( 'finbuzz_portfolio_category' ) ) {
									echo '<div class="row">';
									while ( have_posts() ) : the_post();
										get_template_part( 'template-parts/content-1', get_post_format() );
									endwhile;
									echo '</div>';
								}							
							}
							else {
								while ( have_posts() ) : the_post();
									get_template_part( 'template-parts/content-1', get_post_format() );
								endwhile;
							}

							?>
							<?php FinbuzzTheme_Helper::pagination(); ?>
							
						<?php } else {?>
							<?php get_template_part( 'template-parts/content', 'none' );?>
						<?php } ?>
					</div>					
				</main>
			</div>
			<?php
			if( FinbuzzTheme::$layout == 'right-sidebar' ) {
				get_sidebar();
			}
			?>
		</div>
	</div>
</div>
<?php get_footer(); ?>