<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if ( !isset( $content_width ) ) {
	$content_width = 1200;
}

add_action('after_setup_theme', 'finbuzz_setup');
if ( !function_exists( 'finbuzz_setup' ) ) {
	function finbuzz_setup() {
		// Language
		load_theme_textdomain( 'finbuzz', FINBUZZ_BASE_DIR . 'languages' );

		// Theme support
		add_theme_support( 'title-tag' );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'automatic-feed-links' );
		remove_theme_support('widgets-block-editor');
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
		add_theme_support( 'post-formats', array( 'aside', 'gallery', 'video', 'audio' ) );
		add_theme_support( 'woocommerce' );
		// for gutenberg support
		add_theme_support( 'align-wide' );
		add_theme_support( 'editor-color-palette', array(
			array(
				'name' => esc_html__( 'Primary Color', 'finbuzz' ),
				'slug' => 'finbuzz-primary',
				'color' => '#fa360a',
			),
			array(
				'name' => esc_html__( 'Secondary Color', 'finbuzz' ),
				'slug' => 'finbuzz-secondary',
				'color' => '#ff5e17', 
			),
			array(
				'name' => esc_html__( 'dark gray', 'finbuzz' ),
				'slug' => 'finbuzz-button-dark-gray',
				'color' => '#111111',
			),
			array(
				'name' => esc_html__( 'light gray', 'finbuzz' ),
				'slug' => 'finbuzz-button-light-gray',
				'color' => '#a5a5a5',
			),
			array(
				'name' => esc_html__( 'white', 'finbuzz' ),
				'slug' => 'finbuzz-button-white',
				'color' => '#ffffff',
			),
		) );
		add_theme_support( 'editor-gradient-presets', array(
			array(
				'name'     => esc_html__( 'Gradient Color', 'finbuzz' ),
				'gradient' => 'linear-gradient(to right,#ff5e17,#fa360a)',
				'slug'     => 'finbuzz_gradient_color',
			),
		));	
		add_theme_support( 'editor-font-sizes', array(
			array(
				'name' => esc_html__( 'Small', 'finbuzz' ),
				'size' => 12,
				'slug' => 'small'
			),
			array(
				'name' => esc_html__( 'Normal', 'finbuzz' ),
				'size' => 16,
				'slug' => 'normal'
			),
			array(
				'name' => esc_html__( 'Large', 'finbuzz' ),
				'size' => 36,
				'slug' => 'large'
			),
			array(
				'name' => esc_html__( 'Huge', 'finbuzz' ),
				'size' => 50,
				'slug' => 'huge'
			)
		) );
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'responsive-embeds' );
		add_theme_support('editor-styles');	
		
		// Image sizes
		add_image_size( 'finbuzz-size1', 1210, 617, true );   	// fullimage
		add_image_size( 'finbuzz-size2', 570, 447, true );    	// blog layout 1 
		add_image_size( 'finbuzz-size3', 825, 550, true );    	// Blog layout 2
		add_image_size( 'finbuzz-size4', 570, 406, true );    	// portfolio layout 1	
		add_image_size( 'finbuzz-size5', 551, 700, true );    	// portfolio layout 2,team single
		add_image_size( 'finbuzz-size6', 100, 98, true );    	//rt recent post widget image 
		add_image_size( 'finbuzz-size7', 570, 553, true );    	//team 1,gallery 1 archive image
		add_image_size( 'finbuzz-size8', 265, 292, true );    	//team 2 image
		add_image_size( 'finbuzz-size9', 690, 375, true );    	//service image 1
		add_image_size( 'finbuzz-size10', 380, 380, true );    	//testimonial image 1
		add_image_size( 'finbuzz-size11', 300, 378, true );    	//testimonial image 1
		add_image_size( 'finbuzz-size11', 350, 440, true );    	//Team image 1

		
		register_nav_menus( array(
			'primary'  => esc_html__( 'Primary', 'finbuzz' ),
			'footer-menu'  => esc_html__( 'Footer Menu', 'finbuzz' ),
		) );		
	}
}

function finbuzz_theme_add_editor_styles() {
	add_editor_style( get_stylesheet_uri() );
}
add_action( 'admin_init', 'finbuzz_theme_add_editor_styles' );

function finbuzz_pingback_header() {
	if ( is_singular() && pings_open() ) {
		echo '<link rel="pingback" href="', esc_url( get_bloginfo( 'pingback_url' ) ), '">';
	}
}
add_action( 'wp_head', 'finbuzz_pingback_header' );

// Footer Html
add_action( 'wp_footer', 'finbuzz_footer_html', 1 );
if( !function_exists( 'finbuzz_footer_html' ) ) {
	function finbuzz_footer_html(){
		// Back-to-top link
		if ( FinbuzzTheme::$options['back_to_top'] ){
			echo '<a href="#" class="scrollup"><i class="fas fa-angle-double-up"></i>' . esc_html__( 'TOP', 'finbuzz' ) . '</a>';
		}
	}	
}
/*Allow HTML for the kses post*/
function finbuzz_kses_allowed_html($tags, $context) {
    switch($context) {
        case 'social':
            $tags = array(
                'a' => array('href' => array()),
                'b' => array()
            );
            return $tags;
		case 'allow_link':
            $tags = array(
                'a' => array(
                    'class' => array(),
                    'href'  => array(),
                    'rel'   => array(),
                    'title' => array(),
					'target' => array(),
                ),
				'img' => array(
                    'alt'    => array(),
                    'class'  => array(),
                    'height' => array(),
                    'src'    => array(),
                    'srcset' => array(),
                    'width'  => array(),
                ),
                'b' => array()
            );
            return $tags;
		case 'allow_title':
            $tags = array(
				'a' => array(
                    'class' => array(),
                    'href'  => array(),
                    'rel'   => array(),
                    'title' => array(),
					'target' => array(),
                ),
                'span' => array(
                    'class' => array(),
                    'style' => array(),
                ),
                'b' => array()
            );
            return $tags;
			
        case 'alltext_allow':
            $tags = array(
                'a' => array(
                    'class' => array(),
                    'href'  => array(),
                    'rel'   => array(),
                    'title' => array(),
					'target' => array(),
                ),
                'abbr' => array(
                    'title' => array(),
                ),
                'b' => array(),
                'br' => array(),
                'blockquote' => array(
                    'cite'  => array(),
                ),
                'cite' => array(
                    'title' => array(),
                ),
                'code' => array(),
                'del' => array(
                    'datetime' => array(),
                    'title' => array(),
                ),
                'dd' => array(),
                'div' => array(
                    'class' => array(),
                    'title' => array(),
                    'style' => array(),
                    'id' 	=> array(),
                ),
                'dl' => array(),
                'dt' => array(),
                'em' => array(),
                'h1' => array(),
                'h2' => array(),
                'h3' => array(),
                'h4' => array(),
                'h5' => array(),
                'h6' => array(),
                'i' => array(
					'class' => array(),
				),
                'img' => array(
                    'alt'    => array(),
                    'class'  => array(),
                    'height' => array(),
                    'src'    => array(),
                    'srcset' => array(),
                    'width'  => array(),
                ),
                'li' => array(
                    'class' => array(),
                ),
                'ol' => array(
                    'class' => array(),
                ),
                'p' => array(
                    'class' => array(),
                ),
                'q' => array(
                    'cite' => array(),
                    'title' => array(),
                ),
                'span' => array(
                    'class' => array(),
                    'title' => array(),
                    'style' => array(),
                ),
                'strike' => array(),
                'strong' => array(),
                'ul' => array(
                    'class' => array(),
                ),
            );
            return $tags;
        default:
            return $tags;
    }
}
add_filter( 'wp_kses_allowed_html', 'finbuzz_kses_allowed_html', 10, 2);

add_filter( 'wp_kses_allowed_html', function( $tags ) {

    $tags['svg'] = array(
		'class'           => true,
		'aria-hidden'     => true,
		'aria-labelledby' => true,
		'role'            => true,
		'xmlns'           => true,
		'width'           => true,
		'height'          => true,
		'viewbox'         => true, // <= Must be lower case!
    );
    $tags['path'] = array(
        'd' => array(),
        'fill' => array(),
    );
    return $tags;

}, 10, 2);


/**
 * @param Wp_Query $query
 * @return mixed
 */
function advanced_search_query($query) {
    if($query->is_search()) {
        // category terms search.
        if (isset($_GET['category']) && !empty($_GET['category'])) {
            $query->set('tax_query', array(array(
                'taxonomy' => 'product_cat',
                'field' => 'slug',
                'terms' => array($_GET['category']) )
            ));
        }    
    }
    return $query;
}
add_action('pre_get_posts', 'advanced_search_query', 1000);

/*social link to author profile page*/
add_action( 'show_user_profile', 'finbuzz_user_social_profile_fields' );
add_action( 'edit_user_profile', 'finbuzz_user_social_profile_fields' );

function finbuzz_user_social_profile_fields( $user ) { ?>

	<h3><?php esc_html_e( 'User Designation' , 'finbuzz' ); ?></h3>

	<table class="form-table">
		<tr>
			<th><label for="finbuzz_author_designation"><?php esc_html_e( 'Author Designation' , 'finbuzz' ); ?></label></th>
			<td><input type="text" name="finbuzz_author_designation" id="finbuzz_author_designation" value="<?php echo esc_attr( get_the_author_meta( 'finbuzz_author_designation', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your Author Designation' , 'finbuzz' ); ?></span></td>
		</tr>
	</table>
	
	<h3><?php esc_html_e( 'Social profile information' , 'finbuzz' ); ?></h3>

	<table class="form-table">
		<tr>
			<th><label for="facebook"><?php esc_html_e( 'Facebook' , 'finbuzz' ); ?></label></th>
			<td><input type="text" name="facebook" id="facebook" value="<?php echo esc_attr( get_the_author_meta( 'finbuzz_facebook', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your facebook URL.' , 'finbuzz' ); ?></span></td>
		</tr>
		<tr>
			<th><label for="twitter"><?php esc_html_e( 'Twitter' , 'finbuzz' ); ?></label></th>
			<td><input type="text" name="twitter" id="twitter" value="<?php echo esc_attr( get_the_author_meta( 'finbuzz_twitter', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your Twitter username.' , 'finbuzz' ); ?></span></td>
		</tr>
		<tr>
			<th><label for="linkedin"><?php esc_html_e( 'LinkedIn' , 'finbuzz' ); ?></label></th>
			<td><input type="text" name="linkedin" id="linkedin" value="<?php echo esc_attr( get_the_author_meta( 'finbuzz_linkedin', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your LinkedIn Profile' , 'finbuzz' ); ?></span></td>
		</tr>
		<tr>
			<th><label for="gplus"><?php esc_html_e( 'Google+' , 'finbuzz' ); ?></label></th>
			<td><input type="text" name="gplus" id="gplus" value="<?php echo esc_attr( get_the_author_meta( 'finbuzz_gplus', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your google+ Profile' , 'finbuzz' ); ?></span></td>
		</tr>
		<tr>
			<th><label for="pinterest"><?php esc_html_e( 'Pinterest' , 'finbuzz' ); ?></label></th>
			<td><input type="text" name="pinterest" id="pinterest" value="<?php echo esc_attr( get_the_author_meta( 'finbuzz_pinterest', $user->ID ) ); ?>" class="regular-text" /><br /><span class="description"><?php esc_html_e( 'Please enter your Pinterest Profile' , 'finbuzz' ); ?></span></td>
		</tr>
	</table>
<?php }

add_action( 'personal_options_update', 'finbuzz_extra_profile_fields' );
add_action( 'edit_user_profile_update', 'finbuzz_extra_profile_fields' );

function finbuzz_extra_profile_fields( $user_id ) {

	if ( !current_user_can( 'edit_user', $user_id ) )
		return false;

	update_user_meta( $user_id, 'finbuzz_facebook', $_POST['facebook'] );
	update_user_meta( $user_id, 'finbuzz_twitter', $_POST['twitter'] );
	update_user_meta( $user_id, 'finbuzz_linkedin', $_POST['linkedin'] );
	update_user_meta( $user_id, 'finbuzz_gplus', $_POST['gplus'] );
	update_user_meta( $user_id, 'finbuzz_pinterest', $_POST['pinterest'] );
	update_user_meta( $user_id, 'finbuzz_author_designation', $_POST['finbuzz_author_designation'] );
}

/*find newest post/product with time*/
function finbuzz_is_new( $id ) {
	$now    = time();
	$published_date = get_post_time('U');
	$diff =  $now - $published_date;
	if ( $diff < 604800 ) { ?>
		<span class="new-post"><?php esc_html_e( 'New' , 'finbuzz' ); ?></span>
	<?php }
}

if( ! function_exists( 'finbuzz_post_img_src' )){
	function finbuzz_post_img_src( $size = 'finbuzz-size1' ){
		$post_id  = get_the_ID();
		if ( has_post_thumbnail( $post_id ) ) {			
			$image_id = get_post_thumbnail_id( $post_id );			
			$image    = wp_get_attachment_image_src( $image_id, $size );
			return $image[0];
		} else {
			return;
		}
	}
}

/*Post Time & time format*/
if( ! function_exists( 'finbuzz_get_time' )){

	function finbuzz_get_time( $return = false ){

		$post = get_post();
		
		# Date is disabled globally ----------
		if( FinbuzzTheme::$options['time_format'] == 'none' ){
			return false;
		}
		# Human Readable Post Dates ----------
		elseif(  FinbuzzTheme::$options['time_format'] == 'modern' ){

			$time_now  = current_time( 'timestamp' );
			$post_time = get_the_time( 'U' ) ;
			$since = sprintf( esc_html__( '%s ago' , 'finbuzz' ), human_time_diff( $post_time, $time_now ) );			
		}
		else{
			$since = get_the_date();
		}

		$post_time = '<span class="date meta-item"><span class="fa fa-clock-o" aria-hidden="true"></span>  <span>'.$since.'</span></span>';

		if( $return ){
			return $post_time;
		}

		echo wp_kses( $post_time , 'alltext_allow' );
	}

}

function widgets_scripts( $hook ) {
    if ( 'widgets.php' != $hook ) {
        return;
    }
    wp_enqueue_style( 'wp-color-picker' );
	
}
add_action( 'admin_enqueue_scripts', 'widgets_scripts' );

/*Module: Last Post update Date*/
function finbuzz_last_update() { 

	$lastupdated_args = array(
		'orderby' => 'modified',
		'posts_per_page' => 1,
		'ignore_sticky_posts' => '1'
	);
 
	$lastupdated_loop = new WP_Query( $lastupdated_args );
	
	while( $lastupdated_loop->have_posts() )  {
		$lastupdated_loop->the_post();
		echo get_the_modified_date( 'M j, Y g:i a' );
	}	
	wp_reset_postdata();
}

/*
* for most use of the get_term cached 
* This is because all time it hits and single page provide data quickly
*/
function get_img( $img ){
	$img = get_stylesheet_directory_uri() . '/assets/img/' . $img;
	return $img;
}
function get_css( $file ){
	$file = get_stylesheet_directory_uri() . '/assets/css/' . $file . '.css';
	return $file;
}
function get_js( $file ){
	$file = get_stylesheet_directory_uri() . '/assets/js/' . $file . '.js';
	return $file;
}
function filter_content( $content ){
	// wp filters
	$content = wptexturize( $content );
	$content = convert_smilies( $content );
	$content = convert_chars( $content );
	$content = wpautop( $content );
	$content = shortcode_unautop( $content );

	// remove shortcodes
	$pattern= '/\[(.+?)\]/';
	$content = preg_replace( $pattern,'',$content );

	// remove tags
	$content = strip_tags( $content );

	return $content;
}

function get_current_post_content( $post = false ) {
	if ( !$post ) {
		$post = get_post();				
	}
	$content = has_excerpt( $post->ID ) ? $post->post_excerpt : $post->post_content;
	$content = filter_content( $content );
	return $content;
}

function cached_get_term_by( $field, $value, $taxonomy, $output = OBJECT, $filter = 'raw' ){
	// ID lookups are cached
	if ( 'id' == $field )
		return get_term_by( $field, $value, $taxonomy, $output, $filter );

	$cache_key = $field . '|' . $taxonomy . '|' . md5( $value );
	$term_id = wp_cache_get( $cache_key, 'get_term_by' );

	if ( false === $term_id ){
		$term = get_term_by( $field, $value, $taxonomy );
		if ( $term && ! is_wp_error( $term ) )
			wp_cache_set( $cache_key, $term->term_id, 'get_term_by' );
		else
			wp_cache_set( $cache_key, 0, 'get_term_by' ); // if we get an invalid value, let's cache it anyway
	} else {
		$term = get_term( $term_id, $taxonomy, $output, $filter );
	}

	if ( is_wp_error( $term ) )
		$term = false;

	return $term;
}

/*for avobe reason*/
function cached_get_term_link( $term, $taxonomy = null ){
	// ID- or object-based lookups already result in cached lookups, so we can ignore those.
	if ( is_numeric( $term ) || is_object( $term ) ){
		return get_term_link( $term, $taxonomy );
	}

	$term_object = cached_get_term_by( 'slug', $term, $taxonomy );
	return get_term_link( $term_object );
}


/*only to show the first category in the post - primary category*/
function finbuzz_if_term_exists( $term, $taxonomy = '', $parent = null ){
	if ( null !== $parent ){
		return term_exists( $term, $taxonomy, $parent );
	}

	if ( ! empty( $taxonomy ) ){
		$cache_key = $term . '|' . $taxonomy;
	}else{
		$cache_key = $term;
	}

	$cache_value = wp_cache_get( $cache_key, 'term_exists' );

	//term_exists frequently returns null, but (happily) never false
	if ( false  === $cache_value ){
		$term_exists = term_exists( $term, $taxonomy );
		wp_cache_set( $cache_key, $term_exists, 'term_exists' );
	}else{
		$term_exists = $cache_value;
	}

	if ( is_wp_error( $term_exists ) )
		$term_exists = null;

	return $term_exists;
}


if( ! function_exists( 'finbuzz_get_primary_category' )){

	function finbuzz_get_primary_category() {

		if( get_post_type() != 'post' ) {
			return;
		}

		# Get the first assigned category ----------
			$get_the_category = get_the_category();
			$primary_category = array( $get_the_category[0] );

		if( ! empty( $primary_category[0] )) {
			return $primary_category;
		}
	}
}

/*only to show the first category in the post - primary category ID*/
if( ! function_exists( 'finbuzz_get_primary_category_id' )){

	function finbuzz_get_primary_category_id(){

		$primary_category = finbuzz_get_primary_category();

		if( ! empty( $primary_category[0]->term_id )){
			return $primary_category[0]->term_id;
		}

		return false;
	}
}

// Head Script
if( !function_exists( 'finbuzz_head' ) ) {
	function finbuzz_head(){
		// Hide preloader if js is disabled
		echo '<noscript><style>#preloader{display:none;}</style></noscript>';
	}	
}
add_action( 'wp_head', 'finbuzz_head', 1 );

//find the post type function 
if ( ! function_exists ( 'finbuzz_post_type' ) ) {
	function finbuzz_post_type() {
		$finbuzz_post_type_var =get_post_type( get_the_ID());
		echo esc_html( $finbuzz_post_type_var );
	}
}

/*next previous post links*/
if ( !function_exists( 'finbuzz_post_links_next_prev' ) ) {
	function finbuzz_post_links_next_prev() { ?>
	<div class="row no-gutters divider post-navigation prev-next-post">
		<?php if ( !empty( get_next_post_link())){ ?>
			<div class=" col-lg-6 col-md-6 col-sm-6 col-12 d-flex <?php if ( empty( get_previous_post_link())){ ?>-offset-md-6<?php } ?> <?php if ( is_rtl() ){ echo esc_attr( 'text-left' ); } else { echo esc_attr( 'text-left' ); } ?>">
				<div class="pad-lr-15">
					<div class="thumb">
					<?php
						$prevPost = get_next_post();
						$prevThumbnail = get_the_post_thumbnail( $prevPost->ID,'finbuzz-size6');
						previous_post_link( '%link', $prevThumbnail );
					?>
					</div>
					<div class="content next">
						<?php next_post_link( '<h5 class="post-nav-title">%link</h5>' ); ?>
						<span class="next-article">
							<?php next_post_link( '%link', esc_html__('Previous Post' , 'finbuzz' ) );?>
						</span>
					</div>
				</div>			
			</div>
		<?php } ?>

		<?php if ( !empty( get_previous_post_link())){ ?>
			<div class="col-lg-6 col-md-6 col-sm-6 col-12 d-flex <?php if ( empty( get_next_post_link())){ ?>offset-md-6<?php } ?> <?php if ( is_rtl() ){ echo esc_attr( 'text-right' ); } else { echo esc_attr( 'text-right' ); } ?>">
				<div class="pad-lr-15">
					<div class="content prev">
						<?php previous_post_link('<h5 class="post-nav-title">%link</h5>'); ?>
						<span class="prev-article">
						<?php previous_post_link( '%link', esc_html__('Next Post' , 'finbuzz' ) );?>
						</span>
					</div>
					<div class="thumb">
					<?php
						$prevPost = get_previous_post();
						$prevThumbnail = get_the_post_thumbnail( $prevPost->ID,'finbuzz-size6');
						previous_post_link( '%link', $prevThumbnail );
					?>
					</div>
				</div>
			</div>
		<?php } ?>
	</div>
<?php }
}

/*next previous portfolio links*/
if ( !function_exists( 'finbuzz_portfolio_links_next_prev' ) ) {
	function finbuzz_portfolio_links_next_prev() { ?>
	<div class="row portfolio-post-navigation">
		<?php if ( !empty( get_next_post_link())){ ?>
			<div class=" col-lg-6 col-md-6 col-sm-6 col-12  <?php if ( empty( get_previous_post_link())){ ?>-offset-md-6<?php } ?> <?php if ( is_rtl() ){ echo esc_attr( 'text-left' ); } else { echo esc_attr( 'text-left' ); } ?>">
				<div class="pad-lr-15 wow fadeInUp" data-wow-delay="300ms" data-wow-duration="800ms">
					<div class="portfolio-icon">
						<?php next_post_link( '%link', '<i class="fas fa-chevron-left"></i>' );?>
					</div>
					<div class="portfolio-content">
						<span><?php next_post_link( '%link', esc_html('Previous Post' , 'finbuzz' ) );?></span>
						<?php next_post_link( '<h3 class="post-nav-title">%link</h3>' ); ?>
					</div>
				</div>			
			</div>
		<?php } ?>

		<?php if ( !empty( get_previous_post_link())){ ?>
			<div class="col-lg-6 col-md-6 col-sm-6 col-12 mbt <?php if ( empty( get_next_post_link())){ ?>offset-md-6<?php } ?> <?php if ( is_rtl() ){ echo esc_attr( 'text-right' ); } else { echo esc_attr( 'text-right' ); } ?>">
				<div class="pad-lr-15 wow fadeInUp" data-wow-delay="300ms" data-wow-duration="800ms">
					<div class="portfolio-content">
						<span><?php previous_post_link( '%link', esc_html('Next Post' , 'finbuzz' ) );?></span>
						<?php previous_post_link('<h3 class="post-nav-title">%link</h3>'); ?>
					</div>
					<div class="portfolio-icon">
						<?php next_post_link( '%link', '<i class="fas fa-chevron-right"></i>' );?>
					</div>
				</div>
			</div>
		<?php } ?>
	</div>
<?php }
}
/*Remove the archive label*/
function finbuzz_archive_title( $title ) {
    if ( is_category() ) {
        $title = single_cat_title( '', false );
    } elseif ( is_tag() ) {
        $title = single_tag_title( '', false );
    } elseif ( is_author() ) {
        $title = '<span class="vcard">' . get_the_author() . '</span>';
    } elseif ( is_post_type_archive() ) {
        $title = post_type_archive_title( '', false );
    } elseif ( is_tax() ) {
        $title = single_term_title( '', false );
    }
  
    return $title;
}
 
add_filter( 'get_the_archive_title', 'finbuzz_archive_title' );

function w3c_validator(){
	/*----------------------------------------------------------------------------------------------------*/
	/*  W3C validator passing code
	/*----------------------------------------------------------------------------------------------------*/
	ob_start( function( $buffer ){
		$buffer = str_replace( array( '<script type="text/javascript">', "<script type='text/javascript'>" ), '<script>', $buffer );
		return $buffer;
	});
	ob_start( function( $buffer2 ){
		$buffer2 = str_replace( array( "<script type='text/javascript' src" ), '<script src', $buffer2 );
		return $buffer2;
	});
	ob_start( function( $buffer3 ){
		$buffer3 = str_replace( array( 'type="text/css"', "type='text/css'", 'type="text/css"', ), '', $buffer3 );
		return $buffer3;
	});
	ob_start( function( $buffer4 ){
		$buffer4 = str_replace( array( '<iframe frameborder="0" scrolling="no" marginheight="0" marginwidth="0"', ), '<iframe', $buffer4 );
		return $buffer4;
	});
	ob_start( function( $buffer5 ){
		$buffer5 = str_replace( array( 'aria-required="true"', ), '', $buffer5 );
		return $buffer5;
	});
}

add_action( 'template_redirect', 'w3c_validator' );

//for portfolio ajax loadmore 

add_action( 'wp_ajax_loadmore_ajax',  'portfolio_loadmore_func' );
add_action( 'wp_ajax_nopriv_loadmore_ajax', 'portfolio_loadmore_func' );

 function portfolio_loadmore_func(){

	$post_item 			= esc_attr($_REQUEST['postitem']);
	$page 				= (isset($_REQUEST['pageNumber'])) ? $_REQUEST['pageNumber'] : 0;
	$cat_id				=esc_attr( $_REQUEST['postcat'] );
	$col_class			=esc_attr( $_REQUEST['colclass'] );
	$excerpt_display	=esc_attr( $_REQUEST['excerptDisplay'] );
	$excerpt_count		=esc_attr( $_REQUEST['excerptCount'] );
	$title_count		=esc_attr( $_REQUEST['titleCount'] );
	$port_seri_display	=esc_attr( $_REQUEST['portSerDisplay'] );
	$cat_display	    =esc_attr( $_REQUEST['catDisplay'] );
	$read_more_display	=esc_attr( $_REQUEST['readMore'] );
	$thumb_size = 'finbuzz-size5';
	$args=array(
		'post_type' 		=> 'finbuzz_portfolio',
		'posts_per_page' 	=> $post_item,
		'post_status'   	=> 'publish',
		'paged'          	=> $page,
		'post__not_in' 		=> get_option( 'sticky_posts')
	);
	if ( $cat_id != 0 ) {
		$args['tax_query'] = array (
			array (
				'taxonomy' => 'finbuzz_portfolio_category',
				'field'    => 'ID',
				'terms'    => $cat_id,
			)
		);
	}
	
	$query = new WP_Query( $args );
	
	if($query->have_posts()) : while($query->have_posts()) : $query->the_post();
		$id 		        = get_the_ID();
		$portfolio_title = wp_trim_words( get_the_title(), $title_count, '' );
		$content 			= apply_filters( 'the_content', get_the_content() );
		$content 			= wp_trim_words( $content, $excerpt_count, '' );
		$finbuzz_port_no  	= get_post_meta( $id, 'portfolio_serial_num', true );
	?>
	<div class="<?php  echo esc_attr( $col_class ); ?> portfolio-item single-grid-item ">
		<div class="rtin-item">
			<div class="rtin-figure">
				<a href="<?php the_permalink(); ?>">
					<?php
						if ( has_post_thumbnail() ){
							the_post_thumbnail( $thumb_size, ['class' => 'img-fluid mb-10 width-100'] );
						} else {
							if ( !empty( FinbuzzTheme::$options['no_preview_image']['id'] ) ) {
								echo wp_get_attachment_image( FinbuzzTheme::$options['no_preview_image']['id'], $thumb_size );
							} else {
								echo '<img class="wp-post-image" src="' . FinbuzzTheme_Helper::get_img( 'noimage_370X328.jpg' ) . '" alt="'. the_title_attribute( array( 'echo'=> false ) ) .'">';
							}
						}
					?>
				</a>
				<div class="rtin-content">
					<?php if($port_seri_display=='yes'): ?>
						<div class="item-number"><?php echo esc_html( $finbuzz_port_no  ) ;?></div>
					<?php endif; ?>
					<?php if($cat_display=='yes'){ ?>
					<?php
						$i = 1;
						$term_lists = get_the_terms( get_the_ID(), 'finbuzz_portfolio_category' );
						if($term_lists){ ?>
						<div class="cat-list">
							<?php foreach ( $term_lists as $term_list ){ 
							$link = get_term_link( $term_list->term_id, 'finbuzz_portfolio_category' ); ?><?php if ( $i > 1 ){ echo esc_html( ', ' ); } ?><a href="<?php echo esc_url( $link ); ?>"><?php echo esc_html( $term_list->name ); ?></a><?php $i++; } ?>
							</div>	
					<?php } } ?>
					<h3>
						<a href="<?php echo the_permalink(); ?>">
						<?php echo wp_kses($portfolio_title,'alltext_allow');?>
						</a>
					</h3>
					<?php if($excerpt_display=='yes'){ ?>
						<p><?php echo wp_kses( $content , 'alltext_allow' ); ?></p>
					<?php } ?>
					<?php if ( $read_more_display=='yes' ) { ?>
						<div class="portfolio-btn">
							<a href="<?php the_permalink();?>" class="btn-style2">+ <span><?php echo esc_html('Read More','finbuzz'); ?></span></a>
						</div>
					<?php } ?>
				</div>
			</div>
		</div>
		
	</div>
	<?php endwhile;endif;
		wp_reset_query();
	die();
}






