
<?php
/**
 * @author  RadiusTheme
 * @since   1.0
 * @version 1.0
 */

if( !empty( FinbuzzTheme::$options['error_bodybanner'] ) ) {
	$error_bg = wp_get_attachment_image_src( FinbuzzTheme::$options['error_bodybanner'], 'full', true );
	$finbuzz_error_img = $error_bg[0];
}else {
	$finbuzz_error_img = FINBUZZ_IMG_URL . '404.png';
}

?>
<?php get_header();?>
<div id="primary" class="content-area error-page-area" >
	<div class="container">
		<div class="error-page-content">
			<?php if(FinbuzzTheme::$options['error_bg_show']){ ?>
				<div class="item-img">
					<img src="<?php echo esc_url($finbuzz_error_img); ?>">
				</div>
			<?php } ?>
			<?php if ( !empty( FinbuzzTheme::$options['error_text1'] || FinbuzzTheme::$options['ops_text']) ) { ?>
			<h2 class="text-1"><span><?php echo wp_kses( FinbuzzTheme::$options['ops_text'] , 'alltext_allow' );?></span><?php echo wp_kses( FinbuzzTheme::$options['error_text1'] , 'alltext_allow' );?></h2>
			<?php } ?>
			<?php if ( !empty(FinbuzzTheme::$options['error_text2'])) { ?>
			<p class="text-2"><?php echo wp_kses( FinbuzzTheme::$options['error_text2'] , 'alltext_allow' );?></p>
			<?php } ?>
			<div class="go-home">
			  <a href="<?php echo esc_url( home_url( '/' ) );?>" class="error-btn"><?php echo esc_html( FinbuzzTheme::$options['error_buttontext'] );?></a>
			</div>
		</div>
	</div>
</div>

<?php get_footer(); ?>