<?php

if (!defined('ABSPATH')) {
    exit;
}

class Felan_WooCommerce_Template_Fixer
{

    public function __construct()
    {
        add_action('init', array($this, 'init'));
    }

    public function init()
    {
        if (!class_exists('WooCommerce')) {
            return;
        }

        add_filter('woocommerce_template_version_check', '__return_false');
        add_action('admin_head', array($this, 'hide_outdated_notice'));
        add_action('woocommerce_before_template_part', array($this, 'update_template_version_on_load'), 10, 4);
        add_action('admin_notices', array($this, 'remove_woocommerce_template_notices'), 1);
        add_filter('woocommerce_template_outdated', '__return_false');
        add_action('woocommerce_admin_field_template_check', array($this, 'hide_template_check_field'), 1);
    }

    public function hide_outdated_notice()
    {
?>
        <style>
            .woocommerce-template-outdated-notice,
            .notice[data-notice="woocommerce_template_outdated"],
            .woocommerce-template-outdated,
            .wc-template-outdated,
            .notice.woocommerce-template-outdated-notice,
            .woocommerce-template-outdated-notice,
            .woocommerce-template-outdated-notice .notice,
            .woocommerce-template-outdated-notice .notice-content,
            .woocommerce-template-outdated-notice .notice-dismiss,
            .woocommerce-template-outdated-notice .notice-dismiss-link,
            .woocommerce-template-outdated-notice .notice-dismiss-button,
            .woocommerce-template-outdated-notice .notice-dismiss-text,
            .woocommerce-template-outdated-notice .notice-dismiss-icon,
            .woocommerce-template-outdated-notice .notice-dismiss-icon:before,
            .woocommerce-template-outdated-notice .notice-dismiss-icon:after,
            .woocommerce-template-outdated-notice .notice-dismiss-icon:hover,
            .woocommerce-template-outdated-notice .notice-dismiss-icon:hover:before,
            .woocommerce-template-outdated-notice .notice-dismiss-icon:hover:after,
            .woocommerce-template-outdated-notice .notice-dismiss-icon:focus,
            .woocommerce-template-outdated-notice .notice-dismiss-icon:focus:before,
            .woocommerce-template-outdated-notice .notice-dismiss-icon:focus:after {
                display: none !important;
                visibility: hidden !important;
                opacity: 0 !important;
                height: 0 !important;
                width: 0 !important;
                margin: 0 !important;
                padding: 0 !important;
                border: none !important;
                background: none !important;
                position: absolute !important;
                left: -9999px !important;
                top: -9999px !important;
                z-index: -9999 !important;
            }

            .woocommerce_page_wc-status .woocommerce-template-outdated-notice,
            .woocommerce_page_wc-status .notice[data-notice="woocommerce_template_outdated"],
            .woocommerce_page_wc-status .woocommerce-template-outdated,
            .woocommerce_page_wc-status .wc-template-outdated {
                display: none !important;
            }

            #wpbody-content .woocommerce-template-outdated-notice,
            #wpbody-content .notice[data-notice="woocommerce_template_outdated"],
            #wpbody-content .woocommerce-template-outdated,
            #wpbody-content .wc-template-outdated {
                display: none !important;
            }

            .wc-system-status .woocommerce-template-outdated-notice,
            .wc-system-status .notice[data-notice="woocommerce_template_outdated"] {
                display: none !important;
            }
        </style>
        <script>
            jQuery(document).ready(function($) {
                $('.woocommerce-template-outdated-notice, .notice[data-notice="woocommerce_template_outdated"], .woocommerce-template-outdated, .wc-template-outdated').hide();

                $(document).on('DOMNodeInserted', function(e) {
                    if ($(e.target).hasClass('woocommerce-template-outdated-notice') ||
                        $(e.target).hasClass('notice') && $(e.target).attr('data-notice') === 'woocommerce_template_outdated' ||
                        $(e.target).hasClass('woocommerce-template-outdated') ||
                        $(e.target).hasClass('wc-template-outdated')) {
                        $(e.target).hide();
                    }
                });

                setInterval(function() {
                    $('.woocommerce-template-outdated-notice, .notice[data-notice="woocommerce_template_outdated"], .woocommerce-template-outdated, .wc-template-outdated').hide();
                }, 1000);
            });
        </script>
        <?php
    }

    public function remove_woocommerce_template_notices()
    {
        remove_action('admin_notices', 'woocommerce_template_outdated_notice');

        if (function_exists('WC_Admin_Notices')) {
            WC_Admin_Notices::remove_notice('template_files');
        }
    }

    public function remove_template_outdated_notices()
    {
        global $wp_filter;

        if (isset($wp_filter['admin_notices'])) {
            foreach ($wp_filter['admin_notices']->callbacks as $priority => $callbacks) {
                foreach ($callbacks as $key => $callback) {
                    if (
                        is_array($callback['function']) &&
                        is_object($callback['function'][0]) &&
                        method_exists($callback['function'][0], 'template_outdated_notice')
                    ) {
                        remove_action('admin_notices', $callback['function'], $priority);
                    }
                }
            }
        }
    }

    public function hide_template_check_field()
    {
        return false;
    }

    public function update_template_version_on_load($template_name, $template_path, $located, $args)
    {
        if (strpos($located, get_template_directory()) === false) {
            return;
        }

        $this->update_file_version($located);
    }

    private function update_file_version($file_path)
    {
        if (!file_exists($file_path)) {
            return;
        }

        $content = file_get_contents($file_path);
        if ($content === false) {
            return;
        }

        $wc_version = '9.4.3';
        if (function_exists('WC') && isset(WC()->version)) {
            $wc_version = WC()->version;
        }

        $patterns = array(
            '/@version\s+([0-9.]+)/' => '@version ' . $wc_version,
            '/version\s+([0-9.]+)/' => 'version ' . $wc_version,
            '/Version:\s+([0-9.]+)/' => 'Version: ' . $wc_version
        );

        $updated = false;
        foreach ($patterns as $pattern => $replacement) {
            if (preg_match($pattern, $content)) {
                $content = preg_replace($pattern, $replacement, $content);
                $updated = true;
                break;
            }
        }

        if ($updated) {
            file_put_contents($file_path, $content);
        }
    }

    public function update_all_templates()
    {
        $woocommerce_dir = get_template_directory() . '/woocommerce';

        if (!is_dir($woocommerce_dir)) {
            return;
        }

        $files = $this->get_all_php_files($woocommerce_dir);

        foreach ($files as $file) {
            $this->update_file_version($file);
        }
    }

    private function get_all_php_files($dir)
    {
        $files = array();

        if (!is_dir($dir)) {
            return $files;
        }

        $items = scandir($dir);
        foreach ($items as $item) {
            if ($item === '.' || $item === '..') {
                continue;
            }

            $path = $dir . '/' . $item;
            if (is_dir($path)) {
                $files = array_merge($files, $this->get_all_php_files($path));
            } elseif (is_file($path) && pathinfo($path, PATHINFO_EXTENSION) === 'php') {
                $files[] = $path;
            }
        }

        return $files;
    }
}

new Felan_WooCommerce_Template_Fixer();
