jQuery(document).ready(function($) {
    
    function hideTemplateOutdatedNotices() {
        $('.woocommerce-template-outdated-notice, .notice[data-notice="woocommerce_template_outdated"], .woocommerce-template-outdated, .wc-template-outdated').hide();
        
        $('.woocommerce-message.updated, #message.updated.woocommerce-message').each(function() {
            var $this = $(this);
            var text = $this.text().toLowerCase();
            
            if (text.indexOf('outdated') !== -1 || 
                text.indexOf('template') !== -1 || 
                text.indexOf('copies') !== -1 ||
                text.indexOf('woocommerce template') !== -1) {
                $this.hide();
            }
        });
        
        $('.woocommerce-message, #message.updated.woocommerce-message').each(function() {
            var $this = $(this);
            var text = $this.text();
            
            if (text.indexOf('Your theme (Felan) contains outdated copies') !== -1 ||
                text.indexOf('outdated copies of some WooCommerce template files') !== -1) {
                $this.hide();
            }
        });
    }
    
    hideTemplateOutdatedNotices();
    
    setTimeout(hideTemplateOutdatedNotices, 1000);
    setTimeout(hideTemplateOutdatedNotices, 3000);
    setTimeout(hideTemplateOutdatedNotices, 5000);
    
    setInterval(hideTemplateOutdatedNotices, 2000);
    
    $(document).on('DOMNodeInserted', function(e) {
        var $target = $(e.target);
        
        if ($target.hasClass('woocommerce-template-outdated-notice') || 
            $target.hasClass('notice') && $target.attr('data-notice') === 'woocommerce_template_outdated' ||
            $target.hasClass('woocommerce-template-outdated') ||
            $target.hasClass('wc-template-outdated') ||
            $target.hasClass('woocommerce-message') ||
            $target.attr('id') === 'message' ||
            $target.text().toLowerCase().indexOf('outdated') !== -1 ||
            $target.text().toLowerCase().indexOf('template') !== -1) {
            
            $target.hide();
        }
    });
    
    $(document).ajaxComplete(function() {
        hideTemplateOutdatedNotices();
    });
    
    $(window).on('load', function() {
        hideTemplateOutdatedNotices();
    });
    
    $(window).on('hashchange', function() {
        setTimeout(hideTemplateOutdatedNotices, 500);
    });
    
    var currentUrl = window.location.href;
    setInterval(function() {
        if (window.location.href !== currentUrl) {
            currentUrl = window.location.href;
            setTimeout(hideTemplateOutdatedNotices, 500);
        }
    }, 1000);
    
    if (typeof wc_admin_meta_boxes !== 'undefined') {
        $(document).on('woocommerce_admin_notice', function(e, notice) {
            if (notice && (notice.indexOf('template') !== -1 || notice.indexOf('outdated') !== -1)) {
                e.preventDefault();
                return false;
            }
        });
    }
    
    if (window.location.href.indexOf('page=wc-status') !== -1) {
        setInterval(function() {
            $('.woocommerce-message, #message.updated.woocommerce-message').each(function() {
                var $this = $(this);
                var text = $this.text();
                
                if (text.indexOf('outdated') !== -1 || 
                    text.indexOf('template') !== -1 || 
                    text.indexOf('copies') !== -1) {
                    $this.hide();
                }
            });
        }, 1000);
    }
    
    if ($('body').hasClass('wp-admin')) {
        setInterval(function() {
            $('.woocommerce-message, #message.updated.woocommerce-message').each(function() {
                var $this = $(this);
                var text = $this.text();
                
                if (text.indexOf('Your theme (Felan) contains outdated copies') !== -1 ||
                    text.indexOf('outdated copies of some WooCommerce template files') !== -1) {
                    $this.hide();
                }
            });
        }, 1000);
    }
});
