var FELAN_STRIPE = FELAN_STRIPE || {};
(function (p) {
  "use strict";
  FELAN_STRIPE = {
    init: function () {
      this.setupForm();
    },
    setupForm: function () {
      var i = this,
        e = p(".felan-stripe-form");
      if (e.length === 0) return;
      var a = e.attr("id");
      var n = felan_stripe_vars[a];
      var t = null;
      var c = e.find(".felan-stripe-button");
      if (c.length) {
        t = StripeCheckout.configure({
          key: n.key,
          locale: "auto",
          token: function (i, a) {
            p("<input>")
              .attr({ type: "hidden", name: "stripeToken", value: i.id })
              .appendTo(e);
            p("<input>")
              .attr({ type: "hidden", name: "stripeTokenType", value: i.type })
              .appendTo(e);
            if (i.email) {
              p("<input>")
                .attr({ type: "hidden", name: "stripeEmail", value: i.email })
                .appendTo(e);
            }
            e.submit();
          },
        });
        c.on("click", function (i) {
          i.preventDefault();
          t.open(n.params);
        });
      }
      window.addEventListener("popstate", function () {
        if (t != null) {
          t.close();
        }
      });
    },
  };
  p(document).ready(function () {
    FELAN_STRIPE.init();
    var i = function (i) {
      if (i == "undefined" || i == "" || i == null) {
        i = loading_text;
      }
      var a = wp.template("felan-processing-template");
      p("body").append(a({ ico: "fa fa-spinner fa-spin", text: i }));
    };
    if (typeof felan_payment_vars !== "undefined") {
      var a = felan_payment_vars.ajax_url;
      var e = felan_payment_vars.processing_text;
      p("#felan_payment_package").on("click", function (i) {
        var a = p("input[name='felan_payment_method']:checked").val();
        var e = p("input[name='felan_package_id']").val();
        if (a == "paypal") {
          n(e);
        } else if (a == "stripe") {
          p("#felan_stripe_per_package button").trigger("click");
        } else if (a == "wire_transfer") {
          t(e);
        } else if (a == "woocheckout") {
          c(e);
        }
      });
      var n = function (i) {
        p.ajax({
          type: "POST",
          url: a,
          data: {
            action: "felan_paypal_payment_per_package_ajax",
            package_id: i,
            felan_security_payment: p("#felan_security_payment").val(),
          },
          beforeSend: function () {
            p("#felan_payment_package").append(
              '<div class="felan-loading-effect"><span class="felan-dual-ring"></span></div>'
            );
          },
          success: function (i) {
            window.location.href = i;
          },
        });
      };
      var t = function (i) {
        p.ajax({
          type: "POST",
          url: a,
          data: {
            action: "felan_wire_transfer_per_package_ajax",
            package_id: i,
            felan_security_payment: p("#felan_security_payment").val(),
          },
          beforeSend: function () {
            p("#felan_payment_package").append(
              '<div class="felan-loading-effect"><span class="felan-dual-ring"></span></div>'
            );
          },
          success: function (i) {
            window.location.href = i;
          },
        });
      };
      p("#felan_free_package").on("click", function () {
        var i = p("input[name='felan_package_id']").val();
        p.ajax({
          type: "POST",
          url: a,
          data: {
            action: "felan_free_package_ajax",
            package_id: i,
            felan_security_payment: p("#felan_security_payment").val(),
          },
          beforeSend: function () {
            p("#felan_free_package").append(
              '<div class="felan-loading-effect"><span class="felan-dual-ring"></span></div>'
            );
          },
          success: function (i) {
            window.location.href = i;
          },
        });
      });
      var c = function (i) {
        p.ajax({
          type: "POST",
          url: a,
          data: {
            action: "felan_woocommerce_payment_per_package_ajax",
            package_id: i,
            felan_security_payment: p("#felan_security_payment").val(),
          },
          beforeSend: function () {
            p("#felan_payment_package").append(
              '<div class="felan-loading-effect"><span class="felan-dual-ring"></span></div>'
            );
          },
          success: function (i) {
            window.location.href = i;
          },
        });
      };
    }
  });
})(jQuery);
