<?php
/**
 * The template part for displaying content
 *
 * @package WordPress
 * @subpackage FAQ_SAAS
 * @since FaqSaas 1.0
 */

$content_class = 'col-md-12';

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<div class="row">
    	<?php if( has_post_thumbnail()) : ?>
    		<?php $content_class = 'col-md-8'; ?>
    		<div class="col-md-4">
	        	<?php faqsaas_post_thumbnail(); ?>
		    </div>
    	<?php endif; ?>

	    <div class="<?php echo esc_attr( $content_class); ?>">
		    <footer class="entry-footer-meta">
				<div class="meta">
			      	<span class="time-ago"> <a href = "<?php the_permalink(); ?>"> <i class="fa fa-clock-o"></i> <?php echo esc_attr(human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' ago'); ?> </a></span>
	      			<?php if(has_category()): ?>
	                    <span class="category"><?php echo esc_html__('Posted in : ', 'faqsaas') ?><?php the_category('&nbsp;,&nbsp;'); ?></span>
	                <?php endif; ?>

					<?php if(comments_open() && !post_password_required()): ?>
						<span class="comments">
							<i class="fa fa-comments"></i>
							<?php comments_popup_link( esc_html__('No comment', 'faqsaas'), esc_html__('1 comment', 'faqsaas'), esc_html__('% comments', 'faqsaas'), 'article-post-meta' ); ?>
						</span>
					<?php endif; ?>
			    </div>
				<?php
					edit_post_link(
						sprintf(
							/* translators: %s: Name of current post */
							__( 'Edit Post<span class="screen-reader-text"> "%s"</span>', 'faqsaas' ),
							get_the_title()
						),
						'<span class="edit-link">',
						'</span>'
					);
				?>
			</footer>

			<h1 class="blog-title"><a href= "<?php the_permalink(); ?>" > <?php the_title(); ?></a></h1>

			<div class="faqsaas-content">
				<?php
					the_excerpt();

					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'faqsaas' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'faqsaas' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					) );
				?>
			</div>
			<a href="<?php the_permalink(); ?>" class="btn btn-small btn-primary"><?php echo esc_html__('Read More', 'faqsaas'); ?></a>
		</div>
	</div>
</article>












