<?php
/**
 * The template part for displaying single posts
 *
 * @package WordPress
 * @subpackage FAQ_SAAS
 * @since FaqSaas 1.0
 */
?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	<header class="entry-header">
		<?php the_title( '<h1 class="entry-title blog-title">', '</h1>' ); ?>
	</header><!-- .entry-header -->

	<?php faqsaas_post_thumbnail(); ?>

	<div class="meta">
		<span class="author">
	      	<i class="fa fa-user"></i>
	      	<?php esc_url(the_author_posts_link()); ?>
	    </span>
	    <span class="time-ago"><a href = "<?php the_permalink(); ?>" ><i class="fa fa-clock-o"></i> <?php echo esc_attr(human_time_diff( get_the_time('U'), current_time('timestamp') ) . ' ago'); ?></a></span>
	    <span class="category">
		    <?php if(has_category()): ?>
		        <i class="fa fa-sitemap"></i>
		        <?php the_category('&nbsp;,&nbsp;'); ?>
		    <?php endif; ?>
	    </span>
	    <?php  if(comments_open() && !post_password_required()) : ?>
		    <span class="comments">
		      	<i class="fa fa-comments"></i>
		      	<?php comments_popup_link( esc_html__('No comment', 'faqsaas'), esc_html__('1 comment', 'faqsaas'), esc_html__('% comments', 'faqsaas'), 'article-post-meta' ); ?>
		    </span>
		<?php endif; ?>
	</div>

	<div class="full-content">
		<?php
			the_content();

			wp_link_pages( array(
				'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'faqsaas' ) . '</span>',
				'after'       => '</div>',
				'link_before' => '<span>',
				'link_after'  => '</span>',
				'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'faqsaas' ) . ' </span>%',
				'separator'   => '<span class="screen-reader-text">, </span>',
			) );

			if ( '' !== get_the_author_meta( 'description' ) ) {
				get_template_part( 'template-parts/biography' );
			}
		?>
	</div>

	<div class="meta">
	    <span class="category">
		    <?php if(has_category()): ?>
		        <i class="fa fa-tags" aria-hidden="true"></i>
		        <?php the_tags( '&nbsp;', ', ', '<br />' ); ?>
		    <?php endif; ?>
	    </span>
	</div>

</article><!-- #post-## -->
