<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage FAQ_SAAS
 * @since FaqSaas 1.0
 */

get_header();

$args = array(
    'bg_color'   => '#fff',
    'bg_image'   => '',
    'bg_repeat'  => 'repeat-x',
    'bg_size'    => 'cover',
);
$main_content_bg = faqsaas_background_css( 'faqsaas_main_content_background', $args );

?>


<!-- SIngle page code **************************************************************************** -->

<div class="blog-content pt60">
    <div class="container">
        <div class="row">
            <div class="col-md-9">
                <div id="primary-blog" class="content-area-blog" style ="<?php echo esc_attr($main_content_bg); ?>" >
                    <main id="main" class="site-main-content">
                        <?php
                            while ( have_posts() ) : the_post();
                                get_template_part( 'template-parts/content', 'single' );
                                if ( is_singular( 'attachment' ) ) {
                                    the_post_navigation( array(
                                        'prev_text' => _x( '<span class="meta-nav">Published in</span><span class="post-title">%title</span>', 'Parent post link', 'faqsaas' ),
                                    ) );
                                } elseif ( is_singular( 'post' ) ) {
                                    the_post_navigation( array(
                                        'next_text' => '<span class="meta-nav" aria-hidden="true">' . esc_html__( 'Next', 'faqsaas' ) . '</span> ' .
                                            '<span class="screen-reader-text">' . esc_html__( 'Next post:', 'faqsaas' ) . '</span> ' .
                                            '<span class="post-title">%title</span>',
                                        'prev_text' => '<span class="meta-nav" aria-hidden="true">' . esc_html__( 'Previous', 'faqsaas' ) . '</span> ' .
                                            '<span class="screen-reader-text">' . esc_html__( 'Previous post:', 'faqsaas' ) . '</span> ' .
                                            '<span class="post-title">%title</span>',
                                    ) );
                                }

                                if ( comments_open() || get_comments_number() ) {
                                    comments_template();
                                }
                            endwhile;
                        ?>
                    </main><!-- .site-main -->
                </div><!-- .content-area -->
            </div>
            <div class="col-md-3">
                <?php get_sidebar(); ?>
            </div>
        </div>
    </div>
</div>

<?php get_footer(); ?>
