<?php
/**
 * The main template file
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @link http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage FAQ_SAAS
 * @since FaqSaas 1.0
 */

get_header();

// Main Content background
$args = array(
    'bg_color'   => '#fff',
    'bg_image'   => '',
    'bg_repeat'  => 'repeat-x',
    'bg_size'    => 'cover',
);
$main_content_bg = faqsaas_background_css( 'faqsaas_main_content_background', $args );

 ?>

<div class="blog-content pt60">
    <div class="container">
      	<div class="row">
	        <div class="col-md-9">
				<div id="primary-blog" class="content-area-blog" style ="<?php echo esc_attr($main_content_bg); ?>" >
					<main id="main" class="site-main-content">

						<?php

							while ( have_posts() ) : the_post();
								get_template_part( 'template-parts/content', 'page' );
								if ( comments_open() || get_comments_number() ) {
									comments_template();
								}
							endwhile;
						?>

					</main><!-- .site-main -->
				</div><!-- .content-area -->

	        </div> <!--  end blog-single -->

	        <div class="col-md-3">
				<?php get_sidebar(); ?>
	        </div>

      	</div> <!-- end of row -->

  	</div> <!-- end container -->
</div> <!-- end blog-content -->

<?php get_footer(); ?>








