<?php
/**
 * Template Name: Home-Page
 *
 */
get_header( 'home' );

?>

<div class="home-page-content">

    <div class="banner-hero">
        <?php
            $defaults = array(
                'theme_location'  => 'forum_link',
                'menu'            => 'forumlink',
                'container'       => '',
                'container_class' => '',
                'container_id'    => '',
                'menu_class'      => 'menu',
                'menu_id'         => '',
                'echo'            => true,
                'before'          => '',
                'after'           => '',
                'link_before'     => '',
                'link_after'      => '',
                'items_wrap'      => '<ul id="%1$s" class="container faqsaas-forum-menu %2$s">%3$s</ul>',
                'depth'           => 0,
                'fallback_cb'     => 'faqsaas_forum_menu::fallback',
                'walker'          => new faqsaas_forum_menu()
            );

            wp_nav_menu( $defaults );
        ?>
    </div>


    <div class="question-category">
        <div class="container">
            <div class="row">
                <?php
                    $terms = get_terms( array(
                        'taxonomy' => 'category',
                        'hide_empty' => false,
                    ) );


                 ?>

                <?php if(isset($terms) && is_array($terms)) : ?>
                    <?php foreach ($terms as $key => $value) : ?>
                        <?php
                            $args = array(
                                'post_type' => 'dwqa-question',
                                'tax_query' => array(
                                    array(
                                        'taxonomy' => 'category',
                                        'field' => 'slug',
                                        'terms' => $value->slug
                                    )
                                )
                            );
                            $postslist = get_posts( $args );
                        ?>
                        <?php if(isset( $postslist ) && !empty( $postslist )) : ?>
                        <div class="col-md-4 col-sm-6">
                            <div class="faqsaas-question-box">
                                <?php
                                    $archive_link = ''.home_url('/').'question/category/'.$value->slug.'/';
                                 ?>
                                <h4><?php echo esc_attr($value->name); ?> <span>( <?php echo esc_attr($value->count); ?> )</span> <a href="<?php echo esc_url($archive_link); ?>"><?php esc_html_e('View All', 'faqsaas'); ?></a></h4>
                                <div class="faqsass-question-list">
                                    <ul class="question-list-single">
                                        <?php foreach ($postslist as $post_key => $post_value) : ?>



                                            <li><a href="<?php echo get_permalink( $post_value->ID ); ?>"><i class="fa fa-file-text-o" aria-hidden="true"></i> <?php echo esc_attr($post_value->post_title); ?> </a></li>
                                        <?php endforeach; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div> <!-- end question-cateogry -->


<?php get_footer(); ?>
