<?php
/**
 * The template for displaying the header
 *
 * Displays all of the head element and everything up until the "site-content" div.
 *
 * @package WordPress
 * @subpackage FAQ_SAAS
 * @since FaqSaas 1.0
 */

?><!DOCTYPE html>
<html <?php language_attributes(); ?> class="no-js">
<head>
  <meta charset="<?php bloginfo( 'charset' ); ?>">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link rel="profile" href="http://gmpg.org/xfn/11">
  <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
  <link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
  <?php endif; ?>
  <?php wp_head(); ?>
</head>

<?php
    // Footer background
    $args = array(
        'bg_color'   => '#fff',
        'bg_image'   => '',
        'bg_repeat'  => 'repeat-x',
        'bg_size'    => 'cover',
    );
    $body_bg = faqsaas_background_css( 'faqsaas_body_background', $args );
 ?>

<body <?php body_class(); ?> style="<?php echo esc_attr($body_bg); ?>">
<div id="page" class="site">
    <div class="site-inner">
        <a class="skip-link screen-reader-text" href="#content"><?php _e( 'Skip to content', 'faqsaas' ); ?></a>

        <?php

            $style = '';
            $choose_options = get_post_meta( get_the_ID(), '_choose_settings', true );
            $choose_options = $choose_options ? $choose_options : 'option_panel';
            $show_banner = 'true';
            $show_breadcrumbs = 'no';
            $banner_title = get_the_title();
            $image_url = '';

            extract(faqsaas_extract_option_data(array(
                'logo' => array(FAQSAAS_IMAGE.'new-logo.png', 'faqsaas_header_icon', 'url'),
                'page_title' => array('', 'faqsaas_landing_page_title'),
                'page_sub_title' => array('', 'faqsaas_landing_page_sub_title'),
            )));

            if( is_page()  && $choose_options != 'option_panel' ) :

                extract(faqsaas_extract_page_meta_data(array(
                    'show_banner' => array('true', '_set_banner_as' ),
                    'image' => array('', '_banner_image' ),
                    'color' => array('true', '_page_color' ),
                    'banner_as' => array('true', '_set_banner_as' ),
                    'banner_title' => array( get_the_title(), '_show_page_title' ),
                    'page_title' => array(get_the_title(get_the_ID()), '_faqsaas_page_title'),
                    'page_sub_title' => array('', '_faqsaas_page_subtitle'),
                    'show_breadcrumbs' => array('no', '_show_breadcrumbs' ),
                )));

                if($image && $banner_as === 'image' ){
                    $image_url = wp_get_attachment_image_src( $image );
                }

                $args = array(
                    'bg_color'   => $color,
                    'bg_image'   => $image_url ? $image_url[0] : '',
                    'bg_repeat'  => 'repeat-x',
                    'bg_size'    => 'cover',
                );

                $style = faqsaas_page_background( $args );

            else :

                extract(faqsaas_extract_option_data(array(
                    'show_banner' => array('true', 'faqsaas_show_banner' ),
                    'show_breadcrumbs' => array('no', 'faqsaas_show_breadcrubmbs'),
                    'logo' => array(FAQSAAS_IMAGE.'new-logo.png', 'faqsaas_header_icon', 'url'),
                    'page_title' => array('', 'faqsaas_landing_page_title'),
                    'page_sub_title' => array('', 'faqsaas_landing_page_sub_title'),
                )));

                $args = array(
                    'bg_color'   => 'transparent',
                    'bg_image'   => '',
                    'bg_repeat'  => 'repeat-x',
                    'bg_size'    => 'cover',
                );
                $style = faqsaas_background_css( 'faqsaas_banner_background', $args );

            endif;


            // Header background
            $args = array(
                'bg_color'   => 'transparent',
                'bg_image'   => '',
                'bg_repeat'  => 'repeat-x',
                'bg_size'    => 'cover',
            );
            $header_bg = faqsaas_background_css( 'faqsaas_header_background', $args );
         ?>

        <header class="header" style="<?php echo esc_attr($style); ?>" >
            <nav class="navbar navbar-default"  style="<?php echo esc_attr($header_bg); ?>">
                <div class="container">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                            <img src="<?php echo esc_url($logo); ?>" alt="<?php esc_html_e('logo', 'faqsaas'); ?>">
                        </a>
                    </div>

                    <!-- Collect the nav links, forms, and other content for toggling -->
                    <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">
                        <?php
                            $defaults = array(
                                'theme_location'  => 'primary',
                                'menu'            => 'horizontal',
                                'container'       => '',
                                'container_class' => '',
                                'container_id'    => '',
                                'menu_class'      => 'menu',
                                'menu_id'         => '',
                                'echo'            => true,
                                'before'          => '',
                                'after'           => '',
                                'link_before'     => '',
                                'link_after'      => '',
                                'items_wrap'      => '<ul id="%1$s" class="nav navbar-nav navbar-right %2$s">%3$s</ul>',
                                'depth'           => 4,
                                'fallback_cb'     => 'faqsaas_nav_walker::fallback',
                                'walker'          => new faqsaas_nav_walker()
                            );

                            wp_nav_menu( $defaults );
                        ?>
                    </div><!-- /.navbar-collapse -->
                </div><!-- /.container-fluid -->
            </nav>

            <div class="header-banner">
                <?php if(is_home() || is_front_page()): ?>
                    <h3><?php esc_html_e( 'Blog', 'faqsaas' ); ?></h3>
                <?php elseif(is_category()): ?>
                    <h3><?php printf( __( 'Category Archives : %s', 'faqsaas' ), '<span>' . single_cat_title( '', false ) . '</span>' ); ?></h3>
                <?php elseif(is_tag()): ?>
                    <h3><?php printf( __( 'Tag Archives : %s', 'faqsaas' ), '<span>' . single_tag_title( '', false ) . '</span>' ); ?></h3>
                <?php elseif(is_author()): ?>
                    <?php
                        $curauth = (get_query_var('author_name')) ? get_user_by('slug', get_query_var('author_name')) : get_userdata(get_query_var('author'));
                    ?>
                    <h3><?php esc_html_e('Posts written by : ', 'faqsaas'); ?> <?php echo esc_attr($curauth->display_name); ?></h3>

                <?php elseif(is_404()): ?>
                    <h3><?php esc_html_e( 'Error 404', 'faqsaas' ); ?></h3>
                <?php elseif(is_archive()): ?>

                    <?php if ( is_day() ) : ?>
                        <h3><?php printf( __( 'Daily Archives : <span>%s</span>', 'faqsaas' ), get_the_date() ); ?></h3>
                    <?php elseif ( is_month() ) : ?>
                        <h3><?php printf( __( 'Monthly Archives : <span>%s</span>', 'faqsaas' ), get_the_date( _x( 'F Y', 'monthly archives date format', 'faqsaas' ) ) ); ?></h3>
                    <?php elseif ( is_year() ) : ?>
                        <h3><?php printf( __( 'Yearly Archives : <span>%s</span>', 'faqsaas' ), get_the_date( _x( 'Y', 'yearly archives date format', 'faqsaas' ) ) ); ?></h3>
                    <?php else : ?>
                        <h3><?php the_title(); ?></h3>
                    <?php endif; ?>

                <?php elseif(is_search()): ?>
                    <h3><?php esc_html_e( 'Search Result for "', 'faqsaas' ); ?><?php echo esc_attr(get_search_query()); ?><?php echo '"'; ?></h3>

                <?php elseif(is_page()): ?>
                    <h3><?php echo esc_attr($page_title); ?></h3>
                <?php else: ?>
                    <h3><?php the_title(); ?></h3>
                <?php endif; ?>

                <?php if( function_exists('faqsaas_breadcrumbs') && $show_breadcrumbs === 'yes' ) : ?>
                    <ul class="custom-list breadcrumbs">
                        <?php faqsaas_breadcrumbs(); ?>
                    </ul>
                <?php endif; ?>
            </div>
        </header>


        <?php
            // Main Container background
            $args = array(
                'bg_color'   => '#fff',
                'bg_image'   => '',
                'bg_repeat'  => 'repeat-x',
                'bg_size'    => 'cover',
            );
            $container_bg = faqsaas_background_css( 'faqsaas_container_background', $args );
         ?>

        <div id="content" class="site-content" style="<?php echo esc_attr($container_bg); ?>">
            <div class="container">
